/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.transmitter;

import java.util.Locale;

public class TransmitterWrapper {
    private static String workingDirectory = "";

    public static void setWorkingDirectoryPath(String path) {
        workingDirectory = path;
    }

    private static String detectArchitecture() {
        String arch = System.getProperty("os.arch").toLowerCase(Locale.US);
        if (arch.contains("64")) {
            if (arch.contains("aarch64") || arch.contains("arm64")) {
                return "ARM64";
            }
            return "X64";
        }
        if (arch.contains("arm")) {
            return "ARM";
        }
        return "X86";
    }

    public static void loadNativeLibrary() {
        String dir = System.getProperty("user.dir") + "/";
        if (!workingDirectory.isEmpty()) {
            dir = workingDirectory;
        }
        String arch = TransmitterWrapper.detectArchitecture();
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        if (osName.contains("win")) {
            System.load(dir + "Binaries/Native/Windows/" + arch + "/JavonetJvmRuntimeNative.dll");
        } else if (osName.contains("mac")) {
            System.load(dir + "/Binaries/Native/MacOs/" + arch + "/libJavonetJvmRuntimeNative.dylib");
        } else if (osName.contains("linux")) {
            if (System.getProperty("os.version").toLowerCase(Locale.US).contains("android")) {
                System.loadLibrary("JavonetJvmRuntimeNative");
            } else {
                System.load(dir + "/Binaries/Native/Linux/" + arch + "/libJavonetJvmRuntimeNative.so");
            }
        }
    }

    public static native int sendCommand(byte[] var0);

    public static native int readResponse(byte[] var0);

    public static native boolean setEmbeddedRuntime(byte var0, byte var1, byte var2, String var3);

    public static native boolean deployRuntime(byte[] var0, String var1, byte var2);

    public static native int activate(String var0);

    public static native String getNativeError();

    public static native int setConfigSource(String var0);

    public static native int setWorkingDirectory(String var0);
}

