/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreePathViewerSorter;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.IXtextEditorAware;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.ui.editor.outline.ContentOutlineNodeLabelProvider;
import org.eclipse.xtext.ui.editor.outline.IContentOutlineNode;
import org.eclipse.xtext.ui.editor.outline.IContentOutlineNodeComparer;
import org.eclipse.xtext.ui.editor.outline.IContentOutlineNodeForTextSelectionFinder;
import org.eclipse.xtext.ui.editor.outline.IOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.actions.ContentOutlineNodeAdapter;
import org.eclipse.xtext.ui.editor.outline.actions.IActionBarContributor;
import org.eclipse.xtext.ui.editor.outline.actions.IContentOutlineNodeAdapterFactory;
import org.eclipse.xtext.ui.editor.outline.linking.EditorSelectionChangedListener;
import org.eclipse.xtext.ui.editor.outline.linking.LinkingHelper;
import org.eclipse.xtext.ui.editor.outline.linking.OutlineSelectionChangedListener;

public class XtextContentOutlinePage
extends ContentOutlinePage
implements ISourceViewerAware,
IXtextEditorAware {
    static final Logger logger = Logger.getLogger(XtextContentOutlinePage.class);
    @Inject
    private IOutlineTreeProvider contentProvider;
    @Inject
    private ContentOutlineNodeLabelProvider labelProvider;
    @Deprecated
    @Inject(optional=true)
    private IContentOutlineNodeAdapterFactory outlineNodeAdapterFactory;
    @Inject
    private IActionBarContributor actionbarContributor;
    @Inject
    private IContentOutlineNodeComparer nodeComparer;
    private XtextEditor editor;
    private ISourceViewer sourceViewer;
    private OutlineSelectionChangedListener outlineSelectionChangedListener;
    private EditorSelectionChangedListener editorSelectionChangedListener;
    private IXtextModelListener modelListener;
    private Menu contextMenu;
    private static final String contextMenuID = "xtextOutlineContextMenu";
    private ViewerSorter sorter = this.createSorter();
    @Inject
    private Provider<IContentOutlineNodeForTextSelectionFinder> nodeForTextSelectionFinderProvider;

    protected ViewerSorter createSorter() {
        return new TreePathViewerSorter();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.configureViewer();
        this.configureContextMenu();
        this.configureProviders();
        this.configureDocument();
        this.registerToolbarActions(this.getSite().getActionBars());
    }

    protected void configureViewer() {
        TreeViewer viewer = this.getTreeViewer();
        viewer.setAutoExpandLevel(this.getAutoExpandLevel());
        viewer.setUseHashlookup(false);
        viewer.setComparer((IElementComparer)this.nodeComparer);
        viewer.addDoubleClickListener((IDoubleClickListener)this.getOutlineSelectionListener());
    }

    protected int getAutoExpandLevel() {
        return 2;
    }

    protected void configureContextMenu() {
        MenuManager manager = new MenuManager(contextMenuID, contextMenuID);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                XtextContentOutlinePage.this.fillContextMenu(manager);
            }
        });
        this.contextMenu = manager.createContextMenu((Control)this.getTreeViewer().getTree());
        this.getTreeViewer().getTree().setMenu(this.contextMenu);
        IPageSite site = this.getSite();
        if (this.outlineNodeAdapterFactory != null) {
            Platform.getAdapterManager().registerAdapters((IAdapterFactory)this.outlineNodeAdapterFactory, IContentOutlineNode.class);
        }
        site.registerContextMenu("org.eclipse.xtext.ui.outline", manager, (ISelectionProvider)this.getTreeViewer());
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void configureProviders() {
        this.getTreeViewer().setContentProvider((IContentProvider)this.contentProvider);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new DelegatorLabelProvider(this.labelProvider));
    }

    protected void configureDocument() {
        if (this.sourceViewer != null) {
            IDocument document = this.sourceViewer.getDocument();
            IXtextDocument xtextDocument = XtextDocumentUtil.get(document);
            this.installModelListener();
            this.internalSetInput(xtextDocument, true);
        }
    }

    private void installModelListener() {
        IDocument document;
        IXtextDocument xtextDocument;
        if (this.sourceViewer != null && (xtextDocument = XtextDocumentUtil.get(document = this.sourceViewer.getDocument())) != null) {
            if (this.modelListener == null) {
                this.modelListener = new IXtextModelListener(){

                    public void modelChanged(XtextResource resource) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Document has been changed. Triggering update of outline.");
                        }
                        XtextContentOutlinePage.this.refresh();
                    }
                };
            }
            xtextDocument.addModelListener(this.modelListener);
        }
    }

    private void uninstallModelListener() {
        IDocument document;
        IXtextDocument xtextDocument;
        if (this.sourceViewer != null && (xtextDocument = XtextDocumentUtil.get(document = this.sourceViewer.getDocument())) != null) {
            xtextDocument.removeModelListener(this.modelListener);
        }
    }

    public IXtextDocument getDocument() {
        return XtextDocumentUtil.get(this.getSourceViewer());
    }

    protected void registerToolbarActions(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        if (this.actionbarContributor != null) {
            this.actionbarContributor.init(toolBarManager, this);
        }
    }

    public void dispose() {
        this.getTreeViewer().removeDoubleClickListener((IDoubleClickListener)this.outlineSelectionChangedListener);
        this.outlineSelectionChangedListener.uninstall((ISelectionProvider)this);
        this.outlineSelectionChangedListener = null;
        this.editorSelectionChangedListener.uninstall(this.sourceViewer.getSelectionProvider());
        this.editorSelectionChangedListener = null;
        this.uninstallModelListener();
        if (this.editor != null) {
            this.editor.outlinePageClosed();
            this.editor = null;
        }
        this.contentProvider.dispose();
        this.contentProvider = null;
        super.dispose();
    }

    protected void runInSWTThread(Runnable runnable) {
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    private void internalSetInput(IXtextDocument xtextDocument, boolean initial) {
        TreeViewer tree = this.getTreeViewer();
        if (tree != null) {
            Object[] expandedElements = null;
            expandedElements = tree.getExpandedElements();
            tree.setInput((Object)xtextDocument);
            if (expandedElements != null && expandedElements.length > 0) {
                tree.setExpandedElements(expandedElements);
            }
        }
    }

    public void setSourceViewer(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
        if (sourceViewer != null) {
            this.getOutlineSelectionListener().install((ISelectionProvider)this);
            this.getEditorSelectionChangedListener().install(sourceViewer.getSelectionProvider());
        }
    }

    public ISourceViewer getSourceViewer() {
        return this.sourceViewer;
    }

    public void setEditor(XtextEditor editor) {
        this.editor = editor;
    }

    public XtextEditor getEditor() {
        return this.editor;
    }

    private OutlineSelectionChangedListener getOutlineSelectionListener() {
        if (this.outlineSelectionChangedListener == null) {
            this.outlineSelectionChangedListener = new OutlineSelectionChangedListener(this);
        }
        return this.outlineSelectionChangedListener;
    }

    private EditorSelectionChangedListener getEditorSelectionChangedListener() {
        if (this.editorSelectionChangedListener == null) {
            this.editorSelectionChangedListener = new EditorSelectionChangedListener(this);
        }
        return this.editorSelectionChangedListener;
    }

    public boolean isLinkingEnabled() {
        return LinkingHelper.isLinkingEnabled();
    }

    public void setLinkingEnabled(boolean enabled) {
        LinkingHelper.setLinkingEnabled(enabled);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().setSelection(selection, reveal);
        }
    }

    public void synchronizeOutlinePage() {
        Point textSelection;
        if (this.isLinkingEnabled() && !this.outlineSelectionRegionEqualsTextSelection(textSelection = this.getSourceViewer().getTextWidget().getSelection())) {
            IContentOutlineNodeForTextSelectionFinder nodeForTextSelectionFinder = (IContentOutlineNodeForTextSelectionFinder)this.nodeForTextSelectionFinderProvider.get();
            nodeForTextSelectionFinder.setTextSelection(textSelection);
            Object[] objectArray = this.contentProvider.getElements(null);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object rootElement = objectArray[n2];
                if (rootElement instanceof IContentOutlineNode) {
                    nodeForTextSelectionFinder.traverse((IContentOutlineNode)rootElement);
                }
                ++n2;
            }
            IContentOutlineNode bestMatch = nodeForTextSelectionFinder.getBestMatch();
            if (bestMatch != null) {
                this.outlineSelectionChangedListener.uninstall((ISelectionProvider)this);
                this.setSelection((ISelection)new StructuredSelection((Object)bestMatch), true);
                this.outlineSelectionChangedListener.install((ISelectionProvider)this);
            }
        }
    }

    protected boolean outlineSelectionRegionEqualsTextSelection(Point textSelection) {
        IRegion nodeRegion;
        Object outlineSelectedElement;
        ITreeSelection outlineSelection = (ITreeSelection)this.getTreeViewer().getSelection();
        return outlineSelection.size() == 1 && (outlineSelectedElement = outlineSelection.getFirstElement()) instanceof IContentOutlineNode && (nodeRegion = ((IContentOutlineNode)outlineSelectedElement).getRegion()) != null && nodeRegion.getOffset() == textSelection.x && nodeRegion.getOffset() + nodeRegion.getLength() == textSelection.y;
    }

    @Deprecated
    public void synchronizeOutlinePage(EObject eObject) {
        IContentOutlineNode mostSignificantOutlineNode;
        if (this.isLinkingEnabled() && (mostSignificantOutlineNode = this.findMostSignificantOutlineNode(eObject)) != null) {
            this.outlineSelectionChangedListener.uninstall((ISelectionProvider)this);
            this.setSelection((ISelection)new StructuredSelection((Object)mostSignificantOutlineNode), true);
            this.outlineSelectionChangedListener.install((ISelectionProvider)this);
        }
    }

    @Deprecated
    protected IContentOutlineNode findMostSignificantOutlineNode(EObject eObject) {
        if (eObject != null) {
            ContentOutlineNodeAdapter adapter = (ContentOutlineNodeAdapter)EcoreUtil.getAdapter((List)eObject.eAdapters(), IContentOutlineNode.class);
            if (adapter != null) {
                IContentOutlineNode contentOutlineNode = adapter.getContentOutlineNode();
                if (contentOutlineNode != null) {
                    return contentOutlineNode;
                }
            } else {
                return this.findMostSignificantOutlineNode(eObject.eContainer());
            }
        }
        return null;
    }

    public void setSorted(boolean sorted) {
        if (this.getTreeViewer() != null) {
            if (sorted) {
                this.getTreeViewer().setSorter(this.sorter);
            } else {
                this.getTreeViewer().setSorter(null);
            }
        }
    }

    public void enableFilter(ViewerFilter filter) {
        if (this.getTreeViewer() != null) {
            ViewerFilter[] filters;
            ViewerFilter[] viewerFilterArray = filters = this.getTreeViewer().getFilters();
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter viewerFilter = viewerFilterArray[n2];
                if (viewerFilter.equals(filter)) {
                    return;
                }
                ++n2;
            }
            this.getTreeViewer().addFilter(filter);
        }
    }

    public void disableFilter(ViewerFilter filter) {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().removeFilter(filter);
        }
    }

    protected void refresh() {
        this.runInSWTThread(new Runnable(){

            public void run() {
                TreeViewer tv = XtextContentOutlinePage.this.getTreeViewer();
                if (tv != null) {
                    IDocument document = XtextContentOutlinePage.this.sourceViewer.getDocument();
                    XtextContentOutlinePage.this.internalSetInput(XtextDocumentUtil.get(document), false);
                    tv.refresh();
                    XtextContentOutlinePage.this.synchronizeOutlinePage();
                }
            }
        });
    }

    protected static class DelegatorLabelProvider
    extends DelegatingStyledCellLabelProvider
    implements ILabelProvider {
        public DelegatorLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider) {
            super(labelProvider);
        }

        public String getText(Object element) {
            StyledString styledText = this.getStyledText(element);
            return styledText != null ? styledText.getString() : null;
        }
    }
}

