/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.xtext.ui.util.Messages;
import org.eclipse.xtext.ui.util.ProjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProjectFactory
extends ProjectFactory {
    private static final Logger logger = Logger.getLogger(JavaProjectFactory.class);

    @Override
    protected void enhanceProject(IProject project, SubMonitor monitor, Shell shell) throws CoreException {
        super.enhanceProject(project, monitor, shell);
        if (this.builderIds.contains("org.eclipse.jdt.core.javabuilder")) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            try {
                subMonitor.subTask(String.valueOf(Messages.JavaProjectFactory_ConfigureJavaProject) + this.projectName);
                IJavaProject javaProject = JavaCore.create((IProject)project);
                ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
                IProject[] iProjectArray = project.getReferencingProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject referencedProject = iProjectArray[n2];
                    IClasspathEntry referencedProjectClasspathEntry = JavaCore.newProjectEntry((IPath)referencedProject.getFullPath());
                    classpathEntries.add(referencedProjectClasspathEntry);
                    ++n2;
                }
                for (String folderName : this.folders) {
                    IFolder sourceFolder = project.getFolder(folderName);
                    IClasspathEntry srcClasspathEntry = JavaCore.newSourceEntry((IPath)sourceFolder.getFullPath());
                    classpathEntries.add(srcClasspathEntry);
                }
                classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.5")));
                classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
                javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), (IProgressMonitor)subMonitor.newChild(1));
                javaProject.setOutputLocation((IPath)new Path("/" + project.getName() + "/bin"), (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (JavaModelException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public JavaProjectFactory addBuilderIds(String ... builderIds) {
        return (JavaProjectFactory)super.addBuilderIds(builderIds);
    }

    @Override
    public JavaProjectFactory addFolders(List<String> folders) {
        return (JavaProjectFactory)super.addFolders(folders);
    }

    @Override
    public JavaProjectFactory setProjectName(String projectName) {
        return (JavaProjectFactory)super.setProjectName(projectName);
    }

    @Override
    public JavaProjectFactory addProjectNatures(String ... projectNatures) {
        return (JavaProjectFactory)super.addProjectNatures(projectNatures);
    }

    @Override
    public JavaProjectFactory addReferencedProjects(List<IProject> referencedProjects) {
        return (JavaProjectFactory)super.addReferencedProjects(referencedProjects);
    }

    @Override
    public JavaProjectFactory setLocation(IPath location) {
        return (JavaProjectFactory)super.setLocation(location);
    }

    @Override
    public JavaProjectFactory addWorkingSets(List<IWorkingSet> workingSets) {
        return (JavaProjectFactory)super.addWorkingSets(workingSets);
    }
}

