/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline;

import com.google.inject.ImplementedBy;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.xtext.ui.editor.outline.IContentOutlineNode;

@ImplementedBy(value=Default.class)
public interface IContentOutlineNodeForTextSelectionFinder {
    public void setTextSelection(Point var1);

    public void traverse(IContentOutlineNode var1);

    public IContentOutlineNode getBestMatch();

    public static class Default
    implements IContentOutlineNodeForTextSelectionFinder {
        private IContentOutlineNode currentBestMatch;
        private IRegion textRegion;

        public void setTextSelection(Point textSelection) {
            this.textRegion = new Region(textSelection.x, textSelection.y - textSelection.x);
        }

        public IContentOutlineNode getBestMatch() {
            return this.currentBestMatch;
        }

        public void traverse(IContentOutlineNode node) {
            if (this.textRegion == null) {
                throw new IllegalStateException("region must be set");
            }
            IRegion nodeRegion = node.getRegion();
            if (nodeRegion != null && this.contains(nodeRegion, this.textRegion) && (this.currentBestMatch == null || this.contains(this.currentBestMatch.getRegion(), nodeRegion))) {
                this.currentBestMatch = node;
            }
            IContentOutlineNode[] iContentOutlineNodeArray = node.getChildrenAsArray();
            int n = iContentOutlineNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContentOutlineNode child = iContentOutlineNodeArray[n2];
                this.traverse(child);
                ++n2;
            }
        }

        protected boolean contains(IRegion container, IRegion contained) {
            return container.getOffset() <= contained.getOffset() && container.getOffset() + container.getLength() >= contained.getOffset() + contained.getLength();
        }
    }
}

