/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.rename;

import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.xtext.ide.serializer.IEmfResourceChange;
import org.eclipse.xtext.ide.serializer.ITextDocumentChange;
import org.eclipse.xtext.ide.server.WorkspaceManager;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ChangeConverter
implements IAcceptor<IEmfResourceChange> {
    private final WorkspaceManager workspaceManager;
    private final IResourceServiceProvider.Registry registry;
    private final WorkspaceEdit edit;

    protected ChangeConverter(WorkspaceManager workspaceManager, IResourceServiceProvider.Registry registry, WorkspaceEdit edit) {
        this.workspaceManager = workspaceManager;
        this.registry = registry;
        this.edit = edit;
    }

    public void accept(IEmfResourceChange change) {
        this.handleReplacements(change);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _handleReplacements(IEmfResourceChange change) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            URI uri = change.getResource().getURI();
            change.getResource().save((OutputStream)outputStream, null);
            byte[] _byteArray = outputStream.toByteArray();
            String _charset = this.getCharset(change.getResource());
            String newContent = new String(_byteArray, _charset);
            Functions.Function2 _function = (document, resource) -> {
                List<TextEdit> _xblockexpression = null;
                Position _position = document.getPosition(0);
                Position _position_1 = document.getPosition(document.getContents().length());
                Range range = new Range(_position, _position_1);
                TextEdit textEdit = new TextEdit(range, newContent);
                _xblockexpression = this.addTextEdit(uri, textEdit);
                return _xblockexpression;
            };
            this.workspaceManager.doRead(uri, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String getCharset(Resource resource) {
        String _xblockexpression = null;
        IEncodingProvider xtextEncodingProvider = (IEncodingProvider)this.registry.getResourceServiceProvider(resource.getURI()).get(IEncodingProvider.class);
        String _xifexpression = null;
        if (xtextEncodingProvider != null) {
            return xtextEncodingProvider.getEncoding(resource.getURI());
        }
        String _xifexpression_1 = null;
        _xifexpression_1 = resource instanceof XMLResource ? ((XMLResource)resource).getEncoding() : Charset.defaultCharset().toString();
        _xblockexpression = _xifexpression = _xifexpression_1;
        return _xblockexpression;
    }

    protected void _handleReplacements(ITextDocumentChange change) {
        boolean _greaterThan;
        int _size = change.getReplacements().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            URI uri = change.getNewURI();
            Functions.Function2 _function = (document, resource) -> {
                List<TextEdit> _xblockexpression = null;
                Functions.Function1 _function_1 = replacement -> {
                    TextEdit _xblockexpression_1 = null;
                    Position start = document.getPosition(replacement.getOffset());
                    int _offset = replacement.getOffset();
                    int _length = replacement.getLength();
                    int _plus = _offset + _length;
                    Position end = document.getPosition(_plus);
                    Range range = new Range(start, end);
                    String _replacementText = replacement.getReplacementText();
                    _xblockexpression_1 = new TextEdit(range, _replacementText);
                    return _xblockexpression_1;
                };
                List textEdits = ListExtensions.map(change.getReplacements(), (Functions.Function1)_function_1);
                _xblockexpression = this.addTextEdit(uri, (TextEdit[])Conversions.unwrapArray((Object)textEdits, TextEdit.class));
                return _xblockexpression;
            };
            this.workspaceManager.doRead(uri, _function);
        }
    }

    protected List<TextEdit> addTextEdit(URI uri, TextEdit ... textEdit) {
        return this.edit.getChanges().put(uri.toString(), (List)Conversions.doWrapArray((Object)textEdit));
    }

    protected void handleReplacements(IEmfResourceChange change) {
        if (change instanceof ITextDocumentChange) {
            this._handleReplacements((ITextDocumentChange)change);
            return;
        }
        if (change != null) {
            this._handleReplacements(change);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(change).toString());
    }

    public static class Factory {
        @Inject
        private IResourceServiceProvider.Registry registry;

        public ChangeConverter create(WorkspaceManager workspaceManager, WorkspaceEdit edit) {
            return new ChangeConverter(workspaceManager, this.registry, edit);
        }
    }
}

