/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.incremental;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Log
public class ResourceURICollector {
    private static final Logger LOG = Logger.getLogger(ResourceURICollector.class);

    public Set<URI> collectAllResources(Iterable<URI> roots, Set<String> fileExtensions) {
        boolean _isInfoEnabled = LOG.isInfoEnabled();
        if (_isInfoEnabled) {
            LOG.info((Object)"Collecting source models.");
        }
        long startedAt = System.currentTimeMillis();
        Set<URI> result = this.collectResources(roots, fileExtensions);
        boolean _isDebugEnabled = LOG.isDebugEnabled();
        if (_isDebugEnabled) {
            long _currentTimeMillis = System.currentTimeMillis();
            long _minus = _currentTimeMillis - startedAt;
            String _plus = "Finished collecting source models. Took: " + Long.valueOf(_minus);
            String _plus_1 = _plus + " ms.";
            LOG.debug((Object)_plus_1);
        }
        return result;
    }

    protected Set<URI> collectResources(Iterable<URI> roots, Set<String> fileExtensions) {
        Set extensions = IterableExtensions.toSet((Iterable)Iterables.concat(fileExtensions, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"java"}))));
        Functions.Function1 _function = it -> it.toFileString();
        Predicate _function_1 = it -> extensions.contains(it.fileExtension());
        Multimap modelsFound = new PathTraverser().resolvePathes(IterableExtensions.toList((Iterable)IterableExtensions.map(roots, (Functions.Function1)_function)), _function_1);
        BiConsumer<String, Collection> _function_2 = (path, resource) -> {
            File file = new File((String)path);
            if (resource != null && !file.isDirectory() && file.getName().endsWith(".jar")) {
                this.registerBundle(file);
            }
        };
        modelsFound.asMap().forEach(_function_2);
        return IterableExtensions.toSet((Iterable)modelsFound.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerBundle(File file) {
        block25: {
            JarFile jarFile = null;
            try {
                JarFile _jarFile;
                jarFile = _jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) {
                    return;
                }
                String name = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                if (name != null) {
                    boolean _containsKey;
                    int indexOf = name.indexOf(";");
                    if (indexOf > 0) {
                        name = name.substring(0, indexOf);
                    }
                    if (_containsKey = EcorePlugin.getPlatformResourceMap().containsKey(name)) {
                        return;
                    }
                    URI _createFileURI = URI.createFileURI((String)file.getAbsolutePath());
                    String _plus = "archive:" + _createFileURI;
                    String path = _plus + "!/";
                    EcorePlugin.getPlatformResourceMap().put(name, URI.createURI((String)path));
                }
            }
            catch (Throwable _t) {
                if (_t instanceof ZipException) {
                    String _absolutePath = file.getAbsolutePath();
                    String _plus_1 = "Could not open Jar file " + _absolutePath;
                    String _plus_2 = _plus_1 + ".";
                    LOG.info((Object)_plus_2);
                    break block25;
                }
                if (_t instanceof Exception) {
                    Exception e_1 = (Exception)_t;
                    LOG.error((Object)file.getAbsolutePath(), (Throwable)e_1);
                    break block25;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            finally {
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (Throwable _t_1) {
                    if (_t_1 instanceof IOException) {
                        IOException e_2 = (IOException)_t_1;
                        LOG.error((Object)jarFile, (Throwable)e_2);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t_1);
                }
            }
        }
    }
}

