/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.validation.UIStrings;
import org.eclipse.xtext.xtend2.jvmmodel.IXtend2JvmAssociations;
import org.eclipse.xtext.xtend2.ui.labeling.Xtend2Images;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;
import org.eclipse.xtext.xtend2.xtend2.XtendConstructor;
import org.eclipse.xtext.xtend2.xtend2.XtendField;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;
import org.eclipse.xtext.xtend2.xtend2.XtendImport;

public class Xtend2LabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    private UIStrings uiStrings;
    @Inject
    private Xtend2Images images;
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private IXtend2JvmAssociations associations;

    @Inject
    public Xtend2LabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    public Image image(XtendFile element) {
        return this.images.forFile();
    }

    public Image image(XtendImport element) {
        return this.images.forImport();
    }

    public Image image(XtendClass element) {
        JvmGenericType inferredType = this.associations.getInferredType(element);
        return this.images.forClass(inferredType.getVisibility());
    }

    public Image image(XtendFunction element) {
        JvmOperation inferredOperation = this.associations.getDirectlyInferredOperation(element);
        return this.images.forFunction(inferredOperation.getVisibility(), inferredOperation.isStatic());
    }

    public Image image(JvmOperation element) {
        return this.images.forDispatcherFunction(element.getVisibility(), element.isStatic());
    }

    public Image image(XtendConstructor element) {
        JvmConstructor inferredConstructor = this.associations.getInferredConstructor(element);
        return this.images.forConstructor(inferredConstructor.getVisibility());
    }

    public Image image(JvmConstructor element) {
        return this.images.forConstructor(element.getVisibility());
    }

    public Image image(XtendField element) {
        JvmField inferredField = this.associations.getJvmField(element);
        return this.images.forField(inferredField.getVisibility(), inferredField.isStatic(), element.isExtension());
    }

    public Image image(JvmField element) {
        return this.images.forField(element.getVisibility(), element.isStatic(), false);
    }

    public String text(XtendFile element) {
        return element.eResource().getURI().trimFileExtension().lastSegment();
    }

    public String text(XtendImport element) {
        return element.getImportedNamespace();
    }

    public String text(XtendClass element) {
        return String.valueOf(element.getName()) + (element.getTypeParameters().isEmpty() ? "" : this.uiStrings.typeParameters((Iterable)element.getTypeParameters()));
    }

    public String text(XtendConstructor element) {
        return "new" + this.uiStrings.parameters((JvmIdentifiableElement)this.associations.getInferredConstructor(element));
    }

    public String text(JvmConstructor element) {
        return "new" + this.uiStrings.parameters((JvmIdentifiableElement)element);
    }

    public Object text(XtendFunction element) {
        return this.signature(element.getName(), (JvmIdentifiableElement)this.associations.getDirectlyInferredOperation(element));
    }

    public Object text(JvmOperation element) {
        return this.signature(element.getSimpleName(), (JvmIdentifiableElement)element);
    }

    public String text(XtendField element) {
        if (element.getName() == null && element.isExtension()) {
            return element.getType().getSimpleName();
        }
        return String.valueOf(element.getName()) + " : " + element.getType().getSimpleName();
    }

    public String text(JvmField element) {
        return String.valueOf(element.getSimpleName()) + " : " + element.getType().getSimpleName();
    }

    protected StyledString signature(String simpleName, JvmIdentifiableElement element) {
        JvmTypeReference returnType = this.typeProvider.getTypeForIdentifiable(element);
        String returnTypeString = "void";
        if (returnType != null) {
            returnTypeString = returnType instanceof JvmAnyTypeReference ? "Object" : returnType.getSimpleName();
        }
        return new StyledString(String.valueOf(simpleName) + this.uiStrings.parameters(element)).append(new StyledString(" : " + returnTypeString, StyledString.DECORATIONS_STYLER));
    }
}

