/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.quickfix;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.ui.editor.quickfix.ReplaceModification;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.TypeReferenceSerializer;
import org.eclipse.xtext.xtend2.formatting.MemberFromSuperImplementor;
import org.eclipse.xtext.xtend2.services.Xtend2GrammarAccess;
import org.eclipse.xtext.xtend2.ui.buildpath.XtendLibClasspathAdder;
import org.eclipse.xtext.xtend2.ui.contentassist.ReplacingAppendable;
import org.eclipse.xtext.xtend2.ui.edit.OrganizeImportsHandler;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;
import org.eclipse.xtext.xtend2.xtend2.XtendFile;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;
import org.eclipse.xtext.xtend2.xtend2.XtendImport;

public class Xtend2QuickfixProvider
extends DefaultQuickfixProvider {
    @Inject
    private IJavaProjectProvider projectProvider;
    @Inject
    private MemberFromSuperImplementor superMemberImplementor;
    @Inject
    private Xtend2GrammarAccess grammarAccess;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private OrganizeImportsHandler organizeImportsHandler;
    @Inject
    private ReplacingAppendable.Factory appendableFactory;
    @Inject
    private TypeReferenceSerializer typeRefSerializer;
    @Inject
    private TypeReferences typeRefs;
    @Inject
    private XtendLibClasspathAdder xtendLibAdder;

    public void createLinkingIssueResolutions(final Issue issue, final IssueResolutionAcceptor issueResolutionAcceptor) {
        IModificationContext modificationContext = this.getModificationContextFactory().createModificationContext(issue);
        final IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        if (xtextDocument != null) {
            xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource state) throws Exception {
                    EObject target = state.getEObject(issue.getUriToProblem().fragment());
                    EReference reference = Xtend2QuickfixProvider.this.getUnresolvedEReference(issue, target);
                    if (reference == null) {
                        return;
                    }
                    String issueString = xtextDocument.get(issue.getOffset().intValue(), issue.getLength().intValue());
                    IScope scope = Xtend2QuickfixProvider.this.getScopeProvider().getScope(target, reference);
                    boolean useJavaSearch = false;
                    if (TypesPackage.Literals.JVM_TYPE.isSuperTypeOf(reference.getEReferenceType())) {
                        useJavaSearch = true;
                    }
                    if (TypesPackage.Literals.JVM_CONSTRUCTOR.isSuperTypeOf(reference.getEReferenceType())) {
                        useJavaSearch = true;
                    }
                    if (useJavaSearch) {
                        IJavaSearchScope javaSearchScope = Xtend2QuickfixProvider.this.getJavaSearchScope(target);
                        Xtend2QuickfixProvider.this.createImportProposals(issue, issueString, javaSearchScope, issueResolutionAcceptor);
                        scope = Xtend2QuickfixProvider.this.getImportedTypesScope(target, issueString, scope, javaSearchScope);
                    }
                    ArrayList discardedDescriptions = Lists.newArrayList();
                    HashSet qualifiedNames = Sets.newHashSet();
                    int addedDescriptions = 0;
                    int checkedDescriptions = 0;
                    for (IEObjectDescription referableElement : Xtend2QuickfixProvider.this.queryScope(scope)) {
                        String referableElementQualifiedName = Xtend2QuickfixProvider.this.getQualifiedNameConverter().toString(referableElement.getQualifiedName());
                        if (useJavaSearch || Xtend2QuickfixProvider.this.getSimilarityMatcher().isSimilar(issueString, Xtend2QuickfixProvider.this.getQualifiedNameConverter().toString(referableElement.getName()))) {
                            ++addedDescriptions;
                            this.createResolution(issueString, referableElement);
                            qualifiedNames.add(referableElementQualifiedName);
                        } else if (qualifiedNames.add(referableElementQualifiedName)) {
                            discardedDescriptions.add(referableElement);
                        }
                        if (++checkedDescriptions > 100) break;
                    }
                    if (discardedDescriptions.size() + addedDescriptions <= 5) {
                        for (IEObjectDescription referableElement : discardedDescriptions) {
                            this.createResolution(issueString, referableElement);
                        }
                    }
                }

                public void createResolution(String issueString, IEObjectDescription solution) {
                    String replacement = Xtend2QuickfixProvider.this.getQualifiedNameConverter().toString(solution.getName());
                    String replaceLabel = Xtend2QuickfixProvider.this.fixCrossReferenceLabel(issueString, replacement);
                    issueResolutionAcceptor.accept(issue, replaceLabel, replaceLabel, Xtend2QuickfixProvider.this.fixCrossReferenceImage(issueString, replacement), (IModification)new ReplaceModification(issue, replacement));
                }
            });
        }
    }

    protected IJavaSearchScope getJavaSearchScope(EObject model) {
        if (model == null || model.eResource() == null || model.eResource().getResourceSet() == null) {
            return null;
        }
        IJavaProject javaProject = this.projectProvider.getJavaProject(model.eResource().getResourceSet());
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
        return searchScope;
    }

    protected IScope getImportedTypesScope(EObject model, final String misspelled, final IScope actualScope, IJavaSearchScope scope) {
        if (scope == null) {
            return IScope.NULLSCOPE;
        }
        try {
            XtendFile xtendFile = (XtendFile)EcoreUtil2.getContainerOfType((EObject)model, XtendFile.class);
            HashSet visiblePackages = Sets.newHashSet((Object[])new String[]{"java.lang"});
            visiblePackages.add("");
            if (xtendFile.getPackage() != null) {
                visiblePackages.add(xtendFile.getPackage());
            }
            HashSet importedTypes = Sets.newHashSet();
            final HashSet seen = Sets.newHashSet();
            for (XtendImport importedNamespace : xtendFile.getImports()) {
                if (importedNamespace.getImportedNamespace() == null) continue;
                String importedAsString = importedNamespace.getImportedNamespace();
                if (importedNamespace.isWildcard()) {
                    importedAsString = importedAsString.substring(0, importedAsString.length() - 2);
                    if (!importedNamespace.isStatic()) {
                        visiblePackages.add(importedAsString);
                        continue;
                    }
                    importedTypes.add(importedAsString);
                    continue;
                }
                importedTypes.add(importedAsString);
            }
            SearchEngine searchEngine = new SearchEngine();
            final ArrayList validProposals = Lists.newArrayList();
            for (String importedType : importedTypes) {
                QualifiedName qualifiedName;
                Iterator iterator;
                if (validProposals.size() > 5 || !seen.add(importedType)) continue;
                int dot = importedType.lastIndexOf(46);
                if (dot != -1) {
                    importedType = importedType.substring(dot + 1);
                }
                if (!this.isSimilarTypeName(misspelled, importedType) || !(iterator = actualScope.getElements(qualifiedName = this.getQualifiedNameConverter().toQualifiedName(importedType)).iterator()).hasNext()) continue;
                IEObjectDescription element = (IEObjectDescription)iterator.next();
                validProposals.add(new AliasedEObjectDescription(qualifiedName, element));
            }
            for (String visiblePackage : visiblePackages) {
                if (validProposals.size() > 5) continue;
                searchEngine.searchAllTypeNames(visiblePackage.toCharArray(), 0, null, 0, 0, scope, new TypeNameRequestor(){

                    public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                        QualifiedName qualifiedName;
                        Iterator iterator;
                        String fqNameAsString;
                        StringBuilder typeNameBuilder = new StringBuilder(simpleTypeName.length);
                        char[][] cArray = enclosingTypeNames;
                        int n = enclosingTypeNames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            char[] enclosingType = cArray[n2];
                            typeNameBuilder.append(enclosingType);
                            typeNameBuilder.append('$');
                            ++n2;
                        }
                        typeNameBuilder.append(simpleTypeName);
                        String typeName = typeNameBuilder.toString();
                        if (Xtend2QuickfixProvider.this.isSimilarTypeName(misspelled, typeName) && seen.add(fqNameAsString = Xtend2QuickfixProvider.this.getQualifiedTypeName(packageName, enclosingTypeNames, simpleTypeName)) && (iterator = actualScope.getElements(qualifiedName = Xtend2QuickfixProvider.this.getQualifiedNameConverter().toQualifiedName(typeName)).iterator()).hasNext()) {
                            IEObjectDescription element = (IEObjectDescription)iterator.next();
                            validProposals.add(new AliasedEObjectDescription(qualifiedName, element));
                        }
                    }
                }, 3, (IProgressMonitor)new NullProgressMonitor(){

                    public boolean isCanceled() {
                        return validProposals.size() > 5;
                    }
                });
            }
            return new SimpleScope((Iterable)validProposals);
        }
        catch (JavaModelException jme) {
            return IScope.NULLSCOPE;
        }
    }

    protected boolean isSimilarTypeName(String s0, String s1) {
        double levenshteinDistance = StringUtils.getLevenshteinDistance((String)s0, (String)s1);
        return levenshteinDistance <= 3.0;
    }

    protected String getQualifiedTypeName(char[] packageName, char[][] enclosingTypeNames, char[] simpleTypeName) {
        StringBuilder fqName = new StringBuilder(packageName.length + simpleTypeName.length + 1);
        if (packageName.length != 0) {
            fqName.append(packageName);
            fqName.append('.');
        }
        char[][] cArray = enclosingTypeNames;
        int n = enclosingTypeNames.length;
        int n2 = 0;
        while (n2 < n) {
            char[] enclosingType = cArray[n2];
            fqName.append(enclosingType);
            fqName.append('$');
            ++n2;
        }
        fqName.append(simpleTypeName);
        String fqNameAsString = fqName.toString();
        return fqNameAsString;
    }

    protected void createImportProposals(final Issue issue, String typeSimpleName, IJavaSearchScope searchScope, final IssueResolutionAcceptor acceptor) throws JavaModelException {
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.searchAllTypeNames(null, 0, typeSimpleName.toCharArray(), 0, 0, searchScope, new TypeNameRequestor(){

            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                final String qualifiedTypeName = Xtend2QuickfixProvider.this.getQualifiedTypeName(packageName, enclosingTypeNames, simpleTypeName);
                String label = "Import '" + new String(simpleTypeName) + "' (" + new String(packageName) + ")";
                acceptor.accept(issue, label, label, "fix_indent.gif", new ISemanticModification(){

                    public void apply(EObject element, IModificationContext context) throws Exception {
                        ReplacingAppendable appendable = Xtend2QuickfixProvider.this.appendableFactory.get(context.getXtextDocument(), element, 0, 0);
                        appendable.append(Xtend2QuickfixProvider.this.typeReferences.findDeclaredType(qualifiedTypeName, (Notifier)element));
                        appendable.insertNewImports();
                    }
                });
            }
        }, 3, (IProgressMonitor)new NullProgressMonitor());
    }

    @Fix(value="org.eclipse.xtext.xtend2.validation.IssueCodes.inconsistent_indentation")
    public void fixIndentation(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Correct indentation", "Correctly indents this line in this rich string", "fix_indent.gif", new IModification(){

            public void apply(IModificationContext context) throws Exception {
                context.getXtextDocument().replace(issue.getOffset().intValue(), issue.getLength().intValue(), issue.getData()[0]);
            }
        });
    }

    @Fix(value="org.eclipse.xtext.xtend2.validation.IssueCodes.import_duplicate")
    public void fixDuplicateImport(Issue issue, IssueResolutionAcceptor acceptor) {
        this.organizeImports(issue, acceptor);
    }

    @Fix(value="org.eclipse.xtext.xtend2.validation.IssueCodes.import_wildcard_deprecated")
    public void fixDuplicateWildcardUse(Issue issue, IssueResolutionAcceptor acceptor) {
        this.organizeImports(issue, acceptor);
    }

    @Fix(value="org.eclipse.xtext.xtend2.validation.IssueCodes.import_unsued")
    public void fixUnusedImport(Issue issue, IssueResolutionAcceptor acceptor) {
        this.organizeImports(issue, acceptor);
    }

    protected void organizeImports(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Organize Imports.", "Organizes the whole import section. Removes wildcard imports as well as duplicates and unused ones.", "fix_indent.gif", new IModification(){

            public void apply(IModificationContext context) throws Exception {
                Xtend2QuickfixProvider.this.organizeImportsHandler.doOrganizeImports(context.getXtextDocument());
            }
        });
    }

    @Fix(value="org.eclipse.xtext.xtend2.validation.IssueCodes.missing_override")
    public void fixMissingOverride(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Change 'def' to 'override'", "Marks this function as 'override'", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                Xtend2QuickfixProvider.this.replaceKeyword((Keyword)Xtend2QuickfixProvider.this.grammarAccess.getMemberAccess().findKeywords(new String[]{"def"}).get(0), "override", element, context.getXtextDocument());
            }
        });
    }

    @Fix(value="org.eclipse.xtext.xtend2.validation.IssueCodes.obsolete_override")
    public void fixObsoleteOverride(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Change 'override' to 'def'", "Removes 'override' from this function", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                Xtend2QuickfixProvider.this.replaceKeyword((Keyword)Xtend2QuickfixProvider.this.grammarAccess.getMemberAccess().findKeywords(new String[]{"override"}).get(0), "def", element, context.getXtextDocument());
            }
        });
    }

    protected void replaceKeyword(Keyword keyword, String replacement, EObject container, IXtextDocument document) throws BadLocationException {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)container);
        for (ILeafNode leafNode : node.getLeafNodes()) {
            if (leafNode.getGrammarElement() != keyword) continue;
            String actualReplacement = replacement;
            if (!Character.isWhitespace(document.getChar(leafNode.getOffset() - 1))) {
                actualReplacement = " " + replacement;
            }
            document.replace(leafNode.getOffset(), leafNode.getLength(), actualReplacement);
        }
    }

    @Fix(value="org.eclipse.xtext.xtend2.validation.IssueCodes.missing_constructor")
    public void addConstuctorFromSuper(Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null) {
            int i = 0;
            while (i < issue.getData().length) {
                final URI constructorURI = URI.createURI((String)issue.getData()[i]);
                String signature = issue.getData()[i + 1];
                acceptor.accept(issue, "Add constructor " + signature, "Add constructor " + signature, "fix_indent.gif", new ISemanticModification(){

                    public void apply(EObject element, IModificationContext context) throws Exception {
                        XtendClass clazz = (XtendClass)element;
                        ReplacingAppendable appendable = Xtend2QuickfixProvider.this.appendableFactory.get(context.getXtextDocument(), (EObject)clazz, Xtend2QuickfixProvider.this.superMemberImplementor.getConstructorInsertOffset(clazz), 0);
                        EObject constructor = clazz.eResource().getResourceSet().getEObject(constructorURI, true);
                        if (constructor instanceof JvmConstructor) {
                            Xtend2QuickfixProvider.this.superMemberImplementor.appendConstructorFromSuper(clazz, (JvmConstructor)constructor, (IAppendable)appendable);
                        }
                        appendable.commitChanges();
                    }
                });
                i += 2;
            }
        }
    }

    @Fix(value="org.eclipse.xtext.xtend2.validation.IssueCodes.class_must_be_defined_abstract")
    public void implementAbstractMethods(final Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null && issue.getData().length > 0) {
            acceptor.accept(issue, "Implement abstract methods", "Implement abstract methods", "fix_indent.gif", new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    XtendClass clazz = (XtendClass)element;
                    ReplacingAppendable appendable = Xtend2QuickfixProvider.this.appendableFactory.get(context.getXtextDocument(), (EObject)clazz, Xtend2QuickfixProvider.this.superMemberImplementor.getFunctionInsertOffset(clazz), 0);
                    appendable.increaseIndentation();
                    String[] stringArray = issue.getData();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String operationUriAsString = stringArray[n2];
                        URI operationURI = URI.createURI((String)operationUriAsString);
                        EObject overridden = clazz.eResource().getResourceSet().getEObject(operationURI, true);
                        if (overridden instanceof JvmOperation) {
                            appendable.append("\n");
                            Xtend2QuickfixProvider.this.superMemberImplementor.appendOverrideFunction(clazz, (JvmOperation)overridden, (IAppendable)appendable);
                            appendable.append("\n");
                        }
                        ++n2;
                    }
                    appendable.decreaseIndentation();
                    appendable.append("\n");
                    appendable.commitChanges();
                }
            });
        }
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception")
    public void addThrowsDeclaration(final Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null && issue.getData().length > 0) {
            acceptor.accept(issue, "Add throws declaration", "Add throws declaration", "fix_indent.gif", new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    URI exceptionURI = URI.createURI((String)issue.getData()[0]);
                    XtendFunction xtendFunction = (XtendFunction)EcoreUtil2.getContainerOfType((EObject)element, XtendFunction.class);
                    XtextResource xtextResource = (XtextResource)xtendFunction.eResource();
                    EObject exception = xtextResource.getResourceSet().getEObject(exceptionURI, true);
                    if (exception instanceof JvmType) {
                        EList thrownExceptions;
                        int insertPosition;
                        JvmType exceptionType = (JvmType)exception;
                        if (xtendFunction.getExpression() == null) {
                            ICompositeNode functionNode = NodeModelUtils.findActualNodeFor((EObject)xtendFunction);
                            insertPosition = functionNode.getOffset() + functionNode.getLength();
                        } else {
                            insertPosition = NodeModelUtils.findActualNodeFor((EObject)xtendFunction.getExpression()).getOffset();
                        }
                        ReplacingAppendable appendable = Xtend2QuickfixProvider.this.appendableFactory.get(context.getXtextDocument(), (EObject)xtendFunction, insertPosition, 0);
                        if (xtendFunction.getExpression() == null) {
                            appendable.append(" ");
                        }
                        if ((thrownExceptions = xtendFunction.getExceptions()).isEmpty()) {
                            appendable.append("throws ");
                        } else {
                            appendable.append(", ");
                        }
                        Xtend2QuickfixProvider.this.typeRefSerializer.serialize((JvmTypeReference)Xtend2QuickfixProvider.this.typeRefs.createTypeRef(exceptionType, new JvmTypeReference[0]), (EObject)xtendFunction, (IAppendable)appendable);
                        if (xtendFunction.getExpression() != null) {
                            appendable.append(" ");
                        }
                        appendable.commitChanges();
                    }
                }
            });
        }
    }

    @Fix(value="org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception")
    public void surroundWithTryCatch(final Issue issue, IssueResolutionAcceptor acceptor) {
        if (issue.getData() != null && issue.getData().length > 1) {
            acceptor.accept(issue, "Surround with try/catch block", "Surround with try/catch block", "fix_indent.gif", new ISemanticModification(){

                public void apply(EObject element, IModificationContext context) throws Exception {
                    URI exceptionURI = URI.createURI((String)issue.getData()[0]);
                    URI childURI = URI.createURI((String)issue.getData()[1]);
                    XtextResource xtextResource = (XtextResource)element.eResource();
                    EObject exception = xtextResource.getResourceSet().getEObject(exceptionURI, true);
                    if (exception instanceof JvmType) {
                        JvmType exceptionType = (JvmType)exception;
                        EObject childThrowingException = xtextResource.getResourceSet().getEObject(childURI, true);
                        XExpression toBeSurrounded = Xtend2QuickfixProvider.this.findContainerExpressionInBlockExpression(childThrowingException);
                        IXtextDocument xtextDocument = context.getXtextDocument();
                        if (toBeSurrounded != null) {
                            ICompositeNode toBeSurroundedNode = NodeModelUtils.findActualNodeFor((EObject)toBeSurrounded);
                            ReplacingAppendable appendable = Xtend2QuickfixProvider.this.appendableFactory.get(context.getXtextDocument(), childThrowingException, toBeSurroundedNode.getOffset(), toBeSurroundedNode.getLength());
                            appendable.append("try {").increaseIndentation().append("\n").append(xtextDocument.get(toBeSurroundedNode.getOffset(), toBeSurroundedNode.getLength())).decreaseIndentation().append("\n} catch (");
                            Xtend2QuickfixProvider.this.typeRefSerializer.serialize((JvmTypeReference)Xtend2QuickfixProvider.this.typeRefs.createTypeRef(exceptionType, new JvmTypeReference[0]), childThrowingException, (IAppendable)appendable);
                            appendable.append(" ");
                            String exceptionVar = appendable.declareVariable(exceptionType, "exc");
                            appendable.append(exceptionVar).append(") {").increaseIndentation().append("\nthrow new RuntimeException(\"auto-generated try/catch\")").decreaseIndentation().append("\n}").closeScope();
                            appendable.commitChanges();
                        }
                    }
                }
            });
        }
    }

    protected XExpression findContainerExpressionInBlockExpression(EObject expr) {
        if (expr == null) {
            return null;
        }
        EObject container = expr.eContainer();
        if (container instanceof XBlockExpression) {
            return (XExpression)expr;
        }
        return this.findContainerExpressionInBlockExpression(container);
    }

    @Fix(value="org.eclipse.xtext.xtend2.validation.IssueCodes.xtend_lib_not_on_classpath")
    public void putXtendOnClasspath(Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add Xtend libs to classpath", "Add Xtend libs to classpath", "fix_indent.gif", new ISemanticModification(){

            public void apply(EObject element, IModificationContext context) throws Exception {
                ResourceSet resourceSet = element.eResource().getResourceSet();
                IJavaProject javaProject = Xtend2QuickfixProvider.this.projectProvider.getJavaProject(resourceSet);
                Xtend2QuickfixProvider.this.xtendLibAdder.addLibsToClasspath(javaProject, (IProgressMonitor)new NullProgressMonitor());
            }
        });
    }
}

