/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hover.html;

import com.google.inject.Inject;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Display;

public class XtextElementLinks {
    @Inject
    ILabelProvider labelProvider;
    private static final Logger log = Logger.getLogger(XtextElementLinks.class);
    public static final String OPEN_LINK_SCHEME = "eclipse-xtext-open";
    public static final String XTEXTDOC_SCHEME = "eclipse-xtext-doc";
    public static final String XTEXTDOC_VIEW_SCHEME = "eclipse-xtext-doc-view";

    public LocationListener createLocationListener(final ILinkHandler handler) {
        return new LocationAdapter(){

            public void changing(LocationEvent event) {
                URI linkTarget;
                java.net.URI uri;
                String loc = event.location;
                if ("about:blank".equals(loc)) {
                    handler.handleTextSet();
                    return;
                }
                event.doit = false;
                if (loc.startsWith("about:")) {
                    return;
                }
                try {
                    uri = new java.net.URI(loc);
                }
                catch (URISyntaxException e) {
                    File file = new File(loc);
                    if (!file.exists()) {
                        log.warn((Object)("Could not handle location" + loc.toString()), (Throwable)e);
                        return;
                    }
                    uri = file.toURI();
                    loc = uri.toASCIIString();
                }
                String scheme = uri.getScheme();
                if (XtextElementLinks.XTEXTDOC_VIEW_SCHEME.equals(scheme)) {
                    linkTarget = XtextElementLinks.this.parseURI(uri);
                    if (linkTarget == null) {
                        return;
                    }
                    handler.handleXtextdocViewLink(linkTarget);
                } else if (XtextElementLinks.XTEXTDOC_SCHEME.equals(scheme)) {
                    linkTarget = XtextElementLinks.this.parseURI(uri);
                    if (linkTarget == null) {
                        return;
                    }
                    handler.handleInlineXtextdocLink(linkTarget);
                } else if (XtextElementLinks.OPEN_LINK_SCHEME.equals(scheme)) {
                    linkTarget = XtextElementLinks.this.parseURI(uri);
                    if (linkTarget == null) {
                        return;
                    }
                    handler.handleDeclarationLink(linkTarget);
                } else {
                    try {
                        if (handler.handleExternalLink(new URL(loc), event.display)) {
                            return;
                        }
                        event.doit = true;
                    }
                    catch (MalformedURLException e) {
                        log.warn((Object)("Could not handle location" + loc.toString()), (Throwable)e);
                    }
                }
            }
        };
    }

    public String createLink(EObject o) {
        return this.createLink(XTEXTDOC_SCHEME, o);
    }

    public String createLink(String scheme, EObject o) {
        return this.createLink(scheme, o, this.labelProvider.getText((Object)o));
    }

    public String createLink(String scheme, EObject o, String elementName) {
        try {
            return this.createLink(this.createURI(scheme, o), elementName);
        }
        catch (URISyntaxException e) {
            log.warn((Object)("Could not create Link for " + elementName), (Throwable)e);
            return elementName;
        }
    }

    public String createLink(String uri, String elementName) {
        return "<a class='header' href='" + uri + "'>" + elementName + "</a>";
    }

    public String createURI(String scheme, EObject o) throws URISyntaxException {
        return new java.net.URI(scheme, this.createURI(o).toString(), null).toASCIIString();
    }

    public URI parseURI(java.net.URI uri) {
        return URI.createURI((String)uri.getSchemeSpecificPart());
    }

    private URI createURI(EObject o) {
        return o.eResource().getURI().appendFragment(o.eResource().getURIFragment(o));
    }

    public static interface ILinkHandler {
        public void handleInlineXtextdocLink(URI var1);

        public void handleXtextdocViewLink(URI var1);

        public void handleDeclarationLink(URI var1);

        public boolean handleExternalLink(URL var1, Display var2);

        public void handleTextSet();
    }
}

