/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.inject.Inject;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.featurecalls.IdentifiableSimpleNameProvider;
import org.eclipse.xtext.xbase.validation.UIStrings;

public class FeatureCallValidator
extends AbstractDeclarativeValidator {
    @Inject
    protected UIStrings uiStrings;
    @Inject
    private IdentifiableSimpleNameProvider nameProvider;

    @Check
    public void checkInvalidFeatureLinked(XAbstractFeatureCall featureCall) {
        if (!featureCall.isValidFeature()) {
            this.error(featureCall, featureCall.getInvalidFeatureIssueCode());
        }
    }

    @Check
    public void checkInvalidFeatureLinked(XConstructorCall constructorCall) {
        if (!constructorCall.isValidFeature()) {
            this.error(constructorCall, constructorCall.getInvalidFeatureIssueCode());
        }
    }

    protected void error(XAbstractFeatureCall featureCall, String issueCode) {
        String message = null;
        if ("org.eclipse.xtext.xbase.validation.IssueCodes.invisible_feature".equals(issueCode)) {
            message = "Feature " + this.nameProvider.getSimpleName(featureCall.getFeature()) + " is not visible";
        } else if ("org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments".equals(issueCode)) {
            message = "Invalid number of arguments. Expected " + this.uiStrings.parameters(featureCall.getFeature());
        } else if ("org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_type_arguments".equals(issueCode)) {
            message = "Invalid number of type arguments. Expected " + this.uiStrings.typeParameters(featureCall.getFeature()) + " but got " + this.uiStrings.typeArguments(featureCall);
        } else if (!"org.eclipse.xtext.xbase.validation.IssueCodes.invalid_argument_types".equals(issueCode) && !"org.eclipse.xtext.xbase.validation.IssueCodes.invalid_generic_argument_types".equals(issueCode)) {
            message = "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_target_is_not_writeable".equals(issueCode) ? "Feature " + this.nameProvider.getSimpleName(featureCall.getFeature()) + " is not writeable." : ("org.eclipse.xtext.xbase.validation.IssueCodes.instance_access_to_static_member".equals(issueCode) ? "Instance access to static member " + this.nameProvider.getSimpleName(featureCall.getFeature()) : ("org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member".equals(issueCode) ? "Static access to instance member " + this.nameProvider.getSimpleName(featureCall.getFeature()) : ("org.eclipse.xtext.xbase.validation.IssueCodes.field_access_with_parentheses".equals(issueCode) ? "Cannot access field " + this.nameProvider.getSimpleName(featureCall.getFeature()) + " with parentheses" : ("org.eclipse.xtext.xbase.validation.IssueCodes.local_var_access_with_parentheses".equals(issueCode) ? "Cannot access local variable " + this.nameProvider.getSimpleName(featureCall.getFeature()) + " with parentheses" : ("org.eclipse.xtext.xbase.validation.IssueCodes.method_access_without_parentheses".equals(issueCode) ? "Missing parentheses for calling method " + featureCall.getFeature().getIdentifier() : ("org.eclipse.xtext.xbase.validation.IssueCodes.invalid_mutable_variable_access".equals(issueCode) ? "Cannot refer to a non-final variable " + featureCall.getFeature().getIdentifier() + " from within a closure" : "Missing error message for " + issueCode))))));
        }
        if (message != null) {
            this.error(message, null, -1, issueCode, new String[0]);
        }
    }

    protected void error(XConstructorCall constructorCall, String issueCode) {
        String message = null;
        if ("org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_arguments".equals(issueCode)) {
            message = "Invalid number of arguments. Expected " + this.uiStrings.parameters((JvmIdentifiableElement)constructorCall.getConstructor());
        } else if ("org.eclipse.xtext.xbase.validation.IssueCodes.invalid_number_of_type_arguments".equals(issueCode)) {
            message = "Invalid number of type arguments. Expected " + this.uiStrings.typeParameters((JvmIdentifiableElement)constructorCall.getConstructor()) + " but got " + this.uiStrings.typeArguments(constructorCall);
        } else if (!"org.eclipse.xtext.xbase.validation.IssueCodes.invalid_argument_types".equals(issueCode)) {
            message = "Missig error message for " + issueCode;
        }
        if (message != null) {
            this.error(message, null, -1, issueCode, new String[0]);
        }
    }

    public void register(EValidatorRegistrar registrar) {
    }
}

