/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.xtext.ui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.search.matching.ConstructorDeclarationPattern;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.jdt.IJdtTypeProvider;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.common.types.xtext.AbstractConstructorScope;
import org.eclipse.xtext.common.types.xtext.AbstractTypeScope;
import org.eclipse.xtext.common.types.xtext.ui.JdtBasedSimpleTypeScope;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.AbstractEObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtBasedConstructorScope
extends AbstractConstructorScope {
    private static final Logger logger = Logger.getLogger(JdtBasedConstructorScope.class);

    public JdtBasedConstructorScope(JdtBasedSimpleTypeScope typeScope) {
        super((AbstractTypeScope)typeScope);
    }

    protected Iterable<IEObjectDescription> internalGetAllElements() {
        IJavaProject javaProject = this.getTypeProvider().getJavaProject();
        if (javaProject == null) {
            return Collections.emptyList();
        }
        final ArrayList allScopedElements = Lists.newArrayListWithExpectedSize((int)25000);
        try {
            IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
            SearchRequestor searchRequestor = new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    Object element = match.getElement();
                    if (element instanceof IMethod) {
                        IMethod constructor = (IMethod)element;
                        allScopedElements.add(JdtBasedConstructorScope.this.createScopedElement(constructor));
                    }
                }
            };
            this.collectContents(searchScope, searchRequestor);
        }
        catch (CoreException e) {
            logger.error((Object)"CoreException when searching for constructors.", (Throwable)e);
        }
        return allScopedElements;
    }

    protected IJdtTypeProvider getTypeProvider() {
        return this.getTypeScope().getTypeProvider();
    }

    public IEObjectDescription createScopedElement(IMethod constructor) {
        return new LazyConstructorDescription(constructor, this.getTypeProvider().getTypeUriHelper(), this.getQualifiedNameConverter());
    }

    public void collectContents(IJavaSearchScope searchScope, SearchRequestor searchRequestor) throws CoreException {
        ConstructorDeclarationPattern pattern = new ConstructorDeclarationPattern(null, null, 1);
        new SearchEngine().search((SearchPattern)pattern, SearchUtils.getDefaultSearchParticipants(), searchScope, searchRequestor, (IProgressMonitor)new NullProgressMonitor());
    }

    public JdtBasedSimpleTypeScope getTypeScope() {
        return (JdtBasedSimpleTypeScope)super.getTypeScope();
    }

    public static class LazyConstructorDescription
    extends AbstractEObjectDescription {
        private final IMethod constructor;
        private final TypeURIHelper uriHelper;
        private final IQualifiedNameConverter converter;
        private QualifiedName qualifiedName = null;
        private JvmConstructor proxy = null;
        private URI uri = null;

        protected LazyConstructorDescription(IMethod constructor, TypeURIHelper uriHelper, IQualifiedNameConverter converter) {
            this.constructor = constructor;
            this.uriHelper = uriHelper;
            this.converter = converter;
        }

        public QualifiedName getName() {
            return this.getQualifiedName();
        }

        public QualifiedName getQualifiedName() {
            if (this.qualifiedName == null) {
                this.qualifiedName = this.converter.toQualifiedName(this.constructor.getDeclaringType().getFullyQualifiedName());
            }
            return this.qualifiedName;
        }

        public JvmConstructor getEObjectOrProxy() {
            if (this.proxy == null) {
                this.proxy = this.createProxy();
            }
            return this.proxy;
        }

        public URI getEObjectURI() {
            if (this.uri == null) {
                this.uri = this.computeURI();
            }
            return this.uri;
        }

        public EClass getEClass() {
            return TypesPackage.Literals.JVM_CONSTRUCTOR;
        }

        protected JvmConstructor createProxy() {
            InternalEObject proxy = (InternalEObject)TypesFactory.eINSTANCE.createJvmConstructor();
            proxy.eSetProxyURI(this.getEObjectURI());
            return (JvmConstructor)proxy;
        }

        protected URI computeURI() {
            return this.uriHelper.getFullURI((IJavaElement)this.constructor);
        }
    }
}

