/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ComposedChecks;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XIntLiteral;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.controlflow.IEarlyExitComputer;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.scoping.XbaseScopeProvider;
import org.eclipse.xtext.xbase.typing.Closures;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.typing.JvmExceptions;
import org.eclipse.xtext.xbase.typing.SynonymTypesProvider;
import org.eclipse.xtext.xbase.util.XExpressionHelper;
import org.eclipse.xtext.xbase.util.XbaseUsageCrossReferencer;
import org.eclipse.xtext.xbase.validation.AbstractXbaseJavaValidator;
import org.eclipse.xtext.xbase.validation.EarlyExitValidator;
import org.eclipse.xtext.xbase.validation.ExceptionInExpressionFinder;
import org.eclipse.xtext.xbase.validation.FeatureCallValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComposedChecks(validators={FeatureCallValidator.class, EarlyExitValidator.class})
public class XbaseJavaValidator
extends AbstractXbaseJavaValidator {
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private TypeConformanceComputer conformanceComputer;
    @Inject
    private XExpressionHelper expressionHelper;
    @Inject
    private TypeReferences typeRefs;
    @Inject
    private TypesFactory factory;
    @Inject
    private SynonymTypesProvider synonymTypeProvider;
    @Inject
    private IEarlyExitComputer earlyExitComputer;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private Primitives primitives;
    @Inject
    private ILogicalContainerProvider logicalContainerProvider;
    @Inject
    private JvmExceptions jvmExceptions;
    @Inject
    private Closures closures;
    private final Set<EReference> typeConformanceCheckedReferences = ImmutableSet.of((Object)XbasePackage.Literals.XVARIABLE_DECLARATION__RIGHT, (Object)XbasePackage.Literals.XIF_EXPRESSION__IF, (Object)XbasePackage.Literals.XTHROW_EXPRESSION__EXPRESSION, (Object)XbasePackage.Literals.XRETURN_EXPRESSION__EXPRESSION, (Object)XbasePackage.Literals.XSWITCH_EXPRESSION__SWITCH, (Object)XbasePackage.Literals.XCASE_PART__CASE, (Object[])new EReference[]{XbasePackage.Literals.XASSIGNMENT__ASSIGNABLE, XbasePackage.Literals.XABSTRACT_WHILE_EXPRESSION__PREDICATE, XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_ARGUMENTS, XbasePackage.Literals.XCONSTRUCTOR_CALL__ARGUMENTS, XbasePackage.Literals.XFEATURE_CALL__FEATURE_CALL_ARGUMENTS, XbasePackage.Literals.XASSIGNMENT__VALUE, XbasePackage.Literals.XBINARY_OPERATION__RIGHT_OPERAND});
    private Set<String> disallowedNames = Sets.newHashSet((Object[])new String[]{XbaseScopeProvider.THIS.toString(), XbaseScopeProvider.SUPER.toString()});
    @Inject
    private ExceptionInExpressionFinder exceptionInExpressionFinder;

    protected Set<EReference> getTypeConformanceCheckedReferences() {
        return this.typeConformanceCheckedReferences;
    }

    @Check
    public void checkNoSideffectFreeExpressionsInBlockExpression(XBlockExpression blockExpression) {
        int i = 0;
        while (i < blockExpression.getExpressions().size() - 1) {
            XExpression expr = (XExpression)blockExpression.getExpressions().get(i);
            if (this.isSideEffectFree(expr)) {
                this.error("The expression does not cause any side effects and therefore doesn't do anything in this context.", expr, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.side_effect_free_expression_in_block", new String[0]);
            }
            ++i;
        }
    }

    protected boolean isSideEffectFree(XExpression expr) {
        if (expr instanceof XMemberFeatureCall) {
            return ((XMemberFeatureCall)expr).getFeature() instanceof JvmField;
        }
        if (expr instanceof XFeatureCall) {
            return !(((XFeatureCall)expr).getFeature() instanceof JvmExecutable);
        }
        if (expr instanceof XCastedExpression) {
            return this.isSideEffectFree(((XCastedExpression)expr).getTarget());
        }
        return expr instanceof XStringLiteral || expr instanceof XTypeLiteral || expr instanceof XIntLiteral || expr instanceof XNullLiteral || expr instanceof XBooleanLiteral || expr instanceof XClosure;
    }

    @Check
    public void checkTypeReferenceIsNotVoid(XExpression expression) {
        EList list = expression.eContents();
        for (EObject eObject : list) {
            JvmTypeReference typeRef;
            if (!(eObject instanceof JvmTypeReference) || !this.typeRefs.is(typeRef = (JvmTypeReference)eObject, Void.TYPE)) continue;
            this.error("Primitive void cannot be used here.", (EObject)typeRef, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }

    @Check
    public void checkVariableIsNotInferredAsVoid(XVariableDeclaration declaration) {
        if (declaration.getType() != null) {
            return;
        }
        JvmTypeReference inferredType = this.getTypeProvider().getTypeForIdentifiable(declaration);
        if (this.typeRefs.is(inferredType, Void.TYPE)) {
            this.error("void is an invalid type for the variable " + declaration.getName(), declaration, (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }

    @Check
    public void checkClosureParameterTypes(XClosure closure) {
        if (closure.getFormalParameters().isEmpty()) {
            return;
        }
        boolean checkedClosure = false;
        for (JvmFormalParameter p : closure.getFormalParameters()) {
            if (p.getParameterType() != null) continue;
            if (!checkedClosure) {
                JvmTypeReference type = this.getTypeProvider().getExpectedType(closure);
                if (type == null) {
                    this.error("There is no context to infer the closure's argument types from. Consider typing the arguments or put the closures into a typed context.", closure, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information", new String[0]);
                    return;
                }
                JvmOperation operation = this.closures.findImplementingOperation(type, closure.eResource());
                if (operation == null) {
                    this.error("There is no context to infer the closure's argument types from. Consider typing the arguments or use the closures in a more specific context.", closure, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information", new String[0]);
                    return;
                }
                checkedClosure = true;
            }
            if (this.getTypeProvider().getTypeForIdentifiable((JvmIdentifiableElement)p, true) != null) continue;
            this.error("There is no context to infer the closure's argument types from. Consider typing the arguments or use the closures in a more specific context.", closure, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information", new String[0]);
            return;
        }
    }

    @Check
    public void checkTypeArguments(XAbstractFeatureCall expression) {
        for (JvmTypeReference typeRef : expression.getTypeArguments()) {
            this.ensureNotPrimitiveNorWildcard(typeRef);
        }
    }

    @Check
    public void checkTypeArguments(XConstructorCall expression) {
        for (JvmTypeReference typeRef : expression.getTypeArguments()) {
            this.ensureNotPrimitiveNorWildcard(typeRef);
        }
    }

    protected void ensureNotPrimitiveNorWildcard(JvmTypeReference typeRef) {
        if (this.primitives.isPrimitive(typeRef)) {
            this.error("Primitives cannot be used as type arguments.", (EObject)typeRef, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
        if (typeRef instanceof JvmWildcardTypeReference) {
            this.error("Wildcard types are not allowed in this context", (EObject)typeRef, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_wild_card", new String[0]);
        }
    }

    @Check
    public void checkTypeReferenceIsNotVoid(XCasePart expression) {
        if (expression.getTypeGuard() != null && this.typeRefs.is(expression.getTypeGuard(), Void.TYPE)) {
            this.error("Primitive void cannot be used here.", (EObject)expression.getTypeGuard(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }

    @Check
    public void checkUniqueVariableName(XVariableDeclaration decl) {
        this.checkDeclaredVariableName(decl, XbasePackage.Literals.XVARIABLE_DECLARATION__NAME);
    }

    @Check
    public void checkUniqueVariableName(XSwitchExpression decl) {
        this.checkDeclaredVariableName(decl, XbasePackage.Literals.XSWITCH_EXPRESSION__LOCAL_VAR_NAME);
    }

    @Check
    public void checkUniqueVariableName(XForLoopExpression forLoop) {
        this.checkDeclaredVariableName(forLoop, (EObject)forLoop.getDeclaredParam(), TypesPackage.Literals.JVM_FORMAL_PARAMETER__NAME);
    }

    @Check
    public void checkUniqueVariableName(XClosure closure) {
        for (JvmFormalParameter param : closure.getFormalParameters()) {
            this.checkDeclaredVariableName(closure, (EObject)param, TypesPackage.Literals.JVM_FORMAL_PARAMETER__NAME);
        }
    }

    @Check
    public void checkUniqueVariableName(XTryCatchFinallyExpression tryCatch) {
        for (XCatchClause param : tryCatch.getCatchClauses()) {
            this.checkDeclaredVariableName(tryCatch, (EObject)param.getDeclaredParam(), TypesPackage.Literals.JVM_FORMAL_PARAMETER__NAME);
        }
    }

    protected void checkDeclaredVariableName(EObject nameAndAttributeDeclarator, EAttribute attr) {
        this.checkDeclaredVariableName(nameAndAttributeDeclarator, nameAndAttributeDeclarator, attr);
    }

    protected void checkDeclaredVariableName(EObject nameDeclarator, EObject attributeHolder, EAttribute attr) {
        if (nameDeclarator.eContainer() == null) {
            return;
        }
        if (attr.getEContainingClass().isInstance((Object)attributeHolder)) {
            String name = (String)attributeHolder.eGet((EStructuralFeature)attr);
            if (name == null || Strings.equal((String)name, (String)XbaseScopeProvider.IT.toString())) {
                return;
            }
            if (this.getDisallowedVariableNames().contains(name)) {
                this.error("'" + name + "' is not a valid name.", attributeHolder, (EStructuralFeature)attr, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_shadowing", new String[0]);
                return;
            }
            int idx = 0;
            if (nameDeclarator.eContainer() instanceof XBlockExpression) {
                idx = ((XBlockExpression)nameDeclarator.eContainer()).getExpressions().indexOf((Object)nameDeclarator);
            }
            IScope scope = this.getScopeProvider().createSimpleFeatureCallScope(nameDeclarator.eContainer(), XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, nameDeclarator.eResource(), true, idx);
            Iterable elements = scope.getElements(QualifiedName.create((String[])new String[]{name}));
            for (IEObjectDescription desc : elements) {
                if (desc.getEObjectOrProxy() == nameDeclarator || desc.getEObjectOrProxy() instanceof JvmFeature) continue;
                this.error("Duplicate variable name '" + name + "'", attributeHolder, (EStructuralFeature)attr, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_shadowing", new String[0]);
            }
        }
    }

    protected Set<String> getDisallowedVariableNames() {
        return this.disallowedNames;
    }

    protected XbaseScopeProvider getScopeProvider() {
        return (XbaseScopeProvider)this.scopeProvider;
    }

    @Check
    public void checkTypes(final XExpression obj) {
        XExpression firstArgument;
        if (obj instanceof XAbstractFeatureCall && (firstArgument = ((XAbstractFeatureCall)obj).getImplicitFirstArgument()) != null) {
            this.validateType(firstArgument, new Procedures.Procedure2<JvmTypeReference, JvmTypeReference>(){

                public void apply(JvmTypeReference expectedType, JvmTypeReference actualType) {
                    XbaseJavaValidator.this.error("Incompatible implicit first argument. Expected " + XbaseJavaValidator.this.getNameOfTypes(expectedType) + " but was " + XbaseJavaValidator.this.canonicalName(actualType), obj, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", new String[0]);
                }
            });
        }
        if (!this.getTypeConformanceCheckedReferences().contains(obj.eContainingFeature())) {
            return;
        }
        try {
            this.validateType(obj, new Procedures.Procedure2<JvmTypeReference, JvmTypeReference>(){

                public void apply(JvmTypeReference expectedType, JvmTypeReference actualType) {
                    XbaseJavaValidator.this.error("Incompatible types. Expected " + XbaseJavaValidator.this.getNameOfTypes(expectedType) + " but was " + XbaseJavaValidator.this.canonicalName(actualType), obj, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", new String[0]);
                }
            });
        }
        catch (WrappedException e) {
            throw new WrappedException("XbaseJavaValidator#checkTypes for " + obj + " caused: " + e.getCause().getMessage(), (Exception)((Object)e));
        }
    }

    protected void validateType(XExpression expression, Procedures.Procedure2<JvmTypeReference, JvmTypeReference> messageProducer) {
        JvmTypeReference expectedType = this.typeProvider.getExpectedType(expression);
        if (expectedType == null || expectedType.getType() == null) {
            return;
        }
        JvmTypeReference actualType = this.typeProvider.getType(expression);
        if (actualType == null || actualType.getType() == null) {
            return;
        }
        boolean valid = this.conformanceComputer.isConformant(expectedType, actualType);
        if (!valid) {
            messageProducer.apply((Object)expectedType, (Object)actualType);
        }
    }

    @Check
    public void checkReceiverOfStaticFeature(XMemberFeatureCall featureCall) {
        this.doCheckReceiverOfStaticFeature(featureCall, featureCall.getMemberCallTarget());
    }

    @Check
    public void checkReceiverOfStaticFeature(XFeatureCall featureCall) {
        this.doCheckReceiverOfStaticFeature(featureCall, featureCall.getImplicitReceiver());
    }

    protected void doCheckReceiverOfStaticFeature(final XAbstractFeatureCall featureCall, XExpression receiver) {
        JvmOperation operation;
        if (receiver != null && featureCall.getFeature() instanceof JvmOperation && (operation = (JvmOperation)featureCall.getFeature()).isStatic()) {
            try {
                this.validateType(receiver, new Procedures.Procedure2<JvmTypeReference, JvmTypeReference>(){

                    public void apply(JvmTypeReference expectedType, JvmTypeReference actualType) {
                        XbaseJavaValidator.this.error("Incompatible receiver type. Expected " + XbaseJavaValidator.this.getNameOfTypes(expectedType) + " but was " + XbaseJavaValidator.this.canonicalName(actualType), featureCall, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", new String[0]);
                    }
                });
            }
            catch (WrappedException e) {
                throw new WrappedException("XbaseJavaValidator#checkTypes for " + receiver + " caused: " + e.getCause().getMessage(), (Exception)((Object)e));
            }
        }
    }

    @Check
    public void checkImplicitReturn(XExpression expr) {
        if (!this.isImplicitReturn(expr)) {
            return;
        }
        JvmTypeReference expectedType = this.typeProvider.getExpectedType(expr);
        if (expectedType == null || this.typeRefs.is(expectedType, Void.TYPE)) {
            return;
        }
        JvmTypeReference type = this.typeProvider.getType(expr);
        if (this.typeRefs.is(expectedType, Void.class) && EcoreUtil2.getContainerOfType((EObject)expr, XClosure.class) != null && this.typeRefs.is(type, Void.TYPE)) {
            return;
        }
        if (!this.conformanceComputer.isConformant(expectedType, type)) {
            this.error("Incompatible implicit return type. Expected " + this.getNameOfTypes(expectedType) + " but was " + this.canonicalName(type), expr, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incomptible_return_type", new String[0]);
        }
    }

    @Check
    public void checkReturn(XReturnExpression expr) {
        JvmTypeReference returnType = this.typeProvider.getExpectedReturnType(expr, true);
        if (returnType == null) {
            JvmTypeReference expressionType;
            if (expr.getExpression() != null && this.typeRefs.is(expressionType = this.typeProvider.getType(expr.getExpression()), Void.TYPE)) {
                this.error("Incompatible types. Expected java.lang.Object but was " + this.canonicalName(expressionType), expr.getExpression(), null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", new String[0]);
            }
            return;
        }
        if (this.typeRefs.is(returnType, Void.TYPE)) {
            if (expr.getExpression() != null) {
                this.error("Void functions cannot return a value.", expr, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_return", new String[0]);
            }
        } else if (expr.getExpression() == null) {
            this.error("The function must return a result of type " + returnType.getSimpleName() + ".", expr, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_return", new String[0]);
        } else {
            JvmTypeReference expressionType = this.typeProvider.getType(expr.getExpression());
            if (this.typeRefs.is(expressionType, Void.TYPE)) {
                this.error("Incompatible types. Expected " + this.getNameOfTypes(returnType) + " but was " + this.canonicalName(expressionType), expr.getExpression(), null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", new String[0]);
            }
        }
    }

    protected boolean isImplicitReturn(XExpression expr) {
        JvmIdentifiableElement logicalContainer = this.logicalContainerProvider.getLogicalContainer(expr);
        return (logicalContainer instanceof JvmExecutable || logicalContainer instanceof JvmField || expr.eContainer() instanceof XClosure) && !this.earlyExitComputer.isEarlyExit(expr);
    }

    protected String getNameOfTypes(JvmTypeReference expectedType) {
        StringBuilder result = new StringBuilder(this.canonicalName(expectedType));
        Set<JvmTypeReference> types = this.synonymTypeProvider.getSynonymTypes(expectedType, false);
        for (JvmTypeReference jvmTypeReference : types) {
            result.append(" or ").append(this.canonicalName(jvmTypeReference));
        }
        return result.toString();
    }

    @Check
    public void checkTypes(XForLoopExpression obj) {
        try {
            JvmParameterizedTypeReference expectedType;
            JvmTypeReference actualType = this.typeProvider.getType(obj.getForExpression());
            if (actualType == null || actualType.getType() == null) {
                return;
            }
            JvmType iterable = this.typeRefs.findDeclaredType(Iterable.class, (EObject)obj);
            JvmWildcardTypeReference argument = this.typeRefs.wildCard();
            JvmTypeReference expected = obj.getDeclaredParam().getParameterType();
            if (expected != null) {
                argument = this.typeRefs.wildCardExtends((JvmTypeReference)EcoreUtil2.cloneIfContained((EObject)expected));
            }
            if (!this.conformanceComputer.isConformant((JvmTypeReference)(expectedType = this.typeRefs.createTypeRef(iterable, new JvmTypeReference[]{argument})), actualType)) {
                this.error("Incompatible types. Expected " + this.getNameOfTypes((JvmTypeReference)expectedType) + " but was " + this.canonicalName(actualType), obj.getForExpression(), null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", new String[0]);
            } else if (actualType instanceof JvmParameterizedTypeReference && ((JvmParameterizedTypeReference)actualType).getArguments().isEmpty() && obj.getDeclaredParam().getParameterType() != null && !this.typeRefs.is(obj.getDeclaredParam().getParameterType(), Object.class)) {
                this.error("Incompatible types. Expected " + this.getNameOfTypes((JvmTypeReference)expectedType) + " but was " + this.canonicalName(actualType), obj.getForExpression(), null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", new String[0]);
            }
        }
        catch (WrappedException e) {
            throw new WrappedException("XbaseJavaValidator#checkTypes for " + obj + " caused: " + e.getCause().getMessage(), (Exception)((Object)e));
        }
    }

    @Check
    public void checkTypes(XCatchClause catchClause) {
        JvmTypeReference parameterType = catchClause.getDeclaredParam().getParameterType();
        JvmTypeReference throwable = this.typeRefs.getTypeForName(Throwable.class, (EObject)catchClause, new JvmTypeReference[0]);
        if (!this.conformanceComputer.isConformant(throwable, parameterType)) {
            this.error("No exception of type " + parameterType.getQualifiedName('.') + " can be thrown; an exception type must be a subclass of Throwable", (EObject)catchClause.getDeclaredParam(), (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__PARAMETER_TYPE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", new String[0]);
        }
    }

    @Check
    public void checkAssignment(XAssignment assignment) {
        JvmIdentifiableElement assignmentFeature = assignment.getFeature();
        if (assignmentFeature instanceof XVariableDeclaration && !((XVariableDeclaration)assignmentFeature).isWriteable()) {
            this.error("Assignment to final variable", (EStructuralFeature)XbasePackage.Literals.XASSIGNMENT__ASSIGNABLE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_to_final", new String[0]);
        } else if (assignmentFeature instanceof JvmFormalParameter) {
            this.error("Assignment to final parameter", (EStructuralFeature)XbasePackage.Literals.XASSIGNMENT__ASSIGNABLE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_to_final", new String[0]);
        } else if (assignmentFeature instanceof JvmField && ((JvmField)assignmentFeature).isFinal()) {
            this.error("Assignment to final feature", (EStructuralFeature)XbasePackage.Literals.XASSIGNMENT__ASSIGNABLE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_to_final", new String[0]);
        }
    }

    @Check
    public void checkVariableDeclaration(XVariableDeclaration declaration) {
        if (declaration.getRight() == null) {
            if (!declaration.isWriteable()) {
                this.error("Value must be initialized", (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__WRITEABLE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.missing_initialization", new String[0]);
            }
            if (declaration.getType() == null) {
                this.error("Type cannot be derived", (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__NAME, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.missing_type", new String[0]);
            }
        }
    }

    @Check
    public void checkInnerExpressions(XBlockExpression block) {
        int i = 0;
        while (i < block.getExpressions().size() - 1) {
            XExpression expr = (XExpression)block.getExpressions().get(i);
            if (this.expressionHelper.isLiteral(expr)) {
                this.error("Literals can only appear as the last element of a block expression", expr, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_inner_expression", new String[0]);
            }
            ++i;
        }
    }

    @Check
    public void checkCasts(XCastedExpression cast) {
        JvmTypeReference toType = cast.getType();
        JvmTypeReference fromType = this.typeProvider.getType(cast.getTarget());
        this.checkCast(toType, fromType);
    }

    protected void checkCast(JvmTypeReference toType, JvmTypeReference fromType) {
        if (fromType != null && fromType.getType() instanceof JvmDeclaredType) {
            JvmType type;
            JvmDeclaredType targetType = (JvmDeclaredType)fromType.getType();
            if (targetType.isFinal()) {
                if (!this.conformanceComputer.isConformant(toType, fromType)) {
                    this.error("Cannot cast element of sealed type " + this.getNameOfTypes(fromType) + " to " + this.canonicalName(toType), (EObject)toType, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_cast", new String[0]);
                } else {
                    this.conformanceComputer.isConformant(toType, fromType);
                }
            } else if (!this.conformanceComputer.isConformant(toType, fromType) && (type = toType.getType()) instanceof JvmGenericType && !((JvmGenericType)type).isInterface() && !this.conformanceComputer.isConformant(fromType, toType)) {
                this.error("type mismatch: cannot convert from " + this.getNameOfTypes(fromType) + " to " + this.canonicalName(toType), (EObject)toType, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_cast", new String[0]);
            }
        }
    }

    @Check
    public void checkTypeGuards(XCasePart casePart) {
        if (casePart.getTypeGuard() == null) {
            return;
        }
        JvmTypeReference typeGuard = casePart.getTypeGuard();
        if (this.primitives.isPrimitive(typeGuard)) {
            this.error("Primitives are not allowed as type guards", (EStructuralFeature)XbasePackage.Literals.XCASE_PART__TYPE_GUARD, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
        JvmTypeReference targetTypeRef = this.typeProvider.getType(((XSwitchExpression)casePart.eContainer()).getSwitch());
        this.checkCast(typeGuard, targetTypeRef);
    }

    @Check
    public void checkInstanceOf(XInstanceOfExpression instanceOfExpression) {
        JvmTypeReference expressionTypeRef = this.typeProvider.getType(instanceOfExpression.getExpression());
        if (expressionTypeRef != null && expressionTypeRef.getType() instanceof JvmDeclaredType) {
            boolean isConformant = this.isConformant(instanceOfExpression.getType(), expressionTypeRef);
            if (isConformant) {
                this.warning("The expression of type " + this.getNameOfTypes(expressionTypeRef) + " is already of type " + this.canonicalName(instanceOfExpression.getType()), null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_instanceof", new String[0]);
            } else if (this.isFinal(expressionTypeRef)) {
                this.error("Incompatible conditional operand types " + this.getNameOfTypes(expressionTypeRef) + " and " + this.canonicalName(instanceOfExpression.getType()), null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_instanceof", new String[0]);
            }
        }
    }

    protected boolean isFinal(JvmTypeReference expressionTypeRef) {
        return expressionTypeRef.getType() instanceof JvmDeclaredType && ((JvmDeclaredType)expressionTypeRef.getType()).isFinal();
    }

    @Check
    public void checkInstantiationOfAbstractClass(XConstructorCall constructorCall) {
        if (constructorCall.getConstructor().getDeclaringType().isAbstract()) {
            this.error("Cannot instantiate abstract class", null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.abstract_class_instantiation", new String[0]);
        }
    }

    @Check
    public void checkDelegateConstructorIsFirst(XFeatureCall featureCall) {
        JvmIdentifiableElement container;
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature != null && !feature.eIsProxy() && feature instanceof JvmConstructor && (container = this.logicalContainerProvider.getNearestLogicalContainer(featureCall)) != null) {
            if (container instanceof JvmConstructor) {
                EList<XExpression> expressions;
                XExpression body = this.logicalContainerProvider.getAssociatedExpression(container);
                if (body == featureCall) {
                    return;
                }
                if (body instanceof XBlockExpression && ((expressions = ((XBlockExpression)body).getExpressions()).isEmpty() || expressions.get(0) != featureCall)) {
                    this.error("Constructor call must be the first expression in a constructor", null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_constructor_invocation", new String[0]);
                }
            } else {
                this.error("Constructor call must be the first expression in a constructor", null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_constructor_invocation", new String[0]);
            }
        }
    }

    @Check
    public void checkConstructorArgumentsAreValid(XFeatureCall featureCall) {
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature != null && !feature.eIsProxy() && feature instanceof JvmConstructor) {
            for (XExpression argument : featureCall.getFeatureCallArguments()) {
                this.checkIsValidConstructorArgument(argument);
            }
        }
    }

    protected void checkIsValidConstructorArgument(XExpression argument) {
        TreeIterator iterator = EcoreUtil2.eAll((EObject)argument);
        while (iterator.hasNext()) {
            JvmIdentifiableElement feature;
            EObject partOfArgumentExpression = (EObject)iterator.next();
            if (!(partOfArgumentExpression instanceof XFeatureCall) || (feature = ((XFeatureCall)partOfArgumentExpression).getFeature()) == null || feature.eIsProxy()) continue;
            if (feature instanceof JvmField) {
                if (((JvmField)feature).isStatic()) continue;
                this.error("Cannot refer to an instance field " + feature.getSimpleName() + " while explicitly invoking a constructor", partOfArgumentExpression, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_constructor_argument", new String[0]);
                continue;
            }
            if (!(feature instanceof JvmOperation) || ((JvmOperation)feature).isStatic()) continue;
            this.error("Cannot refer to an instance method while explicitly invoking a constructor", partOfArgumentExpression, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_constructor_argument", new String[0]);
        }
    }

    @Check
    public void checkNoCircularConstructorCall(XFeatureCall featureCall) {
        JvmIdentifiableElement logicalContainer;
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature != null && !feature.eIsProxy() && feature instanceof JvmConstructor && (logicalContainer = this.logicalContainerProvider.getNearestLogicalContainer(featureCall)) instanceof JvmConstructor) {
            JvmConstructor currentConstructor = (JvmConstructor)logicalContainer;
            JvmConstructor calledConstructor = (JvmConstructor)feature;
            HashSet visited = Sets.newHashSet((Object[])new JvmConstructor[]{currentConstructor});
            while (calledConstructor.getDeclaringType() == currentConstructor.getDeclaringType()) {
                if (!visited.add(calledConstructor)) {
                    this.error("Recursive constructor invocation", null, "org.eclipse.xtext.xbase.validation.IssueCodes.circular_constructor_invocation", new String[0]);
                    return;
                }
                XExpression constructorBody = this.logicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)calledConstructor);
                if (constructorBody instanceof XBlockExpression) {
                    JvmIdentifiableElement calledFeature;
                    EList<XExpression> expressions = ((XBlockExpression)constructorBody).getExpressions();
                    if (expressions.isEmpty()) {
                        return;
                    }
                    XExpression firstInBody = (XExpression)((XBlockExpression)constructorBody).getExpressions().get(0);
                    if (firstInBody instanceof XFeatureCall && (calledFeature = ((XFeatureCall)firstInBody).getFeature()) != null && !feature.eIsProxy() && feature instanceof JvmConstructor) {
                        calledConstructor = (JvmConstructor)calledFeature;
                        continue;
                    }
                }
                return;
            }
        }
    }

    @Check
    public void checkNoForwardReferences(XExpression fieldInitializer) {
        JvmIdentifiableElement container = this.logicalContainerProvider.getLogicalContainer(fieldInitializer);
        if (container instanceof JvmField) {
            JvmField field = (JvmField)container;
            boolean staticField = field.isStatic();
            JvmDeclaredType declaredType = field.getDeclaringType();
            HashSet illegalFields = Sets.newHashSet();
            int i = declaredType.getMembers().size() - 1;
            while (i >= 0) {
                JvmMember member = (JvmMember)declaredType.getMembers().get(i);
                if (member instanceof JvmField && ((JvmField)member).isStatic() == staticField) {
                    illegalFields.add((JvmField)member);
                }
                if (member == field) break;
                --i;
            }
            TreeIterator iterator = EcoreUtil2.eAll((EObject)fieldInitializer);
            while (iterator.hasNext()) {
                EObject object = (EObject)iterator.next();
                if (!(object instanceof XFeatureCall)) continue;
                JvmIdentifiableElement feature = ((XFeatureCall)object).getFeature();
                if (!illegalFields.contains(((XFeatureCall)object).getFeature())) continue;
                this.error("Cannot reference the field '" + feature.getSimpleName() + "' before it is defined", object, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.illegal_forward_reference", new String[0]);
            }
        }
    }

    @Check
    public void checkClosureParams(XClosure closure) {
        if (closure.getFormalParameters().size() > 6) {
            this.error("The maximum number of parameters for a closure is six.", closure, (EStructuralFeature)XbasePackage.Literals.XCLOSURE__DECLARED_FORMAL_PARAMETERS, 6, "org.eclipse.xtext.xbase.validation.IssueCodes.too_many_params_in_closure", new String[0]);
        }
    }

    @Check
    public void checkExceptionsInClosure(XClosure closure) {
        if (this.supportsCheckedExceptions()) {
            this.doCheckUnhandledException(closure.getExpression(), Collections.<JvmTypeReference>emptyList());
        }
    }

    @Check
    public void checkUnhandledException(XExpression expression) {
        JvmIdentifiableElement logicalContainer;
        if (this.supportsCheckedExceptions() && (logicalContainer = this.logicalContainerProvider.getLogicalContainer(expression)) instanceof JvmExecutable) {
            JvmExecutable executable = (JvmExecutable)logicalContainer;
            this.doCheckUnhandledException(expression, (List<JvmTypeReference>)executable.getExceptions());
        }
    }

    protected boolean supportsCheckedExceptions() {
        return true;
    }

    protected void doCheckUnhandledException(XExpression expression, List<JvmTypeReference> declaredExceptions) {
        for (JvmTypeReference unhandledException : this.findUnhandledExceptions(expression, this.typeProvider.getThrownExceptionTypes(expression), declaredExceptions)) {
            this.reportUnhandledException(expression, unhandledException);
        }
    }

    protected Iterable<JvmTypeReference> findUnhandledExceptions(EObject context, Iterable<JvmTypeReference> thrownExceptions, List<JvmTypeReference> declaredExceptions) {
        return this.jvmExceptions.findUnhandledExceptions(context, thrownExceptions, declaredExceptions);
    }

    protected void reportUnhandledException(XExpression element, JvmTypeReference thrownException) {
        for (EObject childThrowingException : this.exceptionInExpressionFinder.findChildrenThrowingException(element, thrownException)) {
            String expressionTypeURI = EcoreUtil.getURI((EObject)thrownException.getType()).toString();
            String childURI = EcoreUtil.getURI((EObject)childThrowingException).toString();
            this.error("Unhandled exception type " + thrownException.getIdentifier(), childThrowingException, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.unhandled_exception", new String[]{expressionTypeURI, childURI});
        }
    }

    @Check
    public void checkSpreadOperatorNotUsed(XMemberFeatureCall featureCall) {
        if (featureCall.isSpreading()) {
            this.error("The spreading operator is not yet supported.", featureCall, (EStructuralFeature)XbasePackage.Literals.XMEMBER_FEATURE_CALL__SPREADING, "unssupported_spread_operator", new String[0]);
        }
    }

    @Check
    void checkNullSafeFeatureCallWithPrimitives(XMemberFeatureCall featureCall) {
        if (featureCall.isNullSafe() && this.primitives.isPrimitive(this.typeProvider.getType(featureCall.getMemberCallTarget()))) {
            this.error("Cannot use null safe feature call on primitive receiver", featureCall, (EStructuralFeature)XbasePackage.Literals.XMEMBER_FEATURE_CALL__NULL_SAFE, "org.eclipse.xtext.xbase.validation.IssueCodes.null_safe_feature_call_on_primitive", new String[0]);
        }
    }

    @Check
    public void checkLocalUsageOfDeclared(XVariableDeclaration variableDeclaration) {
        if (!this.isLocallyUsed(variableDeclaration, variableDeclaration.eContainer())) {
            String message = "The value of the local variable " + variableDeclaration.getName() + " is not used";
            this.warning(message, (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__NAME, "unused_local_variable", new String[0]);
        }
    }

    protected boolean isLocallyUsed(EObject target, EObject containerToFindUsage) {
        return !XbaseUsageCrossReferencer.find(target, containerToFindUsage).isEmpty();
    }

    @Override
    protected List<EPackage> getEPackages() {
        return Collections.singletonList(XbasePackage.eINSTANCE);
    }

    protected String canonicalName(JvmTypeReference typeRef) {
        return typeRef == null ? "<null>" : Strings.notNull((Object)typeRef.getQualifiedName('.'));
    }

    protected String canonicalName(JvmType type) {
        return type == null ? "<null>" : Strings.notNull((Object)type.getQualifiedName('.'));
    }

    protected boolean isInterface(JvmType type) {
        return type instanceof JvmGenericType && ((JvmGenericType)type).isInterface();
    }

    protected boolean isConformant(JvmType leftType, JvmTypeReference right) {
        JvmParameterizedTypeReference left = this.factory.createJvmParameterizedTypeReference();
        left.setType(leftType);
        return this.conformanceComputer.isConformant((JvmTypeReference)left, right);
    }

    protected boolean isConformant(JvmTypeReference left, JvmTypeReference right) {
        return this.conformanceComputer.isConformant(left, right);
    }

    protected ITypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    protected TypeReferences getTypeRefs() {
        return this.typeRefs;
    }

    protected TypesFactory getTypesFactory() {
        return this.factory;
    }

    protected IEarlyExitComputer getEarlyExitComputer() {
        return this.earlyExitComputer;
    }
}

