/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerExtensions {
    public static int operator_minus(int a) {
        return -a;
    }

    public static int operator_minus(Integer a) {
        return -a.intValue();
    }

    public static int operator_plus(int a, int b) {
        return a + b;
    }

    public static int operator_plus(Integer a, Number b) {
        return a + b.intValue();
    }

    public static int operator_minus(int a, int b) {
        return a - b;
    }

    public static int operator_minus(Integer a, Number b) {
        return a - b.intValue();
    }

    public static int operator_power(int a, int b) {
        return (int)Math.pow(a, b);
    }

    public static int operator_power(Integer a, Number b) {
        return (int)Math.pow(a.intValue(), b.intValue());
    }

    public static int operator_multiply(int a, int b) {
        return a * b;
    }

    public static int operator_multiply(Integer a, Number b) {
        return a * b.intValue();
    }

    public static int operator_divide(int a, int b) {
        return a / b;
    }

    public static int operator_divide(Integer a, Number b) {
        return a / b.intValue();
    }

    public static int operator_modulo(int a, int b) {
        return a % b;
    }

    public static int operator_modulo(Integer a, Number b) {
        return a % b.intValue();
    }

    public static boolean operator_equals(int a, int b) {
        return a == b;
    }

    public static boolean operator_notEquals(int a, int b) {
        return a != b;
    }

    public static boolean operator_lessThan(int a, int b) {
        return a < b;
    }

    public static boolean operator_lessEqualsThan(int a, int b) {
        return a <= b;
    }

    public static boolean operator_greaterThan(int a, int b) {
        return a > b;
    }

    public static boolean operator_greaterEqualsThan(int a, int b) {
        return a >= b;
    }

    public static Iterable<Integer> operator_upTo(final Integer a, Number b) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        final int upTo = b.intValue() + 1;
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new IntIterator(a, upTo);
            }
        };
    }

    public static int bitwiseOr(int a, int b) {
        return a | b;
    }

    public static int bitwiseOr(Integer a, Number b) {
        return a | b.intValue();
    }

    public static int bitwiseXor(int a, int b) {
        return a ^ b;
    }

    public static int bitwiseXor(Integer a, Number b) {
        return a ^ b.intValue();
    }

    public static int bitwiseAnd(int a, int b) {
        return a & b;
    }

    public static int bitwiseAnd(Integer a, Number b) {
        return a & b.intValue();
    }

    public static int bitwiseNot(int a) {
        return ~a;
    }

    public static int bitwiseNot(Integer a) {
        return ~a.intValue();
    }

    public static int shiftLeft(int a, int distance) {
        return a << distance;
    }

    public static int shiftRight(int a, int distance) {
        return a >> distance;
    }

    public static int shiftRightUnsigned(int a, int distance) {
        return a >>> distance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class IntIterator
    implements Iterator<Integer> {
        private int current;
        private int upTo;
        private boolean increases;

        protected IntIterator(int start, int upTo) {
            this.current = start;
            this.upTo = upTo;
            this.increases = start < upTo;
        }

        @Override
        public boolean hasNext() {
            if (this.increases) {
                return this.current < this.upTo;
            }
            return this.current > this.upTo;
        }

        @Override
        public Integer next() {
            if (this.increases) {
                return this.current++;
            }
            return this.current--;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

