/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.preferences;

import com.google.common.collect.Maps;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.LinkedHashMap;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.preferences.PreferenceValuesByLanguage;

@ImplementedBy(value=DefaultPreferenceValuesProvider.class)
public interface IPreferenceValuesProvider {
    public IPreferenceValues getPreferenceValues(Resource var1);

    @Singleton
    public static class SingletonPreferenceValuesProvider
    implements IPreferenceValuesProvider {
        private MapBasedPreferenceValues preferences = new MapBasedPreferenceValues(Maps.newLinkedHashMap());

        @Override
        public MapBasedPreferenceValues getPreferenceValues(Resource context) {
            return this.preferences;
        }
    }

    public static class DefaultPreferenceValuesProvider
    implements IPreferenceValuesProvider {
        @Inject
        private LanguageInfo language;

        @Override
        public IPreferenceValues getPreferenceValues(Resource context) {
            if (context == null) {
                return this.empty();
            }
            PreferenceValuesByLanguage valuesByLanguage = PreferenceValuesByLanguage.findInEmfObject((Notifier)context.getResourceSet());
            if (valuesByLanguage == null) {
                return this.empty();
            }
            IPreferenceValues values = valuesByLanguage.get(this.language.getLanguageName());
            if (values == null) {
                return this.empty();
            }
            return values;
        }

        private IPreferenceValues empty() {
            return new MapBasedPreferenceValues(Maps.newLinkedHashMap());
        }
    }

    public static class SimplePreferenceValuesProvider
    implements IPreferenceValuesProvider {
        @Override
        public IPreferenceValues getPreferenceValues(Resource context) {
            return new MapBasedPreferenceValues(new LinkedHashMap<String, String>());
        }
    }
}

