/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.serializer.impl;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionsFinder;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionDiffBuilder;
import org.eclipse.xtext.ide.serializer.hooks.IReferenceSnapshot;
import org.eclipse.xtext.ide.serializer.hooks.IReferenceUpdater;
import org.eclipse.xtext.ide.serializer.hooks.IReferenceUpdaterContext;
import org.eclipse.xtext.ide.serializer.hooks.IUpdatableReference;
import org.eclipse.xtext.ide.serializer.impl.EObjectDescriptionDeltaProvider;
import org.eclipse.xtext.ide.serializer.impl.RelatedResourcesProvider;
import org.eclipse.xtext.ide.serializer.impl.UpdatableReference;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.serializer.tokens.SerializerScopeProviderBinding;
import org.eclipse.xtext.util.ITextRegion;

public class ReferenceUpdater
implements IReferenceUpdater {
    @Inject
    private IQualifiedNameConverter converter;
    @Inject
    private LinkingHelper linkingHelper;
    @Inject
    private IQualifiedNameConverter nameConverter;
    @Inject
    @SerializerScopeProviderBinding
    private IScopeProvider scopeProvider;
    @Inject
    private IValueConverterService valueConverter;

    protected boolean containsReferenceText(EObjectDescriptionDeltaProvider.Delta delta, QualifiedName exp) {
        block0: for (IEObjectDescription desc : delta.getDescriptions()) {
            QualifiedName cand = desc.getQualifiedName();
            if (cand.getSegmentCount() >= exp.getSegmentCount()) {
                int i = 1;
                while (i <= exp.getSegmentCount()) {
                    String candSeg;
                    String expSeg = exp.getSegment(exp.getSegmentCount() - i);
                    if (!expSeg.equals(candSeg = cand.getSegment(cand.getSegmentCount() - i))) continue block0;
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    protected IUpdatableReference createUpdatableReference(ISemanticRegion current) {
        EReference ref = (EReference)current.getContainingFeature();
        CrossReference crossRef = GrammarUtil.containingCrossReference((EObject)current.getGrammarElement());
        EObject owner = current.getContainingRegion().getSemanticElement();
        Object value = owner.eGet((EStructuralFeature)ref);
        if (value instanceof List) {
            List targets = (List)value;
            int i = current.getIndexInContainingFeature();
            EObject t = (EObject)targets.get(i);
            if (t != null && !t.eIsProxy()) {
                return new UpdatableReference(owner, ref, i, t, crossRef, current);
            }
        } else if (value instanceof EObject) {
            EObject t = (EObject)value;
            if (!t.eIsProxy()) {
                return new UpdatableReference(owner, ref, -1, t, crossRef, current);
            }
        } else {
            throw new IllegalStateException();
        }
        return null;
    }

    public EObjectDescriptionDeltaProvider.Delta findContainingDelta(EObjectDescriptionDeltaProvider.Deltas deltas, EObject obj) {
        EObject current = obj;
        while (current != null) {
            EObjectDescriptionDeltaProvider.Delta delta = deltas.getDelta(current);
            if (delta != null && delta.hasSimpleNameOrUserdataChanged()) {
                return delta;
            }
            current = current.eContainer();
        }
        return null;
    }

    protected String findValidName(IUpdatableReference updatable, IScope scope) {
        Iterable elements = scope.getElements(updatable.getTargetEObject());
        String ruleName = this.linkingHelper.getRuleNameFrom((EObject)updatable.getCrossReference());
        for (IEObjectDescription desc : elements) {
            try {
                String unconverted = this.nameConverter.toString(desc.getName());
                String string = this.valueConverter.toString((Object)unconverted, ruleName);
                return string;
            }
            catch (ValueConverterException valueConverterException) {
                // empty catch block
            }
        }
        return null;
    }

    protected QualifiedName getQualifiedName(IUpdatableReference updatable) {
        String text = updatable.getReferenceRegion().getText();
        String ruleName = this.linkingHelper.getRuleNameFrom((EObject)updatable.getCrossReference());
        try {
            Object converted = this.valueConverter.toValue(text, ruleName, null);
            if (converted != null) {
                return this.converter.toQualifiedName(converted.toString());
            }
        }
        catch (ValueConverterException valueConverterException) {
            // empty catch block
        }
        return null;
    }

    protected ISemanticRegion getRegion(ITextRegionAccess access, IReferenceSnapshot ref) {
        XtextResource resource = access.getResource();
        URI objectUri = ref.getSourceEObjectUri();
        if (!resource.getURI().equals(objectUri.trimFragment())) {
            return null;
        }
        EObject object = resource.getEObject(objectUri.fragment());
        if (object == null) {
            return null;
        }
        ISemanticRegionsFinder finder = access.getExtensions().regionFor(object);
        int index = ref.getIndexInList();
        if (index < 0) {
            return finder.feature((EStructuralFeature)ref.getEReference());
        }
        List list = finder.features(new EStructuralFeature[]{ref.getEReference()});
        if (list != null && index < list.size()) {
            return (ISemanticRegion)list.get(index);
        }
        return null;
    }

    @Override
    public boolean isAffected(EObjectDescriptionDeltaProvider.Deltas deltas, RelatedResourcesProvider.RelatedResource resource) {
        for (IReferenceSnapshot ref : resource.outgoingReferences) {
            EObjectDescriptionDeltaProvider.Delta delta = deltas.getDelta(ref.getTarget().getObject());
            if (delta == null) continue;
            return true;
        }
        return false;
    }

    protected boolean needsUpdating(IReferenceUpdaterContext context, IUpdatableReference ref) {
        QualifiedName fqn = this.getQualifiedName(ref);
        if (fqn == null) {
            return false;
        }
        EObject target = ref.getTargetEObject();
        EObjectDescriptionDeltaProvider.Deltas deltas = context.getEObjectDescriptionDeltas();
        EObjectDescriptionDeltaProvider.Delta delta = deltas.getDelta(target);
        if (delta != null && !this.containsReferenceText(delta, fqn)) {
            return true;
        }
        EObjectDescriptionDeltaProvider.Delta targetDelta = this.findContainingDelta(deltas, target);
        if (targetDelta != null && targetDelta.getObject() == target) {
            return true;
        }
        EObjectDescriptionDeltaProvider.Delta sourceDelta = this.findContainingDelta(deltas, ref.getSourceEObject());
        return !Objects.equal((Object)sourceDelta, (Object)targetDelta);
    }

    @Override
    public void update(IReferenceUpdaterContext context) {
        RelatedResourcesProvider.RelatedResource relatedResource = context.getRelatedResource();
        if (relatedResource == null) {
            this.updateAllReferences(context);
        } else {
            this.updateExternalReferences(context, relatedResource);
        }
    }

    protected void updateAllReferences(IReferenceUpdaterContext context) {
        IEObjectRegion root = context.getModifyableDocument().getOriginalTextRegionAccess().regionForRootEObject();
        ISemanticRegion current = root.getPreviousHiddenRegion().getNextSemanticRegion();
        while (current != null) {
            IUpdatableReference updatable;
            EStructuralFeature feature = current.getContainingFeature();
            if (feature instanceof EReference && !((EReference)feature).isContainment() && (updatable = this.createUpdatableReference(current)) != null && this.needsUpdating(context, updatable)) {
                context.updateReference(updatable);
            }
            current = current.getNextSemanticRegion();
        }
    }

    protected void updateExternalReferences(IReferenceUpdaterContext context, RelatedResourcesProvider.RelatedResource relatedResource) {
        ITextRegionAccess document = context.getModifyableDocument().getOriginalTextRegionAccess();
        for (IReferenceSnapshot ref : relatedResource.outgoingReferences) {
            IUpdatableReference updatable;
            ISemanticRegion region = this.getRegion(document, ref);
            if (region == null || (updatable = this.createUpdatableReference(region)) == null || !this.needsUpdating(context, updatable)) continue;
            context.updateReference(updatable);
        }
    }

    @Override
    public void updateReference(ITextRegionDiffBuilder rewriter, IUpdatableReference upd) {
        ISemanticRegion region;
        QualifiedName oldName;
        IUpdatableReference updatable = upd;
        if (rewriter.isModified((ITextRegion)updatable.getReferenceRegion())) {
            return;
        }
        IScope scope = this.scopeProvider.getScope(updatable.getSourceEObject(), updatable.getEReference());
        IEObjectDescription oldDesc = scope.getSingleElement(oldName = this.nameConverter.toQualifiedName((region = updatable.getReferenceRegion()).getText()));
        if (oldDesc != null && oldDesc.getEObjectOrProxy() == updatable.getTargetEObject()) {
            return;
        }
        String newName = this.findValidName(updatable, scope);
        if (newName != null) {
            rewriter.replace(region, newName);
        }
    }
}

