/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.incremental;

import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.persistence.SerializableEObjectDescription;
import org.eclipse.xtext.resource.persistence.SerializableReferenceDescription;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;

public class ExtendedEObjectOutputStream
extends BinaryResourceImpl.EObjectOutputStream {
    private final byte[] hashBuffer;
    private final Map<IPath, Integer> paths;
    private final Map<char[][], Integer> charchars;
    private final Map<char[], Integer> chars;

    public ExtendedEObjectOutputStream(OutputStream target, int hashBits) throws IOException {
        super(target, Collections.emptyMap(), BinaryResourceImpl.BinaryIO.Version.VERSION_1_1, 16);
        this.hashBuffer = new byte[hashBits / 8];
        this.paths = new HashMap<IPath, Integer>();
        this.charchars = new HashMap<char[][], Integer>();
        this.chars = new HashMap<char[], Integer>();
    }

    public void writeHashCode(HashCode hash) throws IOException {
        hash.writeBytesTo(this.hashBuffer, 0, hash.bits() / 8);
        this.outputStream.write(this.hashBuffer);
    }

    public void writePath(IPath p) throws IOException {
        Integer idx = this.paths.get(p);
        if (idx != null) {
            this.writeCompressedInt(idx);
        } else {
            idx = this.paths.size();
            this.paths.put(p, idx);
            this.writeCompressedInt(idx);
            this.writeSegmentedString(p.toPortableString());
        }
    }

    public void writeCharCharArray(char[][] charchar) throws IOException {
        Integer idx = this.charchars.get(charchar);
        if (idx == null) {
            idx = this.charchars.size();
            this.charchars.put(charchar, idx);
            this.writeCompressedInt(idx);
            this.writeCompressedInt(charchar.length);
            char[][] cArray = charchar;
            int n = charchar.length;
            int n2 = 0;
            while (n2 < n) {
                char[] c = cArray[n2];
                idx = this.chars.get(c);
                if (idx == null) {
                    idx = this.chars.size();
                    this.chars.put(c, idx);
                    this.writeCompressedInt(idx);
                    this.writeString(String.valueOf(c));
                } else {
                    this.writeCompressedInt(idx);
                }
                ++n2;
            }
        } else {
            this.writeCompressedInt(idx);
        }
    }

    public void writeResourceDescription(SerializableResourceDescription description) throws IOException {
        this.writeURI(description.getURI());
        this.writeEObjectDescriptions(description);
        this.writeReferenceDescriptions(description);
        this.writeImportedNames(description);
    }

    protected void writeEObjectDescriptions(SerializableResourceDescription resourceDescription) throws IOException {
        List objects = resourceDescription.getDescriptions();
        this.writeCompressedInt(objects.size());
        for (SerializableEObjectDescription object : objects) {
            this.writeURI(object.getEObjectURI());
            this.writeEClass(object.getEClass());
            object.getQualifiedName().writeToStream((BinaryResourceImpl.EObjectOutputStream)this);
            HashMap userData = object.getUserData();
            if (userData != null) {
                this.writeCompressedInt(userData.size());
                for (Map.Entry entry : userData.entrySet()) {
                    this.writeString((String)entry.getKey());
                    this.writeString((String)entry.getValue());
                }
                continue;
            }
            this.writeCompressedInt(0);
        }
    }

    protected void writeReferenceDescriptions(SerializableResourceDescription resourceDescription) throws IOException {
        List references = resourceDescription.getReferences();
        this.writeCompressedInt(references.size());
        for (SerializableReferenceDescription reference : references) {
            this.writeURI(reference.getSourceEObjectUri());
            this.writeURI(reference.getTargetEObjectUri());
            this.writeURI(reference.getContainerEObjectURI());
            this.writeEStructuralFeature((EStructuralFeature)reference.getEReference());
            this.writeCompressedInt(reference.getIndexInList());
        }
    }

    protected void writeImportedNames(SerializableResourceDescription resourceDescription) throws IOException {
        ArrayList importedNames = Lists.newArrayList((Iterable)resourceDescription.getImportedNames());
        this.writeCompressedInt(importedNames.size());
        for (QualifiedName importedName : importedNames) {
            importedName.writeToStream((BinaryResourceImpl.EObjectOutputStream)this);
        }
    }

    public void writeURI(URI uri) throws IOException {
        if (uri == null) {
            this.writeCompressedInt(-1);
        } else {
            this.writeURI(uri.trimFragment(), uri.fragment());
        }
    }
}

