/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.AbstractJvmTypeProvider;
import org.eclipse.xtext.common.types.access.impl.ClassFinder;
import org.eclipse.xtext.common.types.access.impl.ClassMirror;
import org.eclipse.xtext.common.types.access.impl.ClassURIHelper;
import org.eclipse.xtext.common.types.access.impl.DeclaredTypeFactory;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathTypeProvider
extends AbstractJvmTypeProvider {
    private final ClassFinder classFinder;
    private final DeclaredTypeFactory declaredTypeFactory;
    private final ClassURIHelper uriHelper;

    public ClasspathTypeProvider(ClassLoader classLoader, ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess) {
        super(resourceSet, indexedJvmTypeAccess);
        this.classFinder = this.createClassFinder(classLoader);
        this.uriHelper = this.createClassURIHelper();
        this.declaredTypeFactory = this.createDeclaredTypeFactory();
    }

    @Deprecated
    public ClasspathTypeProvider(ClassLoader classLoader, ResourceSet resourceSet) {
        this(classLoader, resourceSet, null);
    }

    @Override
    protected void registerProtocol(ResourceSet resourceSet) {
        super.registerProtocol(resourceSet);
        resourceSet.eAdapters().add((Object)new TypeInResourceSetAdapter());
    }

    protected ClassFinder createClassFinder(ClassLoader classLoader) {
        return new ClassFinder(classLoader);
    }

    protected DeclaredTypeFactory createDeclaredTypeFactory() {
        return new DeclaredTypeFactory(this.uriHelper);
    }

    protected ClassURIHelper createClassURIHelper() {
        return new ClassURIHelper();
    }

    public ClassURIHelper getClassURIHelper() {
        return this.uriHelper;
    }

    public DeclaredTypeFactory getDeclaredTypeFactory() {
        return this.declaredTypeFactory;
    }

    public ClassFinder getClassFinder() {
        return this.classFinder;
    }

    @Override
    public JvmType findTypeByName(String name) {
        try {
            Class<?> clazz = this.classFinder.forName(name);
            return this.findTypeByClass(clazz);
        }
        catch (ClassNotFoundException e) {
            return this.tryFindTypeInIndex(name, true);
        }
        catch (NoClassDefFoundError e) {
            return this.tryFindTypeInIndex(name, true);
        }
    }

    @Override
    public JvmType findTypeByName(String name, boolean binaryNestedTypeDelimiter) {
        if (this.isBinaryNestedTypeDelimiter(name, binaryNestedTypeDelimiter)) {
            return this.findTypeByName(name);
        }
        return this.doFindTypeByName(name);
    }

    private JvmType doFindTypeByName(String name) {
        try {
            Class<?> clazz = this.findClassByName(name);
            return this.findTypeByClass(clazz);
        }
        catch (ClassNotFoundException e) {
            return this.tryFindTypeInIndex(name, false);
        }
        catch (NoClassDefFoundError e) {
            return this.tryFindTypeInIndex(name, false);
        }
    }

    private JvmType findTypeByClass(Class<?> clazz) {
        URI proxyURI;
        EObject candidate;
        IndexedJvmTypeAccess indexedJvmTypeAccess = this.getIndexedJvmTypeAccess();
        URI resourceURI = this.uriHelper.createResourceURI(clazz);
        if (indexedJvmTypeAccess != null && (candidate = indexedJvmTypeAccess.getIndexedJvmType(proxyURI = resourceURI.appendFragment(this.uriHelper.getFragment(clazz)), this.getResourceSet())) instanceof JvmType) {
            return (JvmType)candidate;
        }
        TypeResource result = (TypeResource)this.getResourceSet().getResource(resourceURI, true);
        return this.findTypeByClass(clazz, (Resource)result);
    }

    private Class<?> findClassByName(String name) throws ClassNotFoundException {
        try {
            Class<?> clazz = this.classFinder.forName(name);
            return clazz;
        }
        catch (ClassNotFoundException exception) {
            int index = name.lastIndexOf(46);
            if (index <= 0) {
                throw exception;
            }
            String baseName = name.substring(0, index);
            try {
                Class<?> resolvedOuterClass = this.findClassByName(baseName);
                baseName = resolvedOuterClass.getName();
            }
            catch (ClassNotFoundException baseNameException) {
                throw exception;
            }
            Class<?> clazz = this.classFinder.forName(String.valueOf(baseName) + '$' + name.substring(index + 1));
            return clazz;
        }
    }

    protected JvmType tryFindTypeInIndex(String name, boolean binaryNestedTypeDelimiter) {
        TypeInResourceSetAdapter adapter = (TypeInResourceSetAdapter)EcoreUtil.getAdapter((List)this.getResourceSet().eAdapters(), TypeInResourceSetAdapter.class);
        if (adapter != null) {
            return adapter.tryFindTypeInIndex(name, this, binaryNestedTypeDelimiter);
        }
        return this.doTryFindInIndex(name, binaryNestedTypeDelimiter);
    }

    @Nullable
    private JvmType doTryFindInIndex(String name, boolean binaryNestedTypeDelimiter) {
        IndexedJvmTypeAccess indexAccess = this.getIndexedJvmTypeAccess();
        if (indexAccess != null) {
            JvmType result = this.doTryFindInIndex(name, indexAccess);
            if (result == null && !this.isBinaryNestedTypeDelimiter(name, binaryNestedTypeDelimiter)) {
                AbstractJvmTypeProvider.ClassNameVariants variants = new AbstractJvmTypeProvider.ClassNameVariants(name);
                while (result == null && variants.hasNext()) {
                    String nextVariant = (String)variants.next();
                    result = this.doTryFindInIndex(nextVariant, indexAccess);
                }
            }
            return result;
        }
        return null;
    }

    private JvmType doTryFindInIndex(String name, IndexedJvmTypeAccess indexAccess) {
        String qualifiedNameString;
        List nameSegments;
        QualifiedName qualifiedName;
        EObject candidate;
        int index = name.indexOf(36);
        if (index < 0) {
            index = name.indexOf(91);
        }
        if ((candidate = indexAccess.getIndexedJvmType(qualifiedName = QualifiedName.create((List)(nameSegments = Strings.split((String)(qualifiedNameString = index < 0 ? name : name.substring(0, index)), (char)'.'))), name, this.getResourceSet())) instanceof JvmType) {
            return (JvmType)candidate;
        }
        return null;
    }

    @Override
    protected IMirror createMirrorForFQN(String name) {
        try {
            Class<?> clazz = this.classFinder.forName(name);
            return this.createMirror(clazz);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public ClassMirror createMirror(Class<?> clazz) {
        return ClassMirror.createClassMirror(clazz, this.declaredTypeFactory);
    }

    public JvmType findTypeByClass(Class<?> clazz, Resource resource) {
        String fragment = this.uriHelper.getFragment(clazz);
        JvmType result = (JvmType)resource.getEObject(fragment);
        if (result == null) {
            throw new IllegalStateException("Resource has not been loaded");
        }
        return result;
    }

    protected static class TypeInResourceSetAdapter
    extends AdapterImpl {
        private Map<String, JvmType> typeByQueryString = Maps.newHashMap();

        protected TypeInResourceSetAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return TypeInResourceSetAdapter.class.equals(type);
        }

        protected JvmType tryFindTypeInIndex(String name, ClasspathTypeProvider typeProvider, boolean binaryNestedTypeDelimiter) {
            JvmType result = this.typeByQueryString.get(name);
            if (result != null) {
                return result;
            }
            JvmType candidate = typeProvider.doTryFindInIndex(name, binaryNestedTypeDelimiter);
            if (candidate != null) {
                this.typeByQueryString.put(name, candidate);
                return candidate;
            }
            return null;
        }
    }
}

