/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.linking.impl.XtextLinkingDiagnostic;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractUnresolvableReferenceWithNode;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkHelper;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class UnresolvableFeatureCall
extends AbstractUnresolvableReferenceWithNode
implements IFeatureLinkingCandidate {
    public UnresolvableFeatureCall(XAbstractFeatureCall featureCall, INode node, String text, ExpressionTypeComputationState state) {
        super(featureCall, node, text, state);
    }

    @Override
    public XAbstractFeatureCall getFeatureCall() {
        return (XAbstractFeatureCall)this.getExpression();
    }

    @Override
    protected List<XExpression> getArguments() {
        return this.getFeatureCall().getExplicitArguments();
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isExtension() {
        return false;
    }

    @Override
    public boolean isTypeLiteral() {
        return false;
    }

    public EReference getReference() {
        return XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE;
    }

    @Override
    public List<LightweightTypeReference> getTypeArguments() {
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        EList<JvmTypeReference> typeArguments = featureCall.getTypeArguments();
        if (typeArguments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (JvmTypeReference typeArgument : typeArguments) {
            result.add(this.getConverter().toLightweightReference(typeArgument));
        }
        return result;
    }

    @Override
    protected Resource.Diagnostic createDiagnostic(DiagnosticMessage message) {
        String messageString = message.getMessage();
        String issueCode = message.getIssueCode();
        if (messageString.startsWith("Couldn't resolve reference to JvmIdentifiableElement") && this.getFeatureCall().isExplicitOperationCallOrBuilderSyntax()) {
            List<XExpression> arguments = new FeatureLinkHelper().getSyntacticArguments(this.getFeatureCall());
            String argumentTypes = "";
            if (!arguments.isEmpty()) {
                StackedResolvedTypes resolvedTypes = this.getResolvedTypes();
                StringBuilder argumentTypesBuilder = new StringBuilder();
                for (XExpression argument : arguments) {
                    LightweightTypeReference argumentType;
                    if (argumentTypesBuilder.length() != 0) {
                        argumentTypesBuilder.append(", ");
                    }
                    if ((argumentType = resolvedTypes.getActualType(argument)) == null || argumentType.isAny()) {
                        argumentTypesBuilder.append("Object");
                        continue;
                    }
                    argumentTypesBuilder.append(argumentType.getSimpleName());
                }
                argumentTypes = argumentTypesBuilder.toString();
            }
            messageString = "The method " + this.getLinkText() + "(" + argumentTypes + ") is undefined";
            issueCode = "org.eclipse.xtext.diagnostics.Diagnostic.Linking";
        }
        XtextLinkingDiagnostic diagnostic = new XtextLinkingDiagnostic(this.getNode(), messageString, issueCode, message.getIssueData());
        return diagnostic;
    }

    @Nullable
    protected XExpression getSyntacticReceiver() {
        return new FeatureLinkHelper().getSyntacticReceiver(this.getFeatureCall());
    }
}

