/**
 * Copyright (c) 2011-2013 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.xtext.common.types.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.xtext.common.types.util.TypesAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class TypesItemProviderAdapterFactory extends TypesAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable
{
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypesItemProviderAdapterFactory()
	{
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmVoid} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmVoidItemProvider jvmVoidItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmVoid}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmVoidAdapter()
	{
		if (jvmVoidItemProvider == null)
		{
			jvmVoidItemProvider = new JvmVoidItemProvider(this);
		}

		return jvmVoidItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmPrimitiveType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmPrimitiveTypeItemProvider jvmPrimitiveTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmPrimitiveType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmPrimitiveTypeAdapter()
	{
		if (jvmPrimitiveTypeItemProvider == null)
		{
			jvmPrimitiveTypeItemProvider = new JvmPrimitiveTypeItemProvider(this);
		}

		return jvmPrimitiveTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmArrayType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmArrayTypeItemProvider jvmArrayTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmArrayType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmArrayTypeAdapter()
	{
		if (jvmArrayTypeItemProvider == null)
		{
			jvmArrayTypeItemProvider = new JvmArrayTypeItemProvider(this);
		}

		return jvmArrayTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmTypeParameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmTypeParameterItemProvider jvmTypeParameterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmTypeParameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmTypeParameterAdapter()
	{
		if (jvmTypeParameterItemProvider == null)
		{
			jvmTypeParameterItemProvider = new JvmTypeParameterItemProvider(this);
		}

		return jvmTypeParameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmUpperBound} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmUpperBoundItemProvider jvmUpperBoundItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmUpperBound}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmUpperBoundAdapter()
	{
		if (jvmUpperBoundItemProvider == null)
		{
			jvmUpperBoundItemProvider = new JvmUpperBoundItemProvider(this);
		}

		return jvmUpperBoundItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmLowerBound} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmLowerBoundItemProvider jvmLowerBoundItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmLowerBound}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmLowerBoundAdapter()
	{
		if (jvmLowerBoundItemProvider == null)
		{
			jvmLowerBoundItemProvider = new JvmLowerBoundItemProvider(this);
		}

		return jvmLowerBoundItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmAnnotationType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmAnnotationTypeItemProvider jvmAnnotationTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmAnnotationType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmAnnotationTypeAdapter()
	{
		if (jvmAnnotationTypeItemProvider == null)
		{
			jvmAnnotationTypeItemProvider = new JvmAnnotationTypeItemProvider(this);
		}

		return jvmAnnotationTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmEnumerationType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmEnumerationTypeItemProvider jvmEnumerationTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmEnumerationType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmEnumerationTypeAdapter()
	{
		if (jvmEnumerationTypeItemProvider == null)
		{
			jvmEnumerationTypeItemProvider = new JvmEnumerationTypeItemProvider(this);
		}

		return jvmEnumerationTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmEnumerationLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmEnumerationLiteralItemProvider jvmEnumerationLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmEnumerationLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmEnumerationLiteralAdapter()
	{
		if (jvmEnumerationLiteralItemProvider == null)
		{
			jvmEnumerationLiteralItemProvider = new JvmEnumerationLiteralItemProvider(this);
		}

		return jvmEnumerationLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmGenericType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmGenericTypeItemProvider jvmGenericTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmGenericType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmGenericTypeAdapter()
	{
		if (jvmGenericTypeItemProvider == null)
		{
			jvmGenericTypeItemProvider = new JvmGenericTypeItemProvider(this);
		}

		return jvmGenericTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmParameterizedTypeReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmParameterizedTypeReferenceItemProvider jvmParameterizedTypeReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmParameterizedTypeReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmParameterizedTypeReferenceAdapter()
	{
		if (jvmParameterizedTypeReferenceItemProvider == null)
		{
			jvmParameterizedTypeReferenceItemProvider = new JvmParameterizedTypeReferenceItemProvider(this);
		}

		return jvmParameterizedTypeReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmGenericArrayTypeReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmGenericArrayTypeReferenceItemProvider jvmGenericArrayTypeReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmGenericArrayTypeReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmGenericArrayTypeReferenceAdapter()
	{
		if (jvmGenericArrayTypeReferenceItemProvider == null)
		{
			jvmGenericArrayTypeReferenceItemProvider = new JvmGenericArrayTypeReferenceItemProvider(this);
		}

		return jvmGenericArrayTypeReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmWildcardTypeReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmWildcardTypeReferenceItemProvider jvmWildcardTypeReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmWildcardTypeReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmWildcardTypeReferenceAdapter()
	{
		if (jvmWildcardTypeReferenceItemProvider == null)
		{
			jvmWildcardTypeReferenceItemProvider = new JvmWildcardTypeReferenceItemProvider(this);
		}

		return jvmWildcardTypeReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmAnyTypeReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmAnyTypeReferenceItemProvider jvmAnyTypeReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmAnyTypeReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmAnyTypeReferenceAdapter()
	{
		if (jvmAnyTypeReferenceItemProvider == null)
		{
			jvmAnyTypeReferenceItemProvider = new JvmAnyTypeReferenceItemProvider(this);
		}

		return jvmAnyTypeReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmMultiTypeReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmMultiTypeReferenceItemProvider jvmMultiTypeReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmMultiTypeReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmMultiTypeReferenceAdapter()
	{
		if (jvmMultiTypeReferenceItemProvider == null)
		{
			jvmMultiTypeReferenceItemProvider = new JvmMultiTypeReferenceItemProvider(this);
		}

		return jvmMultiTypeReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmField} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmFieldItemProvider jvmFieldItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmField}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmFieldAdapter()
	{
		if (jvmFieldItemProvider == null)
		{
			jvmFieldItemProvider = new JvmFieldItemProvider(this);
		}

		return jvmFieldItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmConstructor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmConstructorItemProvider jvmConstructorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmConstructor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmConstructorAdapter()
	{
		if (jvmConstructorItemProvider == null)
		{
			jvmConstructorItemProvider = new JvmConstructorItemProvider(this);
		}

		return jvmConstructorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmOperation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmOperationItemProvider jvmOperationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmOperation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmOperationAdapter()
	{
		if (jvmOperationItemProvider == null)
		{
			jvmOperationItemProvider = new JvmOperationItemProvider(this);
		}

		return jvmOperationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmFormalParameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmFormalParameterItemProvider jvmFormalParameterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmFormalParameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmFormalParameterAdapter()
	{
		if (jvmFormalParameterItemProvider == null)
		{
			jvmFormalParameterItemProvider = new JvmFormalParameterItemProvider(this);
		}

		return jvmFormalParameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmAnnotationReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmAnnotationReferenceItemProvider jvmAnnotationReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmAnnotationReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmAnnotationReferenceAdapter()
	{
		if (jvmAnnotationReferenceItemProvider == null)
		{
			jvmAnnotationReferenceItemProvider = new JvmAnnotationReferenceItemProvider(this);
		}

		return jvmAnnotationReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmIntAnnotationValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmIntAnnotationValueItemProvider jvmIntAnnotationValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmIntAnnotationValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmIntAnnotationValueAdapter()
	{
		if (jvmIntAnnotationValueItemProvider == null)
		{
			jvmIntAnnotationValueItemProvider = new JvmIntAnnotationValueItemProvider(this);
		}

		return jvmIntAnnotationValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmBooleanAnnotationValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmBooleanAnnotationValueItemProvider jvmBooleanAnnotationValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmBooleanAnnotationValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmBooleanAnnotationValueAdapter()
	{
		if (jvmBooleanAnnotationValueItemProvider == null)
		{
			jvmBooleanAnnotationValueItemProvider = new JvmBooleanAnnotationValueItemProvider(this);
		}

		return jvmBooleanAnnotationValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmByteAnnotationValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmByteAnnotationValueItemProvider jvmByteAnnotationValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmByteAnnotationValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmByteAnnotationValueAdapter()
	{
		if (jvmByteAnnotationValueItemProvider == null)
		{
			jvmByteAnnotationValueItemProvider = new JvmByteAnnotationValueItemProvider(this);
		}

		return jvmByteAnnotationValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmShortAnnotationValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmShortAnnotationValueItemProvider jvmShortAnnotationValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmShortAnnotationValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmShortAnnotationValueAdapter()
	{
		if (jvmShortAnnotationValueItemProvider == null)
		{
			jvmShortAnnotationValueItemProvider = new JvmShortAnnotationValueItemProvider(this);
		}

		return jvmShortAnnotationValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmLongAnnotationValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmLongAnnotationValueItemProvider jvmLongAnnotationValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmLongAnnotationValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmLongAnnotationValueAdapter()
	{
		if (jvmLongAnnotationValueItemProvider == null)
		{
			jvmLongAnnotationValueItemProvider = new JvmLongAnnotationValueItemProvider(this);
		}

		return jvmLongAnnotationValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmDoubleAnnotationValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmDoubleAnnotationValueItemProvider jvmDoubleAnnotationValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmDoubleAnnotationValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmDoubleAnnotationValueAdapter()
	{
		if (jvmDoubleAnnotationValueItemProvider == null)
		{
			jvmDoubleAnnotationValueItemProvider = new JvmDoubleAnnotationValueItemProvider(this);
		}

		return jvmDoubleAnnotationValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmFloatAnnotationValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmFloatAnnotationValueItemProvider jvmFloatAnnotationValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmFloatAnnotationValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmFloatAnnotationValueAdapter()
	{
		if (jvmFloatAnnotationValueItemProvider == null)
		{
			jvmFloatAnnotationValueItemProvider = new JvmFloatAnnotationValueItemProvider(this);
		}

		return jvmFloatAnnotationValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmCharAnnotationValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmCharAnnotationValueItemProvider jvmCharAnnotationValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmCharAnnotationValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmCharAnnotationValueAdapter()
	{
		if (jvmCharAnnotationValueItemProvider == null)
		{
			jvmCharAnnotationValueItemProvider = new JvmCharAnnotationValueItemProvider(this);
		}

		return jvmCharAnnotationValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmStringAnnotationValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmStringAnnotationValueItemProvider jvmStringAnnotationValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmStringAnnotationValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmStringAnnotationValueAdapter()
	{
		if (jvmStringAnnotationValueItemProvider == null)
		{
			jvmStringAnnotationValueItemProvider = new JvmStringAnnotationValueItemProvider(this);
		}

		return jvmStringAnnotationValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmTypeAnnotationValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmTypeAnnotationValueItemProvider jvmTypeAnnotationValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmTypeAnnotationValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmTypeAnnotationValueAdapter()
	{
		if (jvmTypeAnnotationValueItemProvider == null)
		{
			jvmTypeAnnotationValueItemProvider = new JvmTypeAnnotationValueItemProvider(this);
		}

		return jvmTypeAnnotationValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmAnnotationAnnotationValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmAnnotationAnnotationValueItemProvider jvmAnnotationAnnotationValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmAnnotationAnnotationValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmAnnotationAnnotationValueAdapter()
	{
		if (jvmAnnotationAnnotationValueItemProvider == null)
		{
			jvmAnnotationAnnotationValueItemProvider = new JvmAnnotationAnnotationValueItemProvider(this);
		}

		return jvmAnnotationAnnotationValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmEnumAnnotationValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmEnumAnnotationValueItemProvider jvmEnumAnnotationValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmEnumAnnotationValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmEnumAnnotationValueAdapter()
	{
		if (jvmEnumAnnotationValueItemProvider == null)
		{
			jvmEnumAnnotationValueItemProvider = new JvmEnumAnnotationValueItemProvider(this);
		}

		return jvmEnumAnnotationValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmDelegateTypeReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmDelegateTypeReferenceItemProvider jvmDelegateTypeReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmDelegateTypeReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmDelegateTypeReferenceAdapter()
	{
		if (jvmDelegateTypeReferenceItemProvider == null)
		{
			jvmDelegateTypeReferenceItemProvider = new JvmDelegateTypeReferenceItemProvider(this);
		}

		return jvmDelegateTypeReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmSynonymTypeReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmSynonymTypeReferenceItemProvider jvmSynonymTypeReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmSynonymTypeReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmSynonymTypeReferenceAdapter()
	{
		if (jvmSynonymTypeReferenceItemProvider == null)
		{
			jvmSynonymTypeReferenceItemProvider = new JvmSynonymTypeReferenceItemProvider(this);
		}

		return jvmSynonymTypeReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmUnknownTypeReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmUnknownTypeReferenceItemProvider jvmUnknownTypeReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmUnknownTypeReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmUnknownTypeReferenceAdapter()
	{
		if (jvmUnknownTypeReferenceItemProvider == null)
		{
			jvmUnknownTypeReferenceItemProvider = new JvmUnknownTypeReferenceItemProvider(this);
		}

		return jvmUnknownTypeReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.xtext.common.types.JvmCustomAnnotationValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmCustomAnnotationValueItemProvider jvmCustomAnnotationValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.xtext.common.types.JvmCustomAnnotationValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJvmCustomAnnotationValueAdapter()
	{
		if (jvmCustomAnnotationValueItemProvider == null)
		{
			jvmCustomAnnotationValueItemProvider = new JvmCustomAnnotationValueItemProvider(this);
		}

		return jvmCustomAnnotationValueItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory()
	{
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory)
	{
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type)
	{
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type)
	{
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type)
	{
		if (isFactoryForType(type))
		{
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter)))
			{
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification)
	{
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null)
		{
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose()
	{
		if (jvmVoidItemProvider != null) jvmVoidItemProvider.dispose();
		if (jvmPrimitiveTypeItemProvider != null) jvmPrimitiveTypeItemProvider.dispose();
		if (jvmArrayTypeItemProvider != null) jvmArrayTypeItemProvider.dispose();
		if (jvmTypeParameterItemProvider != null) jvmTypeParameterItemProvider.dispose();
		if (jvmUpperBoundItemProvider != null) jvmUpperBoundItemProvider.dispose();
		if (jvmLowerBoundItemProvider != null) jvmLowerBoundItemProvider.dispose();
		if (jvmAnnotationTypeItemProvider != null) jvmAnnotationTypeItemProvider.dispose();
		if (jvmEnumerationTypeItemProvider != null) jvmEnumerationTypeItemProvider.dispose();
		if (jvmEnumerationLiteralItemProvider != null) jvmEnumerationLiteralItemProvider.dispose();
		if (jvmGenericTypeItemProvider != null) jvmGenericTypeItemProvider.dispose();
		if (jvmParameterizedTypeReferenceItemProvider != null) jvmParameterizedTypeReferenceItemProvider.dispose();
		if (jvmGenericArrayTypeReferenceItemProvider != null) jvmGenericArrayTypeReferenceItemProvider.dispose();
		if (jvmWildcardTypeReferenceItemProvider != null) jvmWildcardTypeReferenceItemProvider.dispose();
		if (jvmAnyTypeReferenceItemProvider != null) jvmAnyTypeReferenceItemProvider.dispose();
		if (jvmMultiTypeReferenceItemProvider != null) jvmMultiTypeReferenceItemProvider.dispose();
		if (jvmFieldItemProvider != null) jvmFieldItemProvider.dispose();
		if (jvmConstructorItemProvider != null) jvmConstructorItemProvider.dispose();
		if (jvmOperationItemProvider != null) jvmOperationItemProvider.dispose();
		if (jvmFormalParameterItemProvider != null) jvmFormalParameterItemProvider.dispose();
		if (jvmAnnotationReferenceItemProvider != null) jvmAnnotationReferenceItemProvider.dispose();
		if (jvmIntAnnotationValueItemProvider != null) jvmIntAnnotationValueItemProvider.dispose();
		if (jvmBooleanAnnotationValueItemProvider != null) jvmBooleanAnnotationValueItemProvider.dispose();
		if (jvmByteAnnotationValueItemProvider != null) jvmByteAnnotationValueItemProvider.dispose();
		if (jvmShortAnnotationValueItemProvider != null) jvmShortAnnotationValueItemProvider.dispose();
		if (jvmLongAnnotationValueItemProvider != null) jvmLongAnnotationValueItemProvider.dispose();
		if (jvmDoubleAnnotationValueItemProvider != null) jvmDoubleAnnotationValueItemProvider.dispose();
		if (jvmFloatAnnotationValueItemProvider != null) jvmFloatAnnotationValueItemProvider.dispose();
		if (jvmCharAnnotationValueItemProvider != null) jvmCharAnnotationValueItemProvider.dispose();
		if (jvmStringAnnotationValueItemProvider != null) jvmStringAnnotationValueItemProvider.dispose();
		if (jvmTypeAnnotationValueItemProvider != null) jvmTypeAnnotationValueItemProvider.dispose();
		if (jvmAnnotationAnnotationValueItemProvider != null) jvmAnnotationAnnotationValueItemProvider.dispose();
		if (jvmEnumAnnotationValueItemProvider != null) jvmEnumAnnotationValueItemProvider.dispose();
		if (jvmDelegateTypeReferenceItemProvider != null) jvmDelegateTypeReferenceItemProvider.dispose();
		if (jvmSynonymTypeReferenceItemProvider != null) jvmSynonymTypeReferenceItemProvider.dispose();
		if (jvmUnknownTypeReferenceItemProvider != null) jvmUnknownTypeReferenceItemProvider.dispose();
		if (jvmCustomAnnotationValueItemProvider != null) jvmCustomAnnotationValueItemProvider.dispose();
	}

}
