/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeConformanceComputationArgument;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeConformanceResult;
import org.eclipse.xtext.common.types.util.TypeConformanceStrategy;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ParameterizedTypeConformanceStrategy
extends TypeConformanceStrategy<JvmParameterizedTypeReference> {
    public ParameterizedTypeConformanceStrategy(TypeConformanceComputer conformanceComputer) {
        super(conformanceComputer);
    }

    @Override
    public TypeConformanceResult doVisitGenericArrayTypeReference(JvmParameterizedTypeReference left, JvmGenericArrayTypeReference right, TypeConformanceComputationArgument.Internal<JvmParameterizedTypeReference> param) {
        if (this.conformanceComputer.getTypeReferences().is(left, Object.class)) {
            return TypeConformanceResult.SUBTYPE;
        }
        if (this.conformanceComputer.getTypeReferences().is(left, Serializable.class)) {
            return TypeConformanceResult.SUBTYPE;
        }
        if (this.conformanceComputer.getTypeReferences().is(left, Cloneable.class)) {
            return TypeConformanceResult.SUBTYPE;
        }
        return TypeConformanceResult.FAILED;
    }

    @Override
    public TypeConformanceResult doVisitParameterizedTypeReference(JvmParameterizedTypeReference leftReference, JvmParameterizedTypeReference rightReference, TypeConformanceComputationArgument.Internal<JvmParameterizedTypeReference> param) {
        JvmType leftType = leftReference.getType();
        if (this.isUnresolved(leftType)) {
            return TypeConformanceResult.FAILED;
        }
        JvmType rightType = rightReference.getType();
        if (this.isUnresolved(rightType)) {
            return TypeConformanceResult.FAILED;
        }
        if (this.isPrimitiveVoid(leftType)) {
            if (this.isPrimitiveVoid(rightType)) {
                return TypeConformanceResult.SUCCESS;
            }
            return TypeConformanceResult.FAILED;
        }
        if (this.isPrimitiveVoid(rightType)) {
            return TypeConformanceResult.FAILED;
        }
        return this.isConformant(leftType, rightType, leftReference, rightReference, param);
    }

    protected boolean isPrimitiveVoid(JvmType type) {
        return type instanceof JvmVoid;
    }

    protected TypeConformanceResult isConformant(JvmType leftType, JvmType rightType, JvmParameterizedTypeReference leftReference, JvmParameterizedTypeReference rightReference, TypeConformanceComputationArgument.Internal<JvmParameterizedTypeReference> param) {
        if (leftType == rightType) {
            if (param.rawType) {
                return TypeConformanceResult.SUCCESS;
            }
            if (!leftReference.getArguments().isEmpty() || !rightReference.getArguments().isEmpty()) {
                return this.areArgumentsConformant(leftReference, rightReference);
            }
            return TypeConformanceResult.SUCCESS;
        }
        if (param.allowPrimitiveConversion) {
            TypeConformanceResult result;
            JvmTypeReference potentialWrapper;
            if (leftType instanceof JvmPrimitiveType) {
                JvmTypeReference potentialPrimitive;
                if (rightType instanceof JvmPrimitiveType) {
                    if (this.isWideningConversion((JvmPrimitiveType)leftType, (JvmPrimitiveType)rightType)) {
                        return new TypeConformanceResult(TypeConformanceResult.Kind.PRIMITIVE_WIDENING);
                    }
                } else if (rightType instanceof JvmGenericType && (potentialPrimitive = this.conformanceComputer.getPrimitives().asPrimitiveIfWrapperType(rightReference)) != rightReference && (leftType == potentialPrimitive.getType() || this.isWideningConversion((JvmPrimitiveType)leftType, (JvmPrimitiveType)potentialPrimitive.getType()))) {
                    return new TypeConformanceResult(TypeConformanceResult.Kind.UNBOXING);
                }
            } else if (rightType instanceof JvmPrimitiveType && leftType instanceof JvmGenericType && (potentialWrapper = this.conformanceComputer.getPrimitives().asWrapperTypeIfPrimitive(rightReference)) != rightReference && (result = this.conformanceComputer.isConformant((JvmTypeReference)leftReference, potentialWrapper, param)).isConformant()) {
                return new TypeConformanceResult(TypeConformanceResult.Kind.BOXING);
            }
        }
        if (!param.asTypeArgument) {
            if (leftType instanceof JvmDeclaredType && this.conformanceComputer.getTypeReferences().is(leftReference, Object.class)) {
                return TypeConformanceResult.SUBTYPE;
            }
            if (rightType instanceof JvmTypeParameter) {
                EList rightConstraints = ((JvmTypeParameter)rightType).getConstraints();
                if (!rightConstraints.isEmpty()) {
                    for (JvmTypeConstraint rightConstraint : rightConstraints) {
                        if (rightConstraint instanceof JvmUpperBound) {
                            TypeConformanceResult candidate = this.conformanceComputer.isConformant((JvmTypeReference)leftReference, rightConstraint.getTypeReference(), param);
                            if (!candidate.isConformant()) continue;
                            return candidate;
                        }
                        return TypeConformanceResult.FAILED;
                    }
                }
                return TypeConformanceResult.FAILED;
            }
            if (leftType instanceof JvmTypeParameter) {
                return TypeConformanceResult.FAILED;
            }
            if (leftType instanceof JvmDeclaredType && rightType instanceof JvmDeclaredType && this.conformanceComputer.getSuperTypeCollector().isSuperType((JvmDeclaredType)rightType, (JvmDeclaredType)leftType)) {
                if (param.rawType) {
                    return TypeConformanceResult.SUBTYPE;
                }
                if (leftReference.getArguments().isEmpty() || rightReference.getArguments().isEmpty()) {
                    return TypeConformanceResult.SUBTYPE;
                }
                return this.areArgumentsConformant(leftReference, rightReference);
            }
        }
        return TypeConformanceResult.FAILED;
    }

    protected boolean isWideningConversion(JvmPrimitiveType leftType, JvmPrimitiveType rightType) {
        Primitives.Primitive left = this.primitiveKind(leftType);
        Primitives.Primitive right = this.primitiveKind(rightType);
        switch (right) {
            case Byte: {
                return left == Primitives.Primitive.Short || left == Primitives.Primitive.Char || left == Primitives.Primitive.Int || left == Primitives.Primitive.Long || left == Primitives.Primitive.Float || left == Primitives.Primitive.Double;
            }
            case Short: {
                return left == Primitives.Primitive.Int || left == Primitives.Primitive.Long || left == Primitives.Primitive.Float || left == Primitives.Primitive.Double;
            }
            case Char: {
                return left == Primitives.Primitive.Int || left == Primitives.Primitive.Long || left == Primitives.Primitive.Float || left == Primitives.Primitive.Double;
            }
            case Int: {
                return left == Primitives.Primitive.Long || left == Primitives.Primitive.Float || left == Primitives.Primitive.Double;
            }
            case Long: {
                return left == Primitives.Primitive.Float || left == Primitives.Primitive.Double;
            }
            case Float: {
                return left == Primitives.Primitive.Double;
            }
        }
        return false;
    }

    protected Primitives.Primitive primitiveKind(JvmPrimitiveType primitiveType) {
        return this.conformanceComputer.getPrimitives().primitiveKind(primitiveType);
    }

    protected TypeConformanceResult areArgumentsConformant(JvmParameterizedTypeReference leftReference, JvmParameterizedTypeReference rightReference) {
        TypeArgumentContext leftArgumentContext = this.getBoundTypeParameters(leftReference);
        if (leftArgumentContext != null && !leftArgumentContext.isRawTypeContext()) {
            Collection<JvmTypeParameter> boundParameters = leftArgumentContext.getBoundParameters();
            HashSet tested = Sets.newHashSet();
            if (!boundParameters.isEmpty()) {
                TypeArgumentContext rightArgumentContext = this.getBoundTypeParameters(rightReference);
                if (rightArgumentContext == null) {
                    return TypeConformanceResult.FAILED;
                }
                if (!rightArgumentContext.isRawTypeContext()) {
                    for (JvmTypeParameter leftTypeParameter : boundParameters) {
                        TypeConformanceResult result;
                        JvmTypeReference rightBound;
                        JvmTypeReference leftBound = leftArgumentContext.getBoundArgument(leftTypeParameter);
                        if (leftBound == (rightBound = rightArgumentContext.getBoundArgument(leftTypeParameter)) || rightBound == null || !tested.add(Tuples.create((Object)leftBound, (Object)rightBound)) || (result = this.conformanceComputer.isConformant(leftBound, rightBound, new TypeConformanceComputationArgument(false, true, false))).isConformant()) continue;
                        return result;
                    }
                }
            }
        }
        return TypeConformanceResult.SUCCESS;
    }

    protected TypeArgumentContext getBoundTypeParameters(JvmParameterizedTypeReference reference) {
        return this.conformanceComputer.getTypeArgumentContextProvider().getReceiverContext(reference);
    }

    protected boolean isUnresolved(JvmType leftType) {
        return leftType == null || leftType.eIsProxy();
    }

    @Override
    public TypeConformanceResult doVisitAnyTypeReference(JvmParameterizedTypeReference left, JvmAnyTypeReference right, TypeConformanceComputationArgument.Internal<JvmParameterizedTypeReference> param) {
        JvmType leftType = left.getType();
        if (this.isUnresolved(leftType)) {
            return TypeConformanceResult.FAILED;
        }
        if (leftType instanceof JvmPrimitiveType) {
            return TypeConformanceResult.FAILED;
        }
        if (this.isPrimitiveVoid(leftType)) {
            return TypeConformanceResult.FAILED;
        }
        return TypeConformanceResult.SUCCESS;
    }

    @Override
    public TypeConformanceResult doVisitTypeReference(JvmParameterizedTypeReference left, JvmTypeReference right, TypeConformanceComputationArgument.Internal<JvmParameterizedTypeReference> param) {
        return TypeConformanceResult.FAILED;
    }
}

