/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.testing;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.testing.InMemoryJavaCompiler;
import org.eclipse.xtext.xbase.testing.JavaSource;

@Singleton
public class OnTheFlyJavaCompiler2 {
    private static final Logger logger = Logger.getLogger(OnTheFlyJavaCompiler2.class);
    private InMemoryJavaCompiler inMemoryCompiler;
    private JavaVersion javaVersion;

    @Inject
    public OnTheFlyJavaCompiler2(ClassLoader scope) {
        this(scope, JavaVersion.JAVA8);
    }

    public OnTheFlyJavaCompiler2(ClassLoader scope, JavaVersion version) {
        this.inMemoryCompiler = new InMemoryJavaCompiler(scope, version);
        this.javaVersion = version;
    }

    public void setJavaVersion(JavaVersion version) {
        if (JavaVersion.JAVA8.compareTo((Enum)version) > 0) {
            logger.error((Object)"Ignored attempt to set JavaVersion lower than 8", (Throwable)new IllegalArgumentException(version.toString()));
            version = JavaVersion.JAVA8;
        }
        this.inMemoryCompiler.setJavaVersion(version);
        this.javaVersion = version;
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    public Class<?> compileToClass(String classname, String code) {
        InMemoryJavaCompiler.Result result = this.inMemoryCompiler.compile(new JavaSource(this.toJavaFile(classname), code));
        try {
            if (Iterables.any(result.getCompilationProblems(), IProblem::isError)) {
                StringConcatenation message = new StringConcatenation();
                message.append("Java code compiled with errors:");
                message.newLine();
                message.append(Joiner.on((String)"\n").join(Iterables.filter(result.getCompilationProblems(), IProblem::isError)));
                message.newLineIfNotEmpty();
                message.newLine();
                message.append("Code was:");
                message.newLine();
                message.append(code);
                message.newLineIfNotEmpty();
                throw new IllegalArgumentException(message.toString());
            }
            return result.getClassLoader().loadClass(classname);
        }
        catch (Throwable t) {
            if (t instanceof ClassNotFoundException) {
                ClassNotFoundException e = (ClassNotFoundException)t;
                StringConcatenation message = new StringConcatenation();
                message.append("Couldn't load '");
                message.append(classname);
                message.append("' ");
                message.newLineIfNotEmpty();
                message.append("source :");
                message.newLine();
                message.append("\t");
                message.append(code, "\t");
                message.newLineIfNotEmpty();
                message.newLine();
                message.append("PROBLEMS : ");
                message.newLine();
                message.append("\t");
                message.append(Joiner.on((String)"\n").join(result.getCompilationProblems()), "\t");
                message.newLineIfNotEmpty();
                throw new IllegalStateException(message.toString(), e);
            }
            throw Exceptions.sneakyThrow((Throwable)t);
        }
    }

    private String toJavaFile(String string) {
        return string.replace('.', '/') + ".java";
    }

    public Map<String, Class<?>> compileToClasses(Map<String, String> sources) {
        InMemoryJavaCompiler.Result result = this.inMemoryCompiler.compile((JavaSource[])Conversions.unwrapArray((Object)Iterables.transform(sources.entrySet(), e -> new JavaSource(this.toJavaFile((String)e.getKey()), (String)e.getValue())), JavaSource.class));
        try {
            if (Iterables.any(result.getCompilationProblems(), IProblem::isError)) {
                StringConcatenation message = new StringConcatenation();
                message.append("Java code compiled with errors:");
                message.newLine();
                message.append(Joiner.on((String)"\n").join(Iterables.filter(result.getCompilationProblems(), IProblem::isError)));
                message.newLineIfNotEmpty();
                message.newLine();
                message.append("Code was:");
                message.newLine();
                message.append("=========");
                message.newLine();
                message.append(Joiner.on((String)"\n=========\n").join(sources.values()));
                message.newLineIfNotEmpty();
                message.append("=========");
                message.newLine();
                throw new IllegalArgumentException(message.toString());
            }
            ClassLoader classLoader = result.getClassLoader();
            return IterableExtensions.toMap((Iterable)Iterables.transform(sources.keySet(), it -> {
                try {
                    return classLoader.loadClass((String)it);
                }
                catch (ClassNotFoundException e) {
                    throw Exceptions.sneakyThrow((Throwable)e);
                }
            }), Class::getName);
        }
        catch (Throwable t) {
            if (t instanceof ClassNotFoundException) {
                ClassNotFoundException e2 = (ClassNotFoundException)t;
                StringConcatenation message = new StringConcatenation();
                message.append(e2.getMessage());
                message.append(" ");
                message.newLineIfNotEmpty();
                message.append("source :");
                message.newLine();
                message.append("\t");
                message.append(sources, "\t");
                message.newLineIfNotEmpty();
                message.newLine();
                message.append("PROBLEMS : ");
                message.newLine();
                message.append("\t");
                message.append(IterableExtensions.join(result.getCompilationProblems(), (CharSequence)"\n"), "\t");
                message.newLineIfNotEmpty();
                throw new IllegalStateException(message.toString(), e2);
            }
            throw Exceptions.sneakyThrow((Throwable)t);
        }
    }

    public <RT> Functions.Function0<RT> createFunction(String expression, Class<RT> returnType) {
        try {
            StringConcatenation sourceCode = new StringConcatenation();
            sourceCode.append("public class __Generated implements org.eclipse.xtext.xbase.lib.Functions.Function0<");
            sourceCode.append(returnType.getName());
            sourceCode.append("> {");
            sourceCode.newLineIfNotEmpty();
            sourceCode.append("\t");
            sourceCode.append("public ");
            sourceCode.append(returnType.getName(), "\t");
            sourceCode.append(" apply() {");
            sourceCode.newLineIfNotEmpty();
            sourceCode.append("\t\t");
            sourceCode.append(expression, "\t\t");
            sourceCode.newLineIfNotEmpty();
            sourceCode.append("\t");
            sourceCode.append("}");
            sourceCode.newLine();
            sourceCode.append("}");
            sourceCode.newLine();
            Class<?> clazz = this.compileToClass("__Generated", sourceCode.toString());
            Functions.Function0 result = (Functions.Function0)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return result;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }
}

