/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.releng.templates;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.util.IProjectFactoryContributor;
import org.eclipse.xtext.xtext.ui.wizard.releng.P2DirectorLaunch;
import org.eclipse.xtext.xtext.ui.wizard.releng.RelengProjectInfo;

public class BuckminsterFilesCreator {
    private static String CSPEC_FILE_NAME = "buckminster.cspec";
    private static String PROJECT = "project";
    private static String PROJECT_CQUERY_NAME = String.valueOf(PROJECT) + ".cquery";
    private static String PLATFORM_CQUERY_NAME = String.valueOf(PROJECT) + "s-platform.cquery";
    private static String PROJECT_RMAP_NAME = String.valueOf(PROJECT) + ".rmap";
    private static String PLATFORM_RMAP_NAME = String.valueOf(PROJECT) + "s-platform.rmap";
    private static String COMMANDS_FILE_NAME = "commands.txt";
    private static String INSTALL_BUCKY_LAUNCH = ".InstallHeadlessBuckminster.launch";
    private IProjectFactoryContributor.IFileCreator fileCreator;

    public BuckminsterFilesCreator(IProjectFactoryContributor.IFileCreator fileCreator) {
        this.fileCreator = fileCreator;
    }

    public IFile createBuckminsterFiles(RelengProjectInfo projectInfo) {
        IFile _xblockexpression = null;
        this.createCspec(projectInfo);
        this.createCommands(projectInfo);
        this.createProjectCquery(projectInfo);
        this.createPlatformCquery(projectInfo);
        this.createPlatformRmap(projectInfo);
        _xblockexpression = this.createProjectRmap(projectInfo);
        return _xblockexpression;
    }

    private IFile writeToFile(CharSequence chrSeq, String fileName) {
        return this.fileCreator.writeToFile(chrSeq, fileName);
    }

    private IFile createCommands(RelengProjectInfo projectInfo) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"setpref targetPlatformPath=\"${target.platform}\"");
        _builder.newLine();
        _builder.append((Object)"resolve \"${projects.location}/");
        String _projectName = projectInfo.getProjectName();
        _builder.append((Object)_projectName, "");
        _builder.append((Object)"/");
        _builder.append((Object)PLATFORM_CQUERY_NAME, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"resolve \"${projects.location}/");
        String _projectName_1 = projectInfo.getProjectName();
        _builder.append((Object)_projectName_1, "");
        _builder.append((Object)"/");
        _builder.append((Object)PROJECT_CQUERY_NAME, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        List<String> _preCompileLaunchers = projectInfo.getPreCompileLaunchers();
        for (String preCompileLauncher : _preCompileLaunchers) {
            _builder.append((Object)"launch -l \"");
            _builder.append((Object)preCompileLauncher, "");
            _builder.append((Object)"\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"build");
        _builder.newLine();
        List<IFile> _testLaunchers = projectInfo.getTestLaunchers();
        for (IFile testLauncher : _testLaunchers) {
            _builder.append((Object)"junit -l \"");
            IProject _project = testLauncher.getProject();
            String _name = _project.getName();
            Path _path = new Path(_name);
            IPath _projectRelativePath = testLauncher.getProjectRelativePath();
            IPath _append = _path.append(_projectRelativePath);
            _builder.append((Object)_append, "");
            _builder.append((Object)"\"  --flatXML --output \"${buckminster.output.root}/test.results/");
            String _name_1 = testLauncher.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)".xml\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"perform \"");
        String _siteFeatureProjectName = projectInfo.getSiteFeatureProjectName();
        _builder.append((Object)_siteFeatureProjectName, "");
        _builder.append((Object)"#site.p2\"");
        _builder.newLineIfNotEmpty();
        return this.writeToFile((CharSequence)_builder, COMMANDS_FILE_NAME);
    }

    private IFile createCspec(RelengProjectInfo projectInfo) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append((Object)"<cs:cspec xmlns:cs=\"http://www.eclipse.org/buckminster/CSpec-1.0\" name=\"");
        String _projectName = projectInfo.getProjectName();
        _builder.append((Object)_projectName, "");
        _builder.append((Object)"\" componentType=\"buckminster\" version=\"1.0.0\">");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"<cs:dependencies>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<cs:dependency name=\"org.eclipse.platform\" componentType=\"eclipse.feature\"/>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<cs:dependency name=\"org.eclipse.xtext.sdk\" componentType=\"eclipse.feature\"/>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"</cs:dependencies>");
        _builder.newLine();
        _builder.append((Object)"</cs:cspec>");
        _builder.newLine();
        return this.writeToFile((CharSequence)_builder, CSPEC_FILE_NAME);
    }

    private IFile createProjectCquery(RelengProjectInfo projectInfo) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append((Object)"<cq:componentQuery xmlns:cq=\"http://www.eclipse.org/buckminster/CQuery-1.0\" resourceMap=\"");
        _builder.append((Object)PROJECT_RMAP_NAME, "");
        _builder.append((Object)"\">");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"<cq:rootRequest name=\"");
        String _siteFeatureProjectName = projectInfo.getSiteFeatureProjectName();
        _builder.append((Object)_siteFeatureProjectName, "    ");
        _builder.append((Object)"\" componentType=\"eclipse.feature\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</cq:componentQuery>");
        _builder.newLine();
        return this.writeToFile((CharSequence)_builder, PROJECT_CQUERY_NAME);
    }

    private IFile createPlatformCquery(RelengProjectInfo projectInfo) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append((Object)"<cq:componentQuery xmlns:cq=\"http://www.eclipse.org/buckminster/CQuery-1.0\" resourceMap=\"");
        _builder.append((Object)PLATFORM_RMAP_NAME, "");
        _builder.append((Object)"\">");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"<cq:rootRequest name=\"");
        String _projectName = projectInfo.getProjectName();
        _builder.append((Object)_projectName, "    ");
        _builder.append((Object)"\" componentType=\"buckminster\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"<cq:property key=\"target.arch\" value=\"*\"/>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<cq:property key=\"target.os\" value=\"*\"/>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<cq:property key=\"target.ws\" value=\"*\"/>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<cq:advisorNode namePattern=\"^.*\\.source$\" skipComponent=\"true\"/>");
        _builder.newLine();
        _builder.append((Object)"</cq:componentQuery>");
        _builder.newLine();
        _builder.newLine();
        return this.writeToFile((CharSequence)_builder, PLATFORM_CQUERY_NAME);
    }

    private IFile createPlatformRmap(RelengProjectInfo projectInfo) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append((Object)"<rm:rmap xmlns:bc=\"http://www.eclipse.org/buckminster/Common-1.0\" xmlns:rm=\"http://www.eclipse.org/buckminster/RMap-1.0\">");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<rm:property key=\"eclipse.download\" value=\"http://download.eclipse.org\"/>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<rm:property key=\"xtext.p2.repository\" value=\"${eclipse.download}/modeling/tmf/xtext/updates/composite/releases/\"/>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<rm:property key=\"eclipse.target.platform\" value=\"${eclipse.download}/releases/mars\"/>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<rm:redirect pattern=\"");
        String _projectName = projectInfo.getProjectName();
        _builder.append((Object)_projectName, "  ");
        _builder.append((Object)"\" href=\"");
        _builder.append((Object)PROJECT_RMAP_NAME, "  ");
        _builder.append((Object)"\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"  ");
        _builder.append((Object)"<rm:locator pattern=\"^org\\.eclipse\\.(?:xtext|xpand|xtend|xtend2|emf\\.mwe|emf\\.mwe2)(?:\\..+)?$\" searchPathRef=\"xtext\"/>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<rm:locator pattern=\"^com\\.google.*\" searchPathRef=\"xtext\"/>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<rm:locator pattern=\"^org\\.antlr.*\" searchPathRef=\"xtext\"/>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<rm:locator pattern=\"javax.inject\" searchPathRef=\"xtext\"/>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<rm:locator searchPathRef=\"eclipse\"/>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<rm:searchPath name=\"xtext\">");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<rm:provider componentTypes=\"osgi.bundle,eclipse.feature\" readerType=\"p2\" source=\"false\">");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"<rm:property key=\"buckminster.source\" value=\"false\"/>");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"<rm:uri format=\"{0}\">");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<bc:propertyRef key=\"xtext.p2.repository\"/>");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"</rm:uri>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"</rm:provider>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"</rm:searchPath>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<rm:searchPath name=\"eclipse\">");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<rm:provider componentTypes=\"eclipse.feature,osgi.bundle\" readerType=\"p2\" source=\"false\" mutable=\"false\">");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"<rm:property key=\"buckminster.source\" value=\"false\"/>");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"<rm:property key=\"buckminster.mutable\" value=\"false\"/>");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"<rm:uri format=\"{0}\">");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<bc:propertyRef key=\"eclipse.target.platform\"/>");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"</rm:uri>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"</rm:provider>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"</rm:searchPath>");
        _builder.newLine();
        _builder.append((Object)"</rm:rmap>");
        _builder.newLine();
        return this.writeToFile((CharSequence)_builder, PLATFORM_RMAP_NAME);
    }

    private IFile createProjectRmap(RelengProjectInfo projectInfo) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append((Object)"<rm:rmap xmlns:bc=\"http://www.eclipse.org/buckminster/Common-1.0\" xmlns:rm=\"http://www.eclipse.org/buckminster/RMap-1.0\">");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<rm:property key=\"projects.location\" value=\"${workspace.root}\"/>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<rm:locator pattern=\"^");
        String _projectNameSpace = projectInfo.getProjectNameSpace();
        String _replaceAll = _projectNameSpace.replaceAll("\\.", "\\.");
        _builder.append((Object)_replaceAll, "  ");
        _builder.append((Object)"(?:\\..+)?$\" searchPathRef=\"project\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"  ");
        _builder.append((Object)"<rm:searchPath name=\"project\">");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<rm:provider componentTypes=\"eclipse.feature,osgi.bundle,buckminster\" readerType=\"local\" mutable=\"false\">");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"<rm:property key=\"buckminster.mutable\" value=\"false\"/>");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"<rm:uri format=\"{0}/{1}\">");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<bc:propertyRef key=\"projects.location\"/>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<bc:propertyRef key=\"buckminster.component\"/>");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"</rm:uri>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"</rm:provider>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"</rm:searchPath>");
        _builder.newLine();
        _builder.append((Object)"</rm:rmap>");
        _builder.newLine();
        return this.writeToFile((CharSequence)_builder, PROJECT_RMAP_NAME);
    }

    public IFile createInstallBuckminsterLaunch(RelengProjectInfo projectInfo) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        _builder.newLine();
        _builder.append((Object)"<launchConfiguration type=\"org.eclipse.pde.ui.RuntimeWorkbench\">");
        _builder.newLine();
        _builder.append((Object)"<booleanAttribute key=\"append.args\" value=\"true\"/>");
        _builder.newLine();
        _builder.append((Object)"<booleanAttribute key=\"askclear\" value=\"true\"/>");
        _builder.newLine();
        _builder.append((Object)"<booleanAttribute key=\"automaticAdd\" value=\"true\"/>");
        _builder.newLine();
        _builder.append((Object)"<booleanAttribute key=\"automaticValidate\" value=\"false\"/>");
        _builder.newLine();
        _builder.append((Object)"<stringAttribute key=\"bootstrap\" value=\"\"/>");
        _builder.newLine();
        _builder.append((Object)"<stringAttribute key=\"checked\" value=\"[NONE]\"/>");
        _builder.newLine();
        _builder.append((Object)"<booleanAttribute key=\"clearConfig\" value=\"false\"/>");
        _builder.newLine();
        _builder.append((Object)"<booleanAttribute key=\"clearws\" value=\"false\"/>");
        _builder.newLine();
        _builder.append((Object)"<booleanAttribute key=\"clearwslog\" value=\"false\"/>");
        _builder.newLine();
        _builder.append((Object)"<stringAttribute key=\"configLocation\" value=\"${workspace_loc}/.metadata/.plugins/org.eclipse.pde.core/Install headless buckminster\"/>");
        _builder.newLine();
        _builder.append((Object)"<booleanAttribute key=\"default\" value=\"true\"/>");
        _builder.newLine();
        _builder.append((Object)"<booleanAttribute key=\"includeOptional\" value=\"true\"/>");
        _builder.newLine();
        _builder.append((Object)"<stringAttribute key=\"location\" value=\"");
        _builder.append((Object)"${workspace_loc}/../runtime-InstallHeadlessBuckminster", "");
        _builder.append((Object)"\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<stringAttribute key=\"org.eclipse.jdt.launching.PROGRAM_ARGUMENTS\" value=\"-os ${target.os} -ws ${target.ws} -arch ${target.arch} -nl ${target.nl} -consoleLog ");
        String _args = P2DirectorLaunch.args();
        _builder.append((Object)_args, "");
        _builder.append((Object)"\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<stringAttribute key=\"org.eclipse.jdt.launching.SOURCE_PATH_PROVIDER\" value=\"org.eclipse.pde.ui.workbenchClasspathProvider\"/>");
        _builder.newLine();
        _builder.append((Object)"<stringAttribute key=\"org.eclipse.jdt.launching.VM_ARGUMENTS\" value=\"-Xms40m -Xmx512m\"/>");
        _builder.newLine();
        _builder.append((Object)"<stringAttribute key=\"pde.version\" value=\"3.3\"/>");
        _builder.newLine();
        _builder.append((Object)"<stringAttribute key=\"product\" value=\"");
        _builder.append((Object)"org.eclipse.equinox.p2.director.product", "");
        _builder.append((Object)"\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<booleanAttribute key=\"show_selected_only\" value=\"false\"/>");
        _builder.newLine();
        _builder.append((Object)"<stringAttribute key=\"templateConfig\" value=\"${target_home}/configuration/config.ini\"/>");
        _builder.newLine();
        _builder.append((Object)"<booleanAttribute key=\"tracing\" value=\"false\"/>");
        _builder.newLine();
        _builder.append((Object)"<booleanAttribute key=\"useCustomFeatures\" value=\"false\"/>");
        _builder.newLine();
        _builder.append((Object)"<booleanAttribute key=\"useDefaultConfig\" value=\"true\"/>");
        _builder.newLine();
        _builder.append((Object)"<booleanAttribute key=\"useDefaultConfigArea\" value=\"true\"/>");
        _builder.newLine();
        _builder.append((Object)"<booleanAttribute key=\"useProduct\" value=\"true\"/>");
        _builder.newLine();
        _builder.append((Object)"</launchConfiguration>");
        _builder.newLine();
        return this.writeToFile((CharSequence)_builder, INSTALL_BUCKY_LAUNCH);
    }
}

