/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.xtext.formatting2.FormattingNotApplicableException;
import org.eclipse.xtext.formatting2.ISubFormatter;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.ITextSegment;
import org.eclipse.xtext.formatting2.internal.AbstractTextReplacer;
import org.eclipse.xtext.formatting2.internal.FormattableDocument;
import org.eclipse.xtext.formatting2.internal.ICompositeTextReplacer;
import org.eclipse.xtext.formatting2.internal.SubDocument;
import org.eclipse.xtext.formatting2.internal.TextSegment;

public class ConditionalReplacer
extends AbstractTextReplacer
implements ICompositeTextReplacer {
    private final List<ISubFormatter> subFormatters;
    private final List<ITextReplacer> replacers = Lists.newArrayList();

    public ConditionalReplacer(FormattableDocument document, int offset, int length, List<ISubFormatter> subFormatters) {
        super(document, new TextSegment(document.getTextRegionAccess(), offset, length));
        Preconditions.checkArgument((subFormatters.size() > 0 ? 1 : 0) != 0);
        this.subFormatters = subFormatters;
    }

    @Override
    public ITextReplacerContext createReplacements(ITextReplacerContext context) {
        context.setNextReplacerIsChild();
        for (ISubFormatter formatter : this.subFormatters) {
            try {
                ITextSegment region = this.getRegion();
                SubDocument subDocument = new SubDocument(region, this.getDocument());
                for (ITextReplacer replacer : this.replacers) {
                    subDocument.addReplacer(replacer);
                }
                formatter.format(subDocument);
                ITextReplacerContext first = context.withReplacer(subDocument);
                ITextReplacerContext last = subDocument.createReplacements(first);
                return last;
            }
            catch (FormattingNotApplicableException formattingNotApplicableException) {
                // empty catch block
            }
        }
        throw new FormattingNotApplicableException();
    }

    @Override
    public void addReplacer(ITextReplacer replacer) {
        this.replacers.add(replacer);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

