/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hover;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.xtext.ui.editor.hover.AbstractHover;

public abstract class AbstractProblemHover
extends AbstractHover {
    @Inject
    private DefaultMarkerAnnotationAccess markerAnnotationAccess;

    @Override
    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        try {
            int lineNumber = textViewer.getDocument().getLineOfOffset(offset);
            return this.getHoverRegionInternal(lineNumber, offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected abstract IRegion getHoverRegionInternal(int var1, int var2);

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        try {
            int lineNumber = this.getLineNumber(textViewer, hoverRegion);
            return this.getHoverInfoInternal(textViewer, lineNumber, hoverRegion.getOffset());
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    protected abstract Object getHoverInfoInternal(ITextViewer var1, int var2, int var3);

    protected IAnnotationModel getAnnotationModel() {
        return this.sourceViewer.getAnnotationModel();
    }

    public List<Annotation> getAnnotations(int lineNumber, int offset) {
        if (this.getAnnotationModel() == null) {
            return Collections.emptyList();
        }
        Iterator iterator = this.getAnnotationModel().getAnnotationIterator();
        ArrayList result = Lists.newArrayList();
        while (iterator.hasNext()) {
            Position position;
            Annotation annotation = (Annotation)iterator.next();
            if (!this.isHandled(annotation) || (position = this.getAnnotationModel().getPosition(annotation)) == null) continue;
            int start = position.getOffset();
            int end = start + position.getLength();
            if (offset > 0 && (start > offset || offset > end)) continue;
            try {
                if (lineNumber != this.getDocument().getLineOfOffset(start)) {
                }
            }
            catch (Exception x) {}
            continue;
            if (this.isLineDiffInfo(annotation)) continue;
            result.add(annotation);
        }
        return result;
    }

    protected boolean isLineDiffInfo(Annotation annotation) {
        return annotation instanceof ILineDiffInfo;
    }

    protected boolean isHandled(Annotation annotation) {
        return annotation != null && !annotation.isMarkedDeleted() && (this.markerAnnotationAccess.isSubtype((Object)annotation.getType(), (Object)"org.eclipse.ui.workbench.texteditor.error") || this.markerAnnotationAccess.isSubtype((Object)annotation.getType(), (Object)"org.eclipse.ui.workbench.texteditor.warning") || this.markerAnnotationAccess.isSubtype((Object)annotation.getType(), (Object)"org.eclipse.ui.workbench.texteditor.info") || this.markerAnnotationAccess.isSubtype((Object)annotation.getType(), (Object)"org.eclipse.ui.workbench.texteditor.bookmark") || this.markerAnnotationAccess.isSubtype((Object)annotation.getType(), (Object)"org.eclipse.ui.workbench.texteditor.spelling"));
    }
}

