/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.refactoring;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.editor.findrefs.EditorResourceAccess;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Strings;

public class RuleOverrideUtil {
    @Inject
    private IReferenceFinder referenceFinder;
    @Inject
    private IResourceDescriptions resourceDescriptions;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private EditorResourceAccess localContextProvider;

    public List<IEObjectDescription> getOverridingRules(final AbstractRule originalRule) {
        Grammar grammar = GrammarUtil.getGrammar((EObject)originalRule);
        final ArrayList overridingRules = Lists.newArrayList();
        IAcceptor<IReferenceDescription> acceptor = new IAcceptor<IReferenceDescription>(){

            public void accept(IReferenceDescription referenceToGrammar) {
                if (referenceToGrammar.getEReference() == XtextPackage.Literals.GRAMMAR__USED_GRAMMARS) {
                    IResourceDescription resourceDescription = RuleOverrideUtil.this.resourceDescriptions.getResourceDescription(referenceToGrammar.getSourceEObjectUri().trimFragment());
                    for (IEObjectDescription rule : resourceDescription.getExportedObjectsByType(originalRule.eClass())) {
                        if (!Strings.equal((String)originalRule.getName(), (String)rule.getQualifiedName().getLastSegment())) continue;
                        overridingRules.add(rule);
                        break;
                    }
                }
            }
        };
        this.referenceFinder.findAllReferences(Collections.singleton(EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)grammar)), (IReferenceFinder.ILocalResourceAccess)this.localContextProvider, (IAcceptor)acceptor, (IProgressMonitor)new NullProgressMonitor());
        return overridingRules;
    }

    public List<IEObjectDescription> getOverriddenRules(AbstractRule originalRule) {
        Grammar grammar = GrammarUtil.getGrammar((EObject)originalRule);
        final ArrayList overriddenRules = Lists.newArrayList();
        IAcceptor<AbstractRule> acceptor = new IAcceptor<AbstractRule>(){

            public void accept(AbstractRule overriddenRule) {
                if (overriddenRule != null) {
                    IEObjectDescription description = EObjectDescription.create((QualifiedName)RuleOverrideUtil.this.qualifiedNameProvider.getFullyQualifiedName((EObject)overriddenRule), (EObject)overriddenRule);
                    overriddenRules.add(description);
                }
            }
        };
        this.findOverriddenRule(originalRule, (List<Grammar>)grammar.getUsedGrammars(), acceptor);
        return overriddenRules;
    }

    protected void findOverriddenRule(AbstractRule originalRule, List<Grammar> grammars, IAcceptor<AbstractRule> acceptor) {
        for (Grammar grammar : grammars) {
            for (AbstractRule rule : grammar.getRules()) {
                if (rule.eClass() != originalRule.eClass() || !Strings.equal((String)rule.getName(), (String)originalRule.getName())) continue;
                acceptor.accept((Object)rule);
            }
            this.findOverriddenRule(originalRule, (List<Grammar>)grammar.getUsedGrammars(), acceptor);
        }
    }
}

