/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.generator.trace;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.ui.generator.trace.FileOpener;
import org.eclipse.xtext.ui.generator.trace.OppositeFileOpenerContributor;
import org.eclipse.xtext.ui.generator.trace.StorageBasedTextEditorOpener;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.ITextRegion;

public class TraceBasedOpenerContributor
extends OppositeFileOpenerContributor {
    @Inject
    private ITraceForStorageProvider traceForStorageProvider;

    protected StorageBasedTextEditorOpener createStorageBasedTextEditorOpener(IStorage storage, ITextRegion textRegion) {
        return new StorageBasedTextEditorOpener(storage, textRegion);
    }

    @Override
    public boolean collectGeneratedFileOpeners(IEditorPart editor, IAcceptor<FileOpener> acceptor) {
        ITrace trace;
        IStorage editorStorage = this.getStorage(editor);
        if (editorStorage != null && (trace = this.traceForStorageProvider.getTraceToTarget(editorStorage)) != null && ((ITrace.Internal)trace).getRootTraceRegion() != null) {
            this.collectOpeners(trace, this.getSelectedRegion(editor), acceptor);
            return true;
        }
        return false;
    }

    private void collectOpeners(ITrace trace, ITextRegion region, IAcceptor<FileOpener> acceptor) {
        IStorage storage;
        Iterable locations = null;
        if (region != null) {
            locations = trace.getAllAssociatedLocations(region);
        }
        if (locations == null || Iterables.isEmpty((Iterable)locations)) {
            locations = trace.getAllAssociatedLocations();
        }
        HashMap result = Maps.newHashMap();
        for (ILocationInResource iLocationInResource : locations) {
            ITextRegion old;
            storage = iLocationInResource.getStorage();
            if (storage == null || (old = (ITextRegion)result.put(storage, iLocationInResource.getTextRegion())) == null) continue;
            ITextRegion merged = old.merge((ITextRegion)iLocationInResource.getTextRegion());
            result.put(storage, merged);
        }
        for (Map.Entry entry : result.entrySet()) {
            storage = (IStorage)entry.getKey();
            ITextRegion textRegion = (ITextRegion)entry.getValue();
            acceptor.accept((Object)this.createStorageBasedTextEditorOpener(storage, textRegion));
        }
    }

    @Override
    public boolean collectSourceFileOpeners(IEditorPart editor, IAcceptor<FileOpener> acceptor) {
        ITrace trace;
        IStorage editorStorage = this.getStorage(editor);
        if (editorStorage != null && ((ITrace.Internal)(trace = this.traceForStorageProvider.getTraceToSource(editorStorage))).getRootTraceRegion() != null) {
            this.collectOpeners(trace, this.getSelectedRegion(editor), acceptor);
            return true;
        }
        return false;
    }
}

