/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.debug;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.xtext.common.types.ui.trace.ITraceForTypeRootProvider;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.LineMappingProvider;
import org.eclipse.xtext.ui.generator.trace.AbstractEclipseTrace;
import org.eclipse.xtext.ui.generator.trace.IEclipseTrace;
import org.eclipse.xtext.ui.generator.trace.ILocationInEclipseResource;
import org.eclipse.xtext.ui.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.TextRegion;

public class JavaBreakPointProvider {
    @Inject
    private ITraceForStorageProvider traceForStorageProvider;
    @Inject
    private ITraceForTypeRootProvider traceForTypeRootProvider;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private LineMappingProvider lineMappingProvider;

    public IJavaLineBreakpoint getBreakpointWithJavaLocation(final IJavaStratumLineBreakpoint breakpoint) {
        final IMarker marker = breakpoint.getMarker();
        final Object markerProxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IMarker.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("getAttribute")) {
                    if (args[0].equals("lineNumber")) {
                        return JavaBreakPointProvider.this.getJavaLineNumber(breakpoint);
                    }
                    String elementHandleID = String.valueOf(JDIDebugUIPlugin.getUniqueIdentifier()) + ".JAVA_ELEMENT_HANDLE_ID";
                    if (args[0].equals(elementHandleID)) {
                        return JavaBreakPointProvider.this.getHandleId(breakpoint);
                    }
                }
                return method.invoke((Object)marker, args);
            }
        });
        return (IJavaLineBreakpoint)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IJavaLineBreakpoint.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("getMarker")) {
                    return markerProxy;
                }
                return method.invoke((Object)breakpoint, args);
            }
        });
    }

    private String getHandleId(IJavaStratumLineBreakpoint breakpoint) throws CoreException {
        IClassFile classFile = this.getClassFile(breakpoint);
        if (classFile != null) {
            return classFile.getType().getHandleIdentifier();
        }
        ILocationInEclipseResource javaLocation = this.getJavaLocation(breakpoint);
        if (javaLocation == null) {
            return null;
        }
        IStorage javaResource = (IStorage)javaLocation.getPlatformResource();
        if (!(javaResource instanceof IFile)) {
            return null;
        }
        ICompilationUnit compilationUnit = (ICompilationUnit)JavaCore.create((IFile)((IFile)javaResource));
        IJavaElement element = compilationUnit.getElementAt(javaLocation.getTextRegion().getOffset());
        return element == null ? null : element.getHandleIdentifier();
    }

    private int getJavaLineNumber(IJavaStratumLineBreakpoint breakpoint) throws CoreException {
        ILocationInEclipseResource javaLocation = this.getJavaLocation(breakpoint);
        if (javaLocation == null) {
            return -1;
        }
        IStorage storage = (IStorage)javaLocation.getPlatformResource();
        if (storage == null) {
            ITextRegionWithLineInformation textRegion = javaLocation.getTextRegion();
            if (textRegion == null) {
                return -1;
            }
            return textRegion.getEndLineNumber();
        }
        AbstractEclipseTrace sourceTrace = (AbstractEclipseTrace)this.traceForStorageProvider.getTraceToSource((Object)storage);
        if (sourceTrace == null) {
            return -1;
        }
        AbstractTraceRegion rootTraceRegion = sourceTrace.getRootTraceRegion();
        if (rootTraceRegion == null) {
            return -1;
        }
        List lineMappings = this.lineMappingProvider.getLineMapping(rootTraceRegion);
        for (LineMappingProvider.LineMapping lineMapping : lineMappings) {
            if (lineMapping.sourceStartLine != breakpoint.getLineNumber()) continue;
            return lineMapping.targetEndLine + 1;
        }
        return -1;
    }

    private ILocationInEclipseResource getJavaLocation(IJavaStratumLineBreakpoint breakpoint) throws CoreException {
        IEclipseTrace javaTrace = this.getJavaTrace(breakpoint);
        if (javaTrace == null) {
            return null;
        }
        TextRegion textRegion = new TextRegion(breakpoint.getCharStart(), 0);
        ILocationInEclipseResource javaLocation = (ILocationInEclipseResource)javaTrace.getBestAssociatedLocation((ITextRegion)textRegion);
        if (javaLocation == null) {
            return null;
        }
        return javaLocation;
    }

    private IEclipseTrace getJavaTrace(IJavaStratumLineBreakpoint breakpoint) throws CoreException {
        IEclipseTrace result;
        IClassFile classFile = this.getClassFile(breakpoint);
        if (classFile == null) {
            URI uri = URI.createURI((String)((String)breakpoint.getMarker().getAttribute("org.eclipse.xtext.xbase.source.uri")));
            Pair storage = (Pair)Iterables.getFirst((Iterable)this.storage2UriMapper.getStorages(uri), null);
            if (storage == null) {
                return null;
            }
            result = (IEclipseTrace)this.traceForStorageProvider.getTraceToTarget((Object)((IStorage)storage.getFirst()));
        } else {
            result = this.traceForTypeRootProvider.getTraceToSource((ITypeRoot)classFile);
        }
        return result;
    }

    private IClassFile getClassFile(IJavaStratumLineBreakpoint breakpoint) throws CoreException {
        String handle = (String)breakpoint.getMarker().getAttribute("org.eclipse.xtext.xbase.class.handle");
        return (IClassFile)JavaCore.create((String)handle);
    }
}

