/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.utils.StandaloneSetup;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.XtextStandaloneSetup;
import org.eclipse.xtext.util.MergeableManifest;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.CompositeGeneratorException;
import org.eclipse.xtext.xtext.generator.DefaultGeneratorModule;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.LanguageModule;
import org.eclipse.xtext.xtext.generator.MweIssues;
import org.eclipse.xtext.xtext.generator.XtextDirectoryCleaner;
import org.eclipse.xtext.xtext.generator.XtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.XtextGeneratorStandaloneSetup;
import org.eclipse.xtext.xtext.generator.XtextGeneratorTemplates;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.JavaFileAccess;
import org.eclipse.xtext.xtext.generator.model.ManifestAccess;
import org.eclipse.xtext.xtext.generator.model.PluginXmlAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.model.project.BundleProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IBundleProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IRuntimeProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.ISubProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IWebProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;

@Log
public class XtextGenerator
extends AbstractWorkflowComponent2 {
    @Accessors
    private DefaultGeneratorModule configuration = new DefaultGeneratorModule();
    @Accessors
    private final List<XtextGeneratorLanguage> languageConfigs = CollectionLiterals.newArrayList((Object[])new XtextGeneratorLanguage[0]);
    @Accessors
    private XtextDirectoryCleaner cleaner = new XtextDirectoryCleaner();
    @Accessors
    private XtextGeneratorStandaloneSetup standaloneSetup = new XtextGeneratorStandaloneSetup();
    private Injector injector;
    @Inject
    private IXtextProjectConfig projectConfig;
    @Inject
    private XtextGeneratorTemplates templates;
    @Inject
    private XtextGeneratorNaming naming;
    private static final Logger LOG = Logger.getLogger(XtextGenerator.class);

    public XtextGenerator() {
        XtextStandaloneSetup _xtextStandaloneSetup = new XtextStandaloneSetup();
        _xtextStandaloneSetup.createInjectorAndDoEMFRegistration();
    }

    public void addLanguage(XtextGeneratorLanguage language) {
        this.languageConfigs.add(language);
    }

    protected void checkConfigurationInternal(Issues issues) {
        this.initialize();
        MweIssues generatorIssues = new MweIssues(this, issues);
        this.configuration.checkConfiguration(generatorIssues);
        HashMap<String, Grammar> uris = new HashMap<String, Grammar>();
        for (XtextGeneratorLanguage language : this.languageConfigs) {
            language.checkConfiguration(generatorIssues);
            Grammar _grammar = language.getGrammar();
            EList _metamodelDeclarations = _grammar.getMetamodelDeclarations();
            Iterable _filter = Iterables.filter((Iterable)_metamodelDeclarations, GeneratedMetamodel.class);
            for (GeneratedMetamodel generatedMetamodel : _filter) {
                EPackage _ePackage = generatedMetamodel.getEPackage();
                String nsURI = _ePackage.getNsURI();
                boolean _containsKey = uris.containsKey(nsURI);
                if (_containsKey) {
                    Grammar _get = (Grammar)uris.get(nsURI);
                    String _name = _get.getName();
                    String _plus = "Duplicate generated grammar with nsURI '" + nsURI + "' in " + _name;
                    String _plus_1 = String.valueOf(_plus) + " and ";
                    Grammar _grammar_1 = language.getGrammar();
                    String _name_1 = _grammar_1.getName();
                    String _plus_2 = String.valueOf(_plus_1) + _name_1;
                    generatorIssues.addError(_plus_2);
                    continue;
                }
                Grammar _grammar_2 = language.getGrammar();
                uris.put(nsURI, _grammar_2);
            }
        }
    }

    public void initialize() {
        if (this.injector == null) {
            Injector _createInjector;
            LOG.info((Object)"Initializing Xtext generator");
            StandaloneSetup _standaloneSetup = new StandaloneSetup();
            _standaloneSetup.addRegisterGeneratedEPackage("org.eclipse.xtext.common.types.TypesPackage");
            this.injector = _createInjector = this.createInjector();
            this.injector.injectMembers((Object)this);
            CodeConfig _instance = (CodeConfig)this.injector.getInstance(CodeConfig.class);
            Procedures.Procedure1<CodeConfig> _function = new Procedures.Procedure1<CodeConfig>(){

                public void apply(CodeConfig it) {
                    it.initialize(XtextGenerator.this.injector);
                }
            };
            ObjectExtensions.operator_doubleArrow((Object)_instance, (Procedures.Procedure1)_function);
            this.projectConfig.initialize(this.injector);
            this.cleaner.initialize(this.injector);
            this.standaloneSetup.initialize(this.injector);
            for (XtextGeneratorLanguage language : this.languageConfigs) {
                Injector languageInjector = this.createLanguageInjector(this.injector, language);
                language.initialize(languageInjector);
            }
        }
    }

    protected Injector createInjector() {
        return Guice.createInjector((Module[])new Module[]{this.configuration});
    }

    protected Injector createLanguageInjector(Injector parent, XtextGeneratorLanguage language) {
        LanguageModule _languageModule = new LanguageModule(language);
        return parent.createChildInjector(new Module[]{_languageModule});
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        this.initialize();
        try {
            this.cleaner.clean();
            for (XtextGeneratorLanguage language : this.languageConfigs) {
                try {
                    Grammar _grammar = language.getGrammar();
                    String _name = _grammar.getName();
                    String _plus = "Generating " + _name;
                    LOG.info((Object)_plus);
                    language.generate();
                    this.generateSetups(language);
                    this.generateModules(language);
                    this.generateExecutableExtensionFactory(language);
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception e = (Exception)_t;
                        this.handleException(e, issues);
                        continue;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            LOG.info((Object)"Generating common infrastructure");
            this.generatePluginXmls();
            this.generateManifests();
            this.generateActivator();
        }
        catch (Throwable _t_1) {
            if (_t_1 instanceof Exception) {
                Exception e_1 = (Exception)_t_1;
                this.handleException(e_1, issues);
            }
            throw Exceptions.sneakyThrow((Throwable)_t_1);
        }
    }

    private void handleException(Exception ex, final Issues issues) {
        if (ex instanceof CompositeGeneratorException) {
            List<Exception> _exceptions = ((CompositeGeneratorException)ex).getExceptions();
            Procedures.Procedure1<Exception> _function = new Procedures.Procedure1<Exception>(){

                public void apply(Exception it) {
                    XtextGenerator.this.handleException(it, issues);
                }
            };
            IterableExtensions.forEach(_exceptions, (Procedures.Procedure1)_function);
        } else {
            issues.addError((WorkflowComponent)this, "GeneratorException: ", null, (Throwable)ex, null);
        }
    }

    protected void generateSetups(IXtextGeneratorLanguage language) {
        JavaFileAccess _createRuntimeGenSetup = this.templates.createRuntimeGenSetup(language);
        IRuntimeProjectConfig _runtime = this.projectConfig.getRuntime();
        IXtextGeneratorFileSystemAccess _srcGen = _runtime.getSrcGen();
        _createRuntimeGenSetup.writeTo(_srcGen);
        JavaFileAccess _createRuntimeSetup = this.templates.createRuntimeSetup(language);
        IRuntimeProjectConfig _runtime_1 = this.projectConfig.getRuntime();
        IXtextGeneratorFileSystemAccess _src = _runtime_1.getSrc();
        _createRuntimeSetup.writeTo(_src);
        JavaFileAccess _createWebSetup = this.templates.createWebSetup(language);
        IWebProjectConfig _web = this.projectConfig.getWeb();
        IXtextGeneratorFileSystemAccess _src_1 = _web.getSrc();
        _createWebSetup.writeTo(_src_1);
    }

    protected void generateModules(IXtextGeneratorLanguage language) {
        JavaFileAccess _createRuntimeGenModule = this.templates.createRuntimeGenModule(language);
        IRuntimeProjectConfig _runtime = this.projectConfig.getRuntime();
        IXtextGeneratorFileSystemAccess _srcGen = _runtime.getSrcGen();
        _createRuntimeGenModule.writeTo(_srcGen);
        JavaFileAccess _createRuntimeModule = this.templates.createRuntimeModule(language);
        IRuntimeProjectConfig _runtime_1 = this.projectConfig.getRuntime();
        IXtextGeneratorFileSystemAccess _src = _runtime_1.getSrc();
        _createRuntimeModule.writeTo(_src);
        JavaFileAccess _createEclipsePluginGenModule = this.templates.createEclipsePluginGenModule(language);
        IBundleProjectConfig _eclipsePlugin = this.projectConfig.getEclipsePlugin();
        IXtextGeneratorFileSystemAccess _srcGen_1 = _eclipsePlugin.getSrcGen();
        _createEclipsePluginGenModule.writeTo(_srcGen_1);
        JavaFileAccess _createEclipsePluginModule = this.templates.createEclipsePluginModule(language);
        IBundleProjectConfig _eclipsePlugin_1 = this.projectConfig.getEclipsePlugin();
        IXtextGeneratorFileSystemAccess _src_1 = _eclipsePlugin_1.getSrc();
        _createEclipsePluginModule.writeTo(_src_1);
        JavaFileAccess _createIdeaGenModule = this.templates.createIdeaGenModule(language);
        ISubProjectConfig _ideaPlugin = this.projectConfig.getIdeaPlugin();
        IXtextGeneratorFileSystemAccess _srcGen_2 = _ideaPlugin.getSrcGen();
        _createIdeaGenModule.writeTo(_srcGen_2);
        JavaFileAccess _createIdeaModule = this.templates.createIdeaModule(language);
        ISubProjectConfig _ideaPlugin_1 = this.projectConfig.getIdeaPlugin();
        IXtextGeneratorFileSystemAccess _src_2 = _ideaPlugin_1.getSrc();
        _createIdeaModule.writeTo(_src_2);
        JavaFileAccess _createWebGenModule = this.templates.createWebGenModule(language);
        IWebProjectConfig _web = this.projectConfig.getWeb();
        IXtextGeneratorFileSystemAccess _srcGen_3 = _web.getSrcGen();
        _createWebGenModule.writeTo(_srcGen_3);
        JavaFileAccess _createWebModule = this.templates.createWebModule(language);
        IWebProjectConfig _web_1 = this.projectConfig.getWeb();
        IXtextGeneratorFileSystemAccess _src_3 = _web_1.getSrc();
        _createWebModule.writeTo(_src_3);
    }

    protected void generateExecutableExtensionFactory(IXtextGeneratorLanguage language) {
        boolean _tripleNotEquals;
        IBundleProjectConfig _eclipsePlugin = this.projectConfig.getEclipsePlugin();
        IXtextGeneratorFileSystemAccess _srcGen = _eclipsePlugin.getSrcGen();
        boolean bl = _tripleNotEquals = _srcGen != null;
        if (_tripleNotEquals) {
            XtextGeneratorLanguage _head = (XtextGeneratorLanguage)IterableExtensions.head(this.languageConfigs);
            JavaFileAccess _createEclipsePluginExecutableExtensionFactory = this.templates.createEclipsePluginExecutableExtensionFactory(language, _head);
            IBundleProjectConfig _eclipsePlugin_1 = this.projectConfig.getEclipsePlugin();
            IXtextGeneratorFileSystemAccess _srcGen_1 = _eclipsePlugin_1.getSrcGen();
            _createEclipsePluginExecutableExtensionFactory.writeTo(_srcGen_1);
        }
    }

    protected void generateManifests() {
        try {
            String _path;
            boolean _tripleEquals;
            List<? extends ISubProjectConfig> _enabledProjects = this.projectConfig.getEnabledProjects();
            Iterable _filter = Iterables.filter(_enabledProjects, BundleProjectConfig.class);
            Functions.Function1<BundleProjectConfig, Triple<ManifestAccess, IXtextGeneratorFileSystemAccess, String>> _function = new Functions.Function1<BundleProjectConfig, Triple<ManifestAccess, IXtextGeneratorFileSystemAccess, String>>(){

                public Triple<ManifestAccess, IXtextGeneratorFileSystemAccess, String> apply(BundleProjectConfig it) {
                    ManifestAccess _manifest = it.getManifest();
                    IXtextGeneratorFileSystemAccess _metaInf = it.getMetaInf();
                    String _name = it.getName();
                    return Tuples.create((Object)_manifest, (Object)_metaInf, (Object)_name);
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function);
            List manifests = IterableExtensions.toList((Iterable)_map);
            int _size = manifests.size();
            HashMap uri2Manifest = Maps.newHashMapWithExpectedSize((int)_size);
            ListIterator manifestIter = manifests.listIterator();
            while (manifestIter.hasNext()) {
                URI uri;
                boolean _containsKey;
                IBundleProjectConfig _eclipsePlugin;
                ManifestAccess _manifest;
                boolean _tripleEquals_1;
                Triple entry = (Triple)manifestIter.next();
                ManifestAccess manifest = (ManifestAccess)entry.getFirst();
                IXtextGeneratorFileSystemAccess metaInf = (IXtextGeneratorFileSystemAccess)entry.getSecond();
                if (manifest == null || metaInf == null) {
                    manifestIter.remove();
                    continue;
                }
                boolean _and = false;
                TypeReference _activator = manifest.getActivator();
                boolean bl = _tripleEquals = _activator == null;
                _and = !_tripleEquals ? false : (_tripleEquals_1 = manifest == (_manifest = (_eclipsePlugin = this.projectConfig.getEclipsePlugin()).getManifest()));
                if (_and) {
                    TypeReference _eclipsePluginActivator = this.naming.getEclipsePluginActivator();
                    manifest.setActivator(_eclipsePluginActivator);
                }
                if (_containsKey = uri2Manifest.containsKey(uri = metaInf.getURI(_path = manifest.getPath()))) {
                    ManifestAccess _get = (ManifestAccess)uri2Manifest.get(uri);
                    _get.merge(manifest);
                    manifestIter.remove();
                    continue;
                }
                uri2Manifest.put(uri, manifest);
            }
            for (Triple entry : manifests) {
                boolean _isFile;
                ManifestAccess manifest = (ManifestAccess)entry.getFirst();
                IXtextGeneratorFileSystemAccess metaInf = (IXtextGeneratorFileSystemAccess)entry.getSecond();
                String _bundleName = manifest.getBundleName();
                boolean bl = _tripleEquals = _bundleName == null;
                if (_tripleEquals) {
                    String _third = (String)entry.getThird();
                    manifest.setBundleName(_third);
                }
                if (_isFile = metaInf.isFile(_path = manifest.getPath())) {
                    boolean _isMerge = manifest.isMerge();
                    if (_isMerge) {
                        this.mergeManifest(manifest, metaInf);
                        continue;
                    }
                    String _path_1 = manifest.getPath();
                    boolean _endsWith = _path_1.endsWith(".MF");
                    if (!_endsWith) continue;
                    String _path_2 = manifest.getPath();
                    String _plus = String.valueOf(_path_2) + "_gen";
                    manifest.setPath(_plus);
                    manifest.writeTo(metaInf);
                    continue;
                }
                manifest.writeTo(metaInf);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void mergeManifest(ManifestAccess manifest, IXtextGeneratorFileSystemAccess metaInf) throws IOException {
        InputStream in = null;
        try {
            boolean _isModified;
            boolean _tripleNotEquals;
            InputStream _readBinaryFile;
            String _path = manifest.getPath();
            in = _readBinaryFile = metaInf.readBinaryFile(_path);
            String _bundleName = manifest.getBundleName();
            MergeableManifest merge = new MergeableManifest(in, _bundleName);
            Set<String> _exportedPackages = manifest.getExportedPackages();
            merge.addExportedPackages(_exportedPackages);
            Set<String> _requiredBundles = manifest.getRequiredBundles();
            merge.addRequiredBundles(_requiredBundles);
            Set<String> _importedPackages = manifest.getImportedPackages();
            merge.addImportedPackages(_importedPackages);
            boolean _and = false;
            TypeReference _activator = manifest.getActivator();
            boolean bl = _tripleNotEquals = _activator != null;
            if (!_tripleNotEquals) {
                _and = false;
            } else {
                boolean _isNullOrEmpty;
                String _bundleActivator = merge.getBundleActivator();
                _and = _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_bundleActivator);
            }
            if (_and) {
                TypeReference _activator_1 = manifest.getActivator();
                String _name = _activator_1.getName();
                merge.setBundleActivator(_name);
            }
            if (_isModified = merge.isModified()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                merge.write((OutputStream)out);
                String _path_1 = manifest.getPath();
                byte[] _byteArray = out.toByteArray();
                ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_byteArray);
                metaInf.generateFile(_path_1, _byteArrayInputStream);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    protected void generateActivator() {
        boolean _isEmpty;
        boolean _not;
        boolean _tripleNotEquals;
        boolean _and = false;
        IBundleProjectConfig _eclipsePlugin = this.projectConfig.getEclipsePlugin();
        IXtextGeneratorFileSystemAccess _srcGen = _eclipsePlugin.getSrcGen();
        boolean bl = _tripleNotEquals = _srcGen != null;
        _and = !_tripleNotEquals ? false : (_not = !(_isEmpty = this.languageConfigs.isEmpty()));
        if (_and) {
            JavaFileAccess _createEclipsePluginActivator = this.templates.createEclipsePluginActivator(this.languageConfigs);
            IBundleProjectConfig _eclipsePlugin_1 = this.projectConfig.getEclipsePlugin();
            IXtextGeneratorFileSystemAccess _srcGen_1 = _eclipsePlugin_1.getSrcGen();
            _createEclipsePluginActivator.writeTo(_srcGen_1);
        }
    }

    protected void generatePluginXmls() {
        List<? extends ISubProjectConfig> _enabledProjects = this.projectConfig.getEnabledProjects();
        Iterable _filter = Iterables.filter(_enabledProjects, BundleProjectConfig.class);
        Functions.Function1<BundleProjectConfig, Pair<PluginXmlAccess, IXtextGeneratorFileSystemAccess>> _function = new Functions.Function1<BundleProjectConfig, Pair<PluginXmlAccess, IXtextGeneratorFileSystemAccess>>(){

            public Pair<PluginXmlAccess, IXtextGeneratorFileSystemAccess> apply(BundleProjectConfig it) {
                PluginXmlAccess _pluginXml = it.getPluginXml();
                IXtextGeneratorFileSystemAccess _root = it.getRoot();
                return Pair.of((Object)_pluginXml, (Object)_root);
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function);
        List pluginXmls = IterableExtensions.toList((Iterable)_map);
        int _size = pluginXmls.size();
        HashMap uri2PluginXml = Maps.newHashMapWithExpectedSize((int)_size);
        ListIterator pluginXmlIter = pluginXmls.listIterator();
        while (pluginXmlIter.hasNext()) {
            Pair entry = (Pair)pluginXmlIter.next();
            PluginXmlAccess pluginXml = (PluginXmlAccess)entry.getKey();
            IXtextGeneratorFileSystemAccess root = (IXtextGeneratorFileSystemAccess)entry.getValue();
            if (pluginXml == null || root == null) {
                pluginXmlIter.remove();
                continue;
            }
            String _path = pluginXml.getPath();
            URI uri = root.getURI(_path);
            boolean _containsKey = uri2PluginXml.containsKey(uri);
            if (_containsKey) {
                PluginXmlAccess _get = (PluginXmlAccess)uri2PluginXml.get(uri);
                _get.merge(pluginXml);
                pluginXmlIter.remove();
                continue;
            }
            uri2PluginXml.put(uri, pluginXml);
        }
        for (Pair entry : pluginXmls) {
            String _path;
            PluginXmlAccess pluginXml = (PluginXmlAccess)entry.getKey();
            IXtextGeneratorFileSystemAccess root = (IXtextGeneratorFileSystemAccess)entry.getValue();
            boolean _isFile = root.isFile(_path = pluginXml.getPath());
            if (_isFile) {
                CharSequence _content;
                String _path_1;
                CharSequence _readTextFile;
                boolean _notEquals;
                boolean _not;
                boolean _and = false;
                boolean _and_1 = false;
                List<CharSequence> _entries = pluginXml.getEntries();
                boolean _isEmpty = _entries.isEmpty();
                boolean bl = _not = !_isEmpty;
                _and_1 = !_not ? false : (_notEquals = !Objects.equal((Object)(_readTextFile = root.readTextFile(_path_1 = pluginXml.getPath())), (Object)(_content = pluginXml.getContent())));
                if (!_and_1) {
                    _and = false;
                } else {
                    boolean _endsWith;
                    String _path_2 = pluginXml.getPath();
                    _and = _endsWith = _path_2.endsWith(".xml");
                }
                if (!_and) continue;
                String _path_3 = pluginXml.getPath();
                String _plus = String.valueOf(_path_3) + "_gen";
                pluginXml.setPath(_plus);
                pluginXml.writeTo(root);
                continue;
            }
            pluginXml.writeTo(root);
        }
    }

    @Pure
    public DefaultGeneratorModule getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DefaultGeneratorModule configuration) {
        this.configuration = configuration;
    }

    @Pure
    public List<XtextGeneratorLanguage> getLanguageConfigs() {
        return this.languageConfigs;
    }

    @Pure
    public XtextDirectoryCleaner getCleaner() {
        return this.cleaner;
    }

    public void setCleaner(XtextDirectoryCleaner cleaner) {
        this.cleaner = cleaner;
    }

    @Pure
    public XtextGeneratorStandaloneSetup getStandaloneSetup() {
        return this.standaloneSetup;
    }

    public void setStandaloneSetup(XtextGeneratorStandaloneSetup standaloneSetup) {
        this.standaloneSetup = standaloneSetup;
    }
}

