/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.graph;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.gef.common.attributes.IAttributeCopier;
import org.eclipse.gef.common.attributes.IAttributeStore;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.graph.Node;

public class GraphCopier {
    private Map<Node, Node> inputToOutputNodes = new IdentityHashMap<Node, Node>();
    private Map<Edge, Edge> inputToOutputEdges = new IdentityHashMap<Edge, Edge>();
    private IAttributeCopier attributeCopier;

    public GraphCopier(IAttributeCopier attributeCopier) {
        this.attributeCopier = attributeCopier;
    }

    public Graph copy(Graph graph) {
        this.inputToOutputNodes.clear();
        this.inputToOutputEdges.clear();
        return this.copyGraph(graph);
    }

    protected void copyAttributes(IAttributeStore inputStore, IAttributeStore outputStore) {
        this.attributeCopier.copy(inputStore, outputStore);
    }

    protected Edge copyEdge(Edge edge) {
        Node outputSource = this.inputToOutputNodes.get(edge.getSource());
        Node outputTarget = this.inputToOutputNodes.get(edge.getTarget());
        Edge outputEdge = new Edge(outputSource, outputTarget);
        this.copyAttributes(edge, outputEdge);
        return outputEdge;
    }

    protected Graph copyGraph(Graph graph) {
        Graph outputGraph = new Graph();
        this.copyAttributes(graph, outputGraph);
        for (Node inputNode : graph.getNodes()) {
            Node outputNode = this.copyNode(inputNode);
            if (outputNode == null) continue;
            this.inputToOutputNodes.put(inputNode, outputNode);
            outputGraph.getNodes().add((Object)outputNode);
        }
        for (Edge inputEdge : graph.getEdges()) {
            Edge outputEdge = this.copyEdge(inputEdge);
            if (outputEdge == null) continue;
            this.inputToOutputEdges.put(inputEdge, outputEdge);
            outputGraph.getEdges().add((Object)outputEdge);
        }
        return outputGraph;
    }

    protected Node copyNode(Node node) {
        Node outputNode = new Node();
        this.copyAttributes(node, outputNode);
        if (node.getNestedGraph() != null) {
            Graph nested = this.copyGraph(node.getNestedGraph());
            outputNode.setNestedGraph(nested);
        }
        return outputNode;
    }

    public IAttributeCopier getAttributeCopier() {
        return this.attributeCopier;
    }

    public Map<Edge, Edge> getInputToOutputEdgeMap() {
        return Collections.unmodifiableMap(this.inputToOutputEdges);
    }

    public Map<Node, Node> getInputToOutputNodeMap() {
        return Collections.unmodifiableMap(this.inputToOutputNodes);
    }
}

