/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.folding;

import com.google.inject.Injector;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.DotPackage;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.dot.internal.ui.language.editor.DotEditorUtils;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivator;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.folding.DefaultFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.folding.FoldedPosition;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionAcceptor;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.ITextRegion;

public class DotFoldingRegionProvider
extends DefaultFoldingRegionProvider {
    private Injector injector;

    protected void computeObjectFolding(XtextResource xtextResource, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor) {
        EObject rootASTElement;
        IParseResult parseResult = xtextResource.getParseResult();
        if (parseResult != null && (rootASTElement = parseResult.getRootASTElement()) != null) {
            TreeIterator allContents = rootASTElement.eAllContents();
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (this.isHandled(eObject)) {
                    this.computeObjectFolding(eObject, foldingRegionAcceptor);
                }
                if (eObject instanceof Attribute) {
                    this.computeDotAttributeValueFolding((Attribute)eObject, foldingRegionAcceptor);
                }
                if (this.shouldProcessContent(eObject)) continue;
                allContents.prune();
            }
        }
    }

    private void computeDotAttributeValueFolding(Attribute attribute, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor) {
        if (attribute.getValue() != null && attribute.getValue().getType() == ID.Type.HTML_STRING) {
            String htmlLabelValue = attribute.getValue().toValue();
            this.injector = DotActivator.getInstance().getInjector("org.eclipse.gef.dot.internal.language.DotHtmlLabel");
            IFoldingRegionProvider htmlLabelFoldingRegionProvider = (IFoldingRegionProvider)this.injector.getInstance(IFoldingRegionProvider.class);
            IXtextDocument xtextDocument = null;
            try {
                xtextDocument = DotEditorUtils.getDocument(this.injector, htmlLabelValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (xtextDocument != null) {
                Collection htmlLabelFoldingRegions = htmlLabelFoldingRegionProvider.getFoldingRegions(xtextDocument);
                for (FoldedPosition htmlFoldedPosition : htmlLabelFoldingRegions) {
                    int attributeValueStartOffset = this.getAttributeValueStartOffset(attribute);
                    foldingRegionAcceptor.accept(attributeValueStartOffset + htmlFoldedPosition.getOffset(), htmlFoldedPosition.getLength() - 1);
                }
            }
        }
    }

    private int getAttributeValueStartOffset(Attribute attribute) {
        ID attributeValue = attribute.getValue();
        List nodes = NodeModelUtils.findNodesForFeature((EObject)attribute, (EStructuralFeature)DotPackage.Literals.ATTRIBUTE__VALUE);
        if (nodes.size() != 1) {
            System.err.println("Exact 1 node is expected for the attribute value: " + attributeValue + ", but got " + nodes.size());
            return 0;
        }
        INode node = (INode)nodes.get(0);
        int attributeValueStartOffset = node.getOffset();
        if (attributeValue.getType() == ID.Type.HTML_STRING || attributeValue.getType() == ID.Type.QUOTED_STRING) {
            ++attributeValueStartOffset;
        }
        return attributeValueStartOffset;
    }
}

