/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.geometry.projective;

import org.eclipse.gef.geometry.euclidean.Straight;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.projective.Vector3D;

public final class Straight3D {
    private Vector3D sp;
    private Vector3D line;
    private double f;

    public static Straight3D through(Vector3D start, Vector3D end) {
        Straight3D self = new Straight3D();
        self.sp = start;
        self.line = self.sp.getCrossProduct(end);
        self.f = Math.sqrt(self.line.x * self.line.x + self.line.y * self.line.y);
        if (self.f == 0.0) {
            return null;
        }
        return self;
    }

    private Straight3D() {
    }

    public Vector3D getIntersection(Straight3D other) {
        return this.line.getCrossProduct(other.line);
    }

    public Straight3D getOrtho() {
        return this.getOrtho(this.sp);
    }

    public Straight3D getOrtho(Vector3D vp) {
        return Straight3D.through(vp, new Vector3D(vp.x + this.line.x, vp.y + this.line.y, vp.z));
    }

    public double getSignedDistanceCW(Vector3D vp) {
        Point p = vp.toPoint();
        return (this.line.x * p.x + this.line.y * p.y + this.line.z) / this.f;
    }

    public Straight toStraight() {
        return new Straight(this.sp.toPoint(), this.sp.toPoint().getTranslated(new Point(this.line.y, -this.line.x)));
    }
}

