/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.gestures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.mvc.fx.gestures.AbstractGesture;
import org.eclipse.gef.mvc.fx.handlers.IHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnClickHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnDragHandler;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class ClickDragGesture
extends AbstractGesture {
    public static final Class<IOnClickHandler> ON_CLICK_POLICY_KEY = IOnClickHandler.class;
    public static final Class<IOnDragHandler> ON_DRAG_POLICY_KEY = IOnDragHandler.class;
    private final Set<Scene> scenes = Collections.newSetFromMap(new IdentityHashMap());
    private IViewer activeViewer;
    private Node pressed;
    private Point2D startMousePosition;
    private EventHandler<? super MouseEvent> mouseFilter = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            EventType type = event.getEventType();
            if (ClickDragGesture.this.pressed == null && type.equals(MouseEvent.MOUSE_PRESSED)) {
                EventTarget target = event.getTarget();
                if (target instanceof Node) {
                    ClickDragGesture.this.pressed = (Node)target;
                    ClickDragGesture.this.startMousePosition = new Point2D(event.getSceneX(), event.getSceneY());
                    ClickDragGesture.this.press(ClickDragGesture.this.pressed, event);
                }
                return;
            }
            if (ClickDragGesture.this.pressed == null) {
                return;
            }
            if (type.equals(MouseEvent.MOUSE_EXITED_TARGET) || type.equals(MouseEvent.MOUSE_ENTERED_TARGET)) {
                return;
            }
            boolean dragged = type.equals(MouseEvent.MOUSE_DRAGGED);
            boolean released = false;
            if (!(dragged || (released = type.equals(MouseEvent.MOUSE_RELEASED)) || event.isPrimaryButtonDown() || event.isSecondaryButtonDown() || event.isMiddleButtonDown())) {
                released = true;
            }
            if (dragged || released) {
                double x = event.getSceneX();
                double dx = x - ClickDragGesture.this.startMousePosition.getX();
                double y = event.getSceneY();
                double dy = y - ClickDragGesture.this.startMousePosition.getY();
                if (dragged) {
                    ClickDragGesture.this.drag(ClickDragGesture.this.pressed, event, dx, dy);
                } else {
                    ClickDragGesture.this.release(ClickDragGesture.this.pressed, event, dx, dy);
                    ClickDragGesture.this.pressed = null;
                }
            }
        }
    };
    private ChangeListener<Boolean> viewerFocusChangeListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (ClickDragGesture.this.activeViewer == null) {
                return;
            }
            for (IViewer iViewer : ClickDragGesture.this.getDomain().getViewers().values()) {
                if (!iViewer.isViewerFocused()) continue;
                return;
            }
            for (IHandler iHandler : ClickDragGesture.this.getActiveHandlers(ClickDragGesture.this.activeViewer)) {
                if (!(iHandler instanceof IOnDragHandler)) continue;
                ((IOnDragHandler)iHandler).abortDrag();
            }
            ClickDragGesture.this.clearActiveHandlers(ClickDragGesture.this.activeViewer);
            ClickDragGesture.this.activeViewer = null;
            ClickDragGesture.this.getDomain().closeExecutionTransaction(ClickDragGesture.this);
        }
    };
    private final IOnDragHandler[] indicationCursorPolicy = new IOnDragHandler[1];
    private final List<IOnDragHandler>[] possibleDragPolicies = new ArrayList[1];
    private EventHandler<MouseEvent> indicationCursorMouseMoveFilter = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            EventTarget eventTarget;
            if (ClickDragGesture.this.indicationCursorPolicy[0] != null) {
                ClickDragGesture.this.indicationCursorPolicy[0].hideIndicationCursor();
                ((ClickDragGesture)ClickDragGesture.this).indicationCursorPolicy[0] = null;
            }
            if ((eventTarget = event.getTarget()) instanceof Node) {
                Node target = (Node)eventTarget;
                IViewer viewer = PartUtils.retrieveViewer(ClickDragGesture.this.getDomain(), target);
                ((ClickDragGesture)ClickDragGesture.this).possibleDragPolicies[0] = viewer != null ? new ArrayList<IOnDragHandler>(ClickDragGesture.this.getHandlerResolver().resolve(ClickDragGesture.this, target, viewer, ON_DRAG_POLICY_KEY)) : new ArrayList();
                ListIterator dragIterator = ClickDragGesture.this.possibleDragPolicies[0].listIterator(ClickDragGesture.this.possibleDragPolicies[0].size());
                while (dragIterator.hasPrevious()) {
                    IOnDragHandler policy = (IOnDragHandler)dragIterator.previous();
                    if (!policy.showIndicationCursor(event)) continue;
                    ((ClickDragGesture)ClickDragGesture.this).indicationCursorPolicy[0] = policy;
                    break;
                }
            }
        }
    };
    private EventHandler<KeyEvent> indicationCursorKeyFilter = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            if (ClickDragGesture.this.indicationCursorPolicy[0] != null) {
                ClickDragGesture.this.indicationCursorPolicy[0].hideIndicationCursor();
                ((ClickDragGesture)ClickDragGesture.this).indicationCursorPolicy[0] = null;
            }
            if (ClickDragGesture.this.possibleDragPolicies[0] == null || ClickDragGesture.this.possibleDragPolicies[0].isEmpty()) {
                return;
            }
            ListIterator dragIterator = ClickDragGesture.this.possibleDragPolicies[0].listIterator(ClickDragGesture.this.possibleDragPolicies[0].size());
            while (dragIterator.hasPrevious()) {
                IOnDragHandler policy = (IOnDragHandler)dragIterator.previous();
                if (!policy.showIndicationCursor(event)) continue;
                ((ClickDragGesture)ClickDragGesture.this).indicationCursorPolicy[0] = policy;
                break;
            }
        }
    };

    @Override
    protected void doActivate() {
        super.doActivate();
        ChangeListener sceneListener = (exp, oldScene, newScene) -> {
            if (oldScene != null && this.getDomain().getViewers().values().stream().noneMatch(v -> v.getCanvas().getScene() == oldScene)) {
                this.unhookScene((Scene)oldScene);
            }
            if (newScene != null) {
                this.hookScene((Scene)newScene);
            }
        };
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            viewer.viewerFocusedProperty().addListener(this.viewerFocusChangeListener);
            ReadOnlyObjectProperty sceneProperty = viewer.getCanvas().sceneProperty();
            sceneProperty.addListener(sceneListener);
            if (sceneProperty.get() == null) continue;
            sceneListener.changed((ObservableValue)sceneProperty, null, sceneProperty.get());
        }
    }

    @Override
    protected void doDeactivate() {
        for (Scene scene : new ArrayList<Scene>(this.scenes)) {
            this.unhookScene(scene);
        }
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            viewer.viewerFocusedProperty().removeListener(this.viewerFocusChangeListener);
        }
        super.doDeactivate();
    }

    protected void drag(Node target, MouseEvent event, double dx, double dy) {
        if (this.activeViewer == null || this.getActiveHandlers(this.activeViewer).isEmpty()) {
            return;
        }
        for (IOnDragHandler policy : this.getActiveHandlers(this.activeViewer)) {
            policy.drag(event, new Dimension(dx, dy));
        }
    }

    public List<IOnDragHandler> getActiveHandlers(IViewer viewer) {
        return super.getActiveHandlers(viewer);
    }

    private void hookScene(Scene scene) {
        if (this.scenes.contains(scene)) {
            return;
        }
        scene.addEventFilter(MouseEvent.MOUSE_MOVED, this.indicationCursorMouseMoveFilter);
        scene.addEventFilter(KeyEvent.ANY, this.indicationCursorKeyFilter);
        scene.addEventFilter(MouseEvent.ANY, this.mouseFilter);
        this.scenes.add(scene);
    }

    protected void press(Node target, MouseEvent event) {
        IViewer viewer = PartUtils.retrieveViewer(this.getDomain(), target);
        if (viewer == null) {
            return;
        }
        if (viewer instanceof InfiniteCanvasViewer) {
            InfiniteCanvas canvas = ((InfiniteCanvasViewer)viewer).getCanvas();
            if (event.getTarget() instanceof Node) {
                Node targetNode = (Node)event.getTarget();
                while (targetNode != null) {
                    if (targetNode == canvas.getHorizontalScrollBar() || targetNode == canvas.getVerticalScrollBar()) {
                        return;
                    }
                    targetNode = targetNode.getParent();
                }
            }
        }
        this.indicationCursorMouseMoveFilter.handle((Event)event);
        Scene scene = target.getScene();
        if (scene == null) {
            System.err.println("Target part is not in Scene.");
            return;
        }
        scene.removeEventFilter(MouseEvent.MOUSE_MOVED, this.indicationCursorMouseMoveFilter);
        scene.removeEventFilter(KeyEvent.ANY, this.indicationCursorKeyFilter);
        viewer = PartUtils.retrieveViewer(this.getDomain(), target);
        boolean opened = false;
        List<IOnClickHandler> clickPolicies = this.getHandlerResolver().resolve(this, target, viewer, ON_CLICK_POLICY_KEY);
        if (clickPolicies != null && !clickPolicies.isEmpty()) {
            opened = true;
            this.getDomain().openExecutionTransaction(this);
            for (IOnClickHandler clickPolicy : clickPolicies) {
                clickPolicy.click(event);
            }
        }
        this.activeViewer = PartUtils.retrieveViewer(this.getDomain(), target);
        List<IOnDragHandler> policies = null;
        if (this.activeViewer != null) {
            policies = this.getHandlerResolver().resolve(this, target, this.activeViewer, ON_DRAG_POLICY_KEY);
        }
        if (policies == null || policies.isEmpty()) {
            if (opened) {
                this.getDomain().closeExecutionTransaction(this);
            }
            policies = null;
            return;
        }
        if (!opened) {
            this.getDomain().openExecutionTransaction(this);
        }
        this.setActiveHandlers(this.activeViewer, policies);
        for (IOnDragHandler policy : policies) {
            policy.startDrag(event);
        }
    }

    protected void release(Node target, MouseEvent event, double dx, double dy) {
        if (this.activeViewer == null) {
            return;
        }
        Scene scene = this.activeViewer.getRootPart().getVisual().getScene();
        if (scene == null) {
            throw new IllegalStateException("Active viewer's root part visual is not in Scene.");
        }
        scene.addEventFilter(MouseEvent.MOUSE_MOVED, this.indicationCursorMouseMoveFilter);
        scene.addEventFilter(KeyEvent.ANY, this.indicationCursorKeyFilter);
        if (this.getActiveHandlers(this.activeViewer).isEmpty()) {
            this.activeViewer = null;
            return;
        }
        for (IOnDragHandler policy : this.getActiveHandlers(this.activeViewer)) {
            policy.endDrag(event, new Dimension(dx, dy));
        }
        this.clearActiveHandlers(this.activeViewer);
        this.activeViewer = null;
        this.getDomain().closeExecutionTransaction(this);
        if (this.indicationCursorPolicy[0] != null) {
            this.indicationCursorPolicy[0].hideIndicationCursor();
            this.indicationCursorPolicy[0] = null;
        }
    }

    private void unhookScene(Scene scene) {
        scene.removeEventFilter(MouseEvent.ANY, this.mouseFilter);
        scene.removeEventFilter(MouseEvent.MOUSE_MOVED, this.indicationCursorMouseMoveFilter);
        scene.removeEventFilter(KeyEvent.ANY, this.indicationCursorKeyFilter);
        this.scenes.remove(scene);
    }
}

