/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.preferences;

import java.io.File;
import java.util.Arrays;
import org.eclipse.gef.dot.internal.DotExecutableUtils;
import org.eclipse.gef.dot.internal.ui.DotUiMessages;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivatorEx;
import org.eclipse.gef.dot.internal.ui.preferences.BooleanFieldEditor2;
import org.eclipse.gef.dot.internal.ui.preferences.DotExportRadioGroupFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.Preferences;

public class GraphvizPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DOT_SELECT_SHORT = DotUiMessages.GraphvizPreference_0;
    private static final String DOT_SELECT_LONG = DotUiMessages.GraphvizPreference_1;
    private static final String INVALID_DOT_EXECUTABLE = DotUiMessages.GraphvizPreference_2;
    private static final String DOT_EXPORT_FORMAT = DotUiMessages.GraphvizPreference_5;
    private static final String DOT_EXPORT_FORMAT_HINT = DotUiMessages.GraphvizPreference_6;
    private static final String DOT_OPEN_EXPORTED_FILE_AUTOMATICALLY = DotUiMessages.GraphvizPreference_7;
    public static final String DOT_PATH_PREF_KEY = "dotpath";
    public static final String DOT_EXPORTFORMAT_PREF_KEY = "dotexportformat";
    public static final String DOT_OPEN_EXPORTED_FILE_AUTOMATICALLY_PREF_KEY = "dot_open_exported_file_automatically";
    private static final String DOT_EXPORTFORMAT_DEFAULT = "pdf";
    private static Preferences dotUiPreferences = DotActivatorEx.dotUiPreferences();
    private static IPreferenceStore dotUiPreferenceStore = DotActivatorEx.dotUiPreferenceStore();
    private DotExportRadioGroupFieldEditor radioGroupFieldEditor;

    public GraphvizPreferencePage() {
        super(1);
    }

    public static boolean isGraphvizConfigured() {
        return GraphvizPreferencePage.isValidDotExecutable(GraphvizPreferencePage.getDotExecutablePath());
    }

    public static String getDotExecutablePath() {
        return dotUiPreferences.get(DOT_PATH_PREF_KEY, "");
    }

    public static String getDotExportFormat() {
        return dotUiPreferences.get(DOT_EXPORTFORMAT_PREF_KEY, "");
    }

    public static boolean getDotOpenExportedFileAutomaticallyValue() {
        return dotUiPreferences.getBoolean(DOT_OPEN_EXPORTED_FILE_AUTOMATICALLY_PREF_KEY, true);
    }

    private static boolean isValidDotExecutable(String path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        File file = new File(path);
        return file.exists() && (file.getName().equals("dot") || file.getName().equals("dot.exe"));
    }

    public void init(IWorkbench workbench) {
        if (!dotUiPreferenceStore.contains(DOT_OPEN_EXPORTED_FILE_AUTOMATICALLY_PREF_KEY)) {
            dotUiPreferenceStore.setDefault(DOT_OPEN_EXPORTED_FILE_AUTOMATICALLY_PREF_KEY, true);
        }
        this.setPreferenceStore(dotUiPreferenceStore);
        this.setDescription(DOT_SELECT_LONG);
    }

    protected void createFieldEditors() {
        FileFieldEditor fileFieldEditor = new FileFieldEditor(DOT_PATH_PREF_KEY, DOT_SELECT_SHORT, true, 0, this.getFieldEditorParent()){
            {
                this.setErrorMessage(INVALID_DOT_EXECUTABLE);
            }

            public boolean isValid() {
                boolean isValid = super.isValid();
                String currentValue = this.getStringValue();
                if (!currentValue.isEmpty()) {
                    isValid = isValid && GraphvizPreferencePage.isValidDotExecutable(currentValue);
                }
                return isValid;
            }

            protected void refreshValidState() {
                super.refreshValidState();
                if (!this.isValid()) {
                    this.showErrorMessage(this.getErrorMessage());
                }
                this.checkState();
            }

            public boolean doCheckState() {
                String currentValue = this.getStringValue();
                if (!currentValue.isEmpty()) {
                    return GraphvizPreferencePage.isValidDotExecutable(currentValue);
                }
                return super.doCheckState();
            }

            public String changePressed() {
                String dotExecutablePath = super.changePressed();
                if (dotExecutablePath == null) {
                    return null;
                }
                GraphvizPreferencePage.this.adaptDotExportUI(dotExecutablePath);
                return dotExecutablePath;
            }
        };
        this.addField((FieldEditor)fileFieldEditor);
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(GraphvizPreferencePage.DOT_PATH_PREF_KEY)) {
                    String dotExecutablePath = (String)event.getNewValue();
                    GraphvizPreferencePage.this.adaptDotExportUI(dotExecutablePath);
                }
            }
        });
        String dotExecutablePath = GraphvizPreferencePage.getDotExecutablePath();
        this.addDotExportUI(dotExecutablePath);
    }

    private String[] getSupportedExportFormats(String dotExecutablePath) {
        String[] supportedExportFormats = null;
        supportedExportFormats = DotExecutableUtils.getSupportedExportFormats((String)dotExecutablePath);
        return supportedExportFormats;
    }

    private String getDefaultExportFormat(String[] supportedExportFormats) {
        if (supportedExportFormats == null) {
            return null;
        }
        return Arrays.asList(supportedExportFormats).contains(DOT_EXPORTFORMAT_DEFAULT) ? DOT_EXPORTFORMAT_DEFAULT : supportedExportFormats[0];
    }

    private String[][] getLabelsAndValues(String[] supportedExportFormats) {
        String[][] labelsAndValues = null;
        if (supportedExportFormats != null) {
            labelsAndValues = new String[supportedExportFormats.length][2];
            int i = 0;
            while (i < supportedExportFormats.length) {
                labelsAndValues[i] = new String[]{supportedExportFormats[i], supportedExportFormats[i]};
                ++i;
            }
        }
        return labelsAndValues;
    }

    private void adaptDotExportUI(String dotExecutablePath) {
        if (GraphvizPreferencePage.isValidDotExecutable(dotExecutablePath)) {
            if (this.radioGroupFieldEditor == null) {
                this.addDotExportUI(dotExecutablePath);
            } else {
                this.updateDotExportUI(dotExecutablePath);
            }
        } else {
            this.removeDotExportUI();
        }
    }

    private void addDotExportUI(String dotExecutablePath) {
        String defaultExportFormat;
        String[] supportedExportFormats = null;
        if (!dotExecutablePath.isEmpty()) {
            supportedExportFormats = this.getSupportedExportFormats(dotExecutablePath);
        }
        String[][] labelsAndValues = this.getLabelsAndValues(supportedExportFormats);
        this.radioGroupFieldEditor = new DotExportRadioGroupFieldEditor(DOT_EXPORTFORMAT_PREF_KEY, DOT_EXPORT_FORMAT, DOT_EXPORT_FORMAT_HINT, 5, labelsAndValues, this.getFieldEditorParent());
        if (GraphvizPreferencePage.getDotExportFormat().isEmpty() && (defaultExportFormat = this.getDefaultExportFormat(supportedExportFormats)) != null) {
            dotUiPreferences.put(DOT_EXPORTFORMAT_PREF_KEY, defaultExportFormat);
        }
        this.addField((FieldEditor)this.radioGroupFieldEditor);
        BooleanFieldEditor2 openExportedFileBooleanFieldEditor = new BooleanFieldEditor2(DOT_OPEN_EXPORTED_FILE_AUTOMATICALLY_PREF_KEY, DOT_OPEN_EXPORTED_FILE_AUTOMATICALLY, this.getFieldEditorParent());
        this.addField((FieldEditor)openExportedFileBooleanFieldEditor);
        this.radioGroupFieldEditor.addOpenExportedFileBooleanFieldEditor(openExportedFileBooleanFieldEditor);
        if (dotExecutablePath.isEmpty()) {
            this.radioGroupFieldEditor.hideOpenExportedFileBooleanFieldEditor();
        }
    }

    private void updateDotExportUI(String dotExecutablePath) {
        String[] supportedExportFormats = this.getSupportedExportFormats(dotExecutablePath);
        String defaultExportFormat = this.getDefaultExportFormat(supportedExportFormats);
        String[][] labelsAndValues = this.getLabelsAndValues(supportedExportFormats);
        dotUiPreferences.put(DOT_EXPORTFORMAT_PREF_KEY, defaultExportFormat);
        this.radioGroupFieldEditor.update(labelsAndValues);
    }

    private void removeDotExportUI() {
        if (this.radioGroupFieldEditor != null) {
            this.radioGroupFieldEditor.clear();
            dotUiPreferences.remove(DOT_EXPORTFORMAT_PREF_KEY);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.removeDotExportUI();
    }
}

