/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.handlers;

import javafx.animation.AnimationTimer;
import javafx.geometry.Pos;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnStrokeHandler;
import org.eclipse.gef.mvc.fx.handlers.PanningSupport;
import org.eclipse.gef.mvc.fx.policies.ViewportPolicy;

public class PanOnStrokeHandler
extends AbstractHandler
implements IOnStrokeHandler {
    public static final double DEFAULT_SCROLL_AMOUNT_PER_SECOND = 150.0;
    private PanningSupport panningSupport = new PanningSupport();
    private AnimationTimer timer;
    private boolean isDown;
    private boolean isUp;
    private boolean isLeft;
    private boolean isRight;
    private long startMillisDown;
    private long startMillisUp;
    private long startMillisLeft;
    private long startMillisRight;
    private long currentMillisDown = 0L;
    private long currentMillisUp = 0L;
    private long currentMillisLeft = 0L;
    private long currentMillisRight = 0L;
    private long totalMillisDown = 0L;
    private long totalMillisUp = 0L;
    private long totalMillisLeft = 0L;
    private long totalMillisRight = 0L;
    private boolean invalidGesture = false;
    private ViewportPolicy viewportPolicy;

    @Override
    public void abortPress() {
        if (this.invalidGesture) {
            return;
        }
        this.rollback(this.viewportPolicy);
        this.viewportPolicy = null;
    }

    protected ViewportPolicy determineViewportPolicy() {
        return (ViewportPolicy)this.getHost().getRoot().getAdapter(ViewportPolicy.class);
    }

    @Override
    public void finalRelease(KeyEvent event) {
        if (this.invalidGesture) {
            return;
        }
        this.updateMillisOnKeyRelease(event);
        this.timer.stop();
        this.updateScrollPosition();
        this.commit(this.viewportPolicy);
        this.viewportPolicy = null;
        this.totalMillisDown = 0L;
        this.totalMillisUp = 0L;
        this.totalMillisLeft = 0L;
        this.totalMillisRight = 0L;
    }

    public double getScrollAmountPerSecond() {
        return 150.0;
    }

    public final ViewportPolicy getViewportPolicy() {
        return this.viewportPolicy;
    }

    @Override
    public void initialPress(KeyEvent event) {
        boolean bl = this.invalidGesture = !this.isPan(event);
        if (this.invalidGesture) {
            return;
        }
        this.viewportPolicy = this.determineViewportPolicy();
        this.init(this.viewportPolicy);
        this.updateMillisOnKeyPress(event);
        if (this.timer == null) {
            this.timer = new AnimationTimer(){

                public void handle(long nanos) {
                    long now = System.currentTimeMillis();
                    if (PanOnStrokeHandler.this.isDown) {
                        PanOnStrokeHandler.this.currentMillisDown = now - PanOnStrokeHandler.this.startMillisDown;
                    }
                    if (PanOnStrokeHandler.this.isUp) {
                        PanOnStrokeHandler.this.currentMillisUp = now - PanOnStrokeHandler.this.startMillisUp;
                    }
                    if (PanOnStrokeHandler.this.isLeft) {
                        PanOnStrokeHandler.this.currentMillisLeft = now - PanOnStrokeHandler.this.startMillisLeft;
                    }
                    if (PanOnStrokeHandler.this.isRight) {
                        PanOnStrokeHandler.this.currentMillisRight = now - PanOnStrokeHandler.this.startMillisRight;
                    }
                    PanOnStrokeHandler.this.updateScrollPosition();
                }
            };
        }
        this.timer.start();
    }

    protected boolean isContentRestricted() {
        return false;
    }

    protected boolean isPan(KeyEvent event) {
        return event.getCode().equals((Object)KeyCode.DOWN) || event.getCode().equals((Object)KeyCode.UP) || event.getCode().equals((Object)KeyCode.LEFT) || event.getCode().equals((Object)KeyCode.RIGHT);
    }

    @Override
    public void press(KeyEvent event) {
        this.updateMillisOnKeyPress(event);
    }

    @Override
    public void release(KeyEvent event) {
        this.updateMillisOnKeyRelease(event);
    }

    private void updateMillisOnKeyPress(KeyEvent event) {
        long now = System.currentTimeMillis();
        if (!this.isDown && event.getCode().equals((Object)KeyCode.DOWN)) {
            this.startMillisDown = now;
            this.currentMillisDown = 0L;
            this.isDown = true;
        } else if (!this.isUp && event.getCode().equals((Object)KeyCode.UP)) {
            this.startMillisUp = now;
            this.currentMillisUp = 0L;
            this.isUp = true;
        } else if (!this.isLeft && event.getCode().equals((Object)KeyCode.LEFT)) {
            this.startMillisLeft = now;
            this.currentMillisLeft = 0L;
            this.isLeft = true;
        } else if (!this.isRight && event.getCode().equals((Object)KeyCode.RIGHT)) {
            this.startMillisRight = now;
            this.currentMillisRight = 0L;
            this.isRight = true;
        }
    }

    private void updateMillisOnKeyRelease(KeyEvent event) {
        long now = System.currentTimeMillis();
        if (event.getCode().equals((Object)KeyCode.DOWN)) {
            this.isDown = false;
            this.totalMillisDown += now - this.startMillisDown;
            this.currentMillisDown = 0L;
        } else if (event.getCode().equals((Object)KeyCode.UP)) {
            this.isUp = false;
            this.totalMillisUp += now - this.startMillisUp;
            this.currentMillisUp = 0L;
        } else if (event.getCode().equals((Object)KeyCode.LEFT)) {
            this.isLeft = false;
            this.totalMillisLeft += now - this.startMillisLeft;
            this.currentMillisLeft = 0L;
        } else if (event.getCode().equals((Object)KeyCode.RIGHT)) {
            this.isRight = false;
            this.totalMillisRight += now - this.startMillisRight;
            this.currentMillisRight = 0L;
        }
    }

    protected void updateScrollPosition() {
        double scrollAmount = this.getScrollAmountPerSecond();
        double dx = (double)(this.totalMillisLeft + this.currentMillisLeft) / 1000.0 * scrollAmount - (double)(this.totalMillisRight + this.currentMillisRight) / 1000.0 * scrollAmount;
        double dy = (double)(this.totalMillisUp + this.currentMillisUp) / 1000.0 * scrollAmount - (double)(this.totalMillisDown + this.currentMillisDown) / 1000.0 * scrollAmount;
        this.viewportPolicy.scroll(false, dx, dy);
        if (this.isContentRestricted()) {
            this.panningSupport.removeFreeSpace(this.viewportPolicy, Pos.TOP_LEFT, true);
            this.panningSupport.removeFreeSpace(this.viewportPolicy, Pos.BOTTOM_RIGHT, false);
        }
    }
}

