/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.ui.actions;

import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.jface.action.ContributionItem;

public abstract class AbstractViewerContributionItem
extends ContributionItem
implements IAdaptable.Bound<IViewer> {
    private ReadOnlyObjectWrapper<IViewer> viewerProperty = new ReadOnlyObjectWrapper();
    private ChangeListener<Boolean> activationListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                AbstractViewerContributionItem.this.register();
            } else {
                AbstractViewerContributionItem.this.unregister();
            }
        }
    };

    protected AbstractViewerContributionItem() {
    }

    public ReadOnlyObjectProperty<IViewer> adaptableProperty() {
        return this.viewerProperty;
    }

    public IViewer getAdaptable() {
        return (IViewer)this.viewerProperty.get();
    }

    protected IViewer getViewer() {
        return this.getAdaptable();
    }

    public boolean isEnabled() {
        return this.getViewer() != null && this.getViewer().isActive();
    }

    protected void register() {
    }

    public void setAdaptable(IViewer viewer) {
        if (this.viewerProperty.get() == viewer) {
            return;
        }
        if (this.viewerProperty.get() != null) {
            ((IViewer)this.viewerProperty.get()).activeProperty().removeListener(this.activationListener);
            if (((IViewer)this.viewerProperty.get()).isActive()) {
                this.unregister();
            }
        }
        this.viewerProperty.set((Object)viewer);
        if (this.viewerProperty.get() != null) {
            ((IViewer)this.viewerProperty.get()).activeProperty().addListener(this.activationListener);
            if (((IViewer)this.viewerProperty.get()).isActive()) {
                this.register();
            }
        }
    }

    protected void unregister() {
    }
}

