/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.gef.common.attributes.IAttributeCopier;
import org.eclipse.gef.common.attributes.IAttributeStore;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.graph.Node;

public class GraphCopier {
    private Map<Node, Node> inputToOutputNodes = new IdentityHashMap<Node, Node>();
    private Map<Edge, Edge> inputToOutputEdges = new IdentityHashMap<Edge, Edge>();
    private IAttributeCopier attributeCopier;

    public GraphCopier(IAttributeCopier attributeCopier) {
        this.attributeCopier = attributeCopier;
    }

    protected void clearInputToOutputMaps() {
        this.inputToOutputNodes.clear();
        this.inputToOutputEdges.clear();
    }

    public Graph copy(Graph graph) {
        this.clearInputToOutputMaps();
        return this.copyGraph(graph);
    }

    protected void copyAttributes(IAttributeStore inputStore, IAttributeStore outputStore) {
        this.getAttributeCopier().copy(inputStore, outputStore);
    }

    protected Edge copyEdge(Edge edge) {
        Node outputSource = this.inputToOutputNodes.get(edge.getSource());
        Node outputTarget = this.inputToOutputNodes.get(edge.getTarget());
        Edge outputEdge = new Edge(outputSource, outputTarget);
        this.copyAttributes(edge, outputEdge);
        return outputEdge;
    }

    protected void copyEdges(Graph graph, Graph outputGraph) {
        ArrayList<Edge> allEdges = new ArrayList<Edge>(graph.getEdges().size());
        for (Edge inputEdge : graph.getEdges()) {
            Edge outputEdge = this.copyEdge(inputEdge);
            if (outputEdge == null) continue;
            this.trackCopiedEdge(inputEdge, outputEdge);
            allEdges.add(outputEdge);
        }
        outputGraph.getEdges().addAll(allEdges);
    }

    protected Graph copyGraph(Graph graph) {
        Graph outputGraph = new Graph();
        this.copyAttributes(graph, outputGraph);
        this.copyNodes(graph, outputGraph);
        this.copyEdges(graph, outputGraph);
        return outputGraph;
    }

    protected Node copyNode(Node node) {
        Node outputNode = new Node();
        this.copyAttributes(node, outputNode);
        if (node.getNestedGraph() != null) {
            Graph nested = this.copyGraph(node.getNestedGraph());
            outputNode.setNestedGraph(nested);
        }
        return outputNode;
    }

    protected void copyNodes(Graph graph, Graph outputGraph) {
        ArrayList<Node> allNodes = new ArrayList<Node>(graph.getNodes().size());
        for (Node inputNode : graph.getNodes()) {
            Node outputNode = this.copyNode(inputNode);
            if (outputNode == null) continue;
            this.trackCopiedNode(inputNode, outputNode);
            allNodes.add(outputNode);
        }
        outputGraph.getNodes().addAll(allNodes);
    }

    public IAttributeCopier getAttributeCopier() {
        return this.attributeCopier;
    }

    public Map<Edge, Edge> getInputToOutputEdgeMap() {
        return Collections.unmodifiableMap(this.inputToOutputEdges);
    }

    public Map<Node, Node> getInputToOutputNodeMap() {
        return Collections.unmodifiableMap(this.inputToOutputNodes);
    }

    protected void trackCopiedEdge(Edge inputEdge, Edge outputEdge) {
        this.inputToOutputEdges.put(inputEdge, outputEdge);
    }

    protected void trackCopiedNode(Node inputNode, Node outputNode) {
        this.inputToOutputNodes.put(inputNode, outputNode);
    }
}

