package org.eclipse.gef.dot.internal.ide.language.highlighting.antlr.lexer;

// Hack: Use our own Lexer superclass by means of import.
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

/*******************************************************************************
 * Copyright (c) 2018, 2020 itemis AG and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Tamas Miklossy (itemis AG) - initial API and implementation (bug #461506)
 *
 *******************************************************************************/
@SuppressWarnings("all")
public class CustomHighlightingInternalDotColorListLexer extends Lexer {
    public static final int RULE_WS=14;
    public static final int RULE_COLOR_STRING=13;
    public static final int RULE_DIGITS=9;
    public static final int RULE_ZERO_OR_ONE=10;
    public static final int Semicolon=8;
    public static final int Comma=5;
    public static final int RULE_COLOR_NUMBER=11;
    public static final int NumberSign=4;
    public static final int RULE_HEXADECIMAL_DIGIT=12;
    public static final int Solidus=6;
    public static final int Colon=7;
    public static final int EOF=-1;

      private boolean isHexValue = false;


    // delegates
    // delegators

    public CustomHighlightingInternalDotColorListLexer() {;} 
    public CustomHighlightingInternalDotColorListLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public CustomHighlightingInternalDotColorListLexer(CharStream input, RecognizerSharedState state) {
        super(input,state);

    }
    public String getGrammarFileName() { return "//home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g"; }

    // $ANTLR start "NumberSign"
    public final void mNumberSign() throws RecognitionException {
        try {
            int _type = NumberSign;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:28:12: ( '#' )
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:28:14: '#'
            {
            match('#'); 
            isHexValue = true;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "NumberSign"

    // $ANTLR start "Comma"
    public final void mComma() throws RecognitionException {
        try {
            int _type = Comma;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:30:7: ( ',' )
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:30:9: ','
            {
            match(','); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "Comma"

    // $ANTLR start "Solidus"
    public final void mSolidus() throws RecognitionException {
        try {
            int _type = Solidus;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:32:9: ( '/' )
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:32:11: '/'
            {
            match('/'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "Solidus"

    // $ANTLR start "Colon"
    public final void mColon() throws RecognitionException {
        try {
            int _type = Colon;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:34:7: ( ':' )
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:34:9: ':'
            {
            match(':'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "Colon"

    // $ANTLR start "Semicolon"
    public final void mSemicolon() throws RecognitionException {
        try {
            int _type = Semicolon;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:36:11: ( ';' )
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:36:13: ';'
            {
            match(';'); 
            isHexValue = false;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "Semicolon"

    // $ANTLR start "RULE_COLOR_NUMBER"
    public final void mRULE_COLOR_NUMBER() throws RecognitionException {
        try {
            int _type = RULE_COLOR_NUMBER;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:40:19: ({...}? => ( '.' ( RULE_DIGITS )+ | RULE_ZERO_OR_ONE ( '.' ( RULE_DIGITS )+ )? ) )
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:40:21: {...}? => ( '.' ( RULE_DIGITS )+ | RULE_ZERO_OR_ONE ( '.' ( RULE_DIGITS )+ )? )
            {
            if ( !((!isHexValue)) ) {
                throw new FailedPredicateException(input, "RULE_COLOR_NUMBER", "!isHexValue");
            }
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:40:37: ( '.' ( RULE_DIGITS )+ | RULE_ZERO_OR_ONE ( '.' ( RULE_DIGITS )+ )? )
            int alt4=2;
            int LA4_0 = input.LA(1);

            if ( (LA4_0=='.') ) {
                alt4=1;
            }
            else if ( ((LA4_0>='0' && LA4_0<='1')) ) {
                alt4=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 4, 0, input);

                throw nvae;
            }
            switch (alt4) {
                case 1 :
                    // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:40:38: '.' ( RULE_DIGITS )+
                    {
                    match('.'); 
                    // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:40:42: ( RULE_DIGITS )+
                    int cnt1=0;
                    loop1:
                    do {
                        int alt1=2;
                        int LA1_0 = input.LA(1);

                        if ( ((LA1_0>='0' && LA1_0<='9')) ) {
                            alt1=1;
                        }


                        switch (alt1) {
                    	case 1 :
                    	    // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:40:42: RULE_DIGITS
                    	    {
                    	    mRULE_DIGITS(); 

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt1 >= 1 ) break loop1;
                                EarlyExitException eee =
                                    new EarlyExitException(1, input);
                                throw eee;
                        }
                        cnt1++;
                    } while (true);


                    }
                    break;
                case 2 :
                    // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:40:55: RULE_ZERO_OR_ONE ( '.' ( RULE_DIGITS )+ )?
                    {
                    mRULE_ZERO_OR_ONE(); 
                    // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:40:72: ( '.' ( RULE_DIGITS )+ )?
                    int alt3=2;
                    int LA3_0 = input.LA(1);

                    if ( (LA3_0=='.') ) {
                        alt3=1;
                    }
                    switch (alt3) {
                        case 1 :
                            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:40:73: '.' ( RULE_DIGITS )+
                            {
                            match('.'); 
                            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:40:77: ( RULE_DIGITS )+
                            int cnt2=0;
                            loop2:
                            do {
                                int alt2=2;
                                int LA2_0 = input.LA(1);

                                if ( ((LA2_0>='0' && LA2_0<='9')) ) {
                                    alt2=1;
                                }


                                switch (alt2) {
                            	case 1 :
                            	    // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:40:77: RULE_DIGITS
                            	    {
                            	    mRULE_DIGITS(); 

                            	    }
                            	    break;

                            	default :
                            	    if ( cnt2 >= 1 ) break loop2;
                                        EarlyExitException eee =
                                            new EarlyExitException(2, input);
                                        throw eee;
                                }
                                cnt2++;
                            } while (true);


                            }
                            break;

                    }


                    }
                    break;

            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_COLOR_NUMBER"

    // $ANTLR start "RULE_HEXADECIMAL_DIGIT"
    public final void mRULE_HEXADECIMAL_DIGIT() throws RecognitionException {
        try {
            int _type = RULE_HEXADECIMAL_DIGIT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:42:24: ( ( RULE_DIGITS | 'a' .. 'f' | 'A' .. 'F' ) )
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:42:26: ( RULE_DIGITS | 'a' .. 'f' | 'A' .. 'F' )
            {
            if ( (input.LA(1)>='0' && input.LA(1)<='9')||(input.LA(1)>='A' && input.LA(1)<='F')||(input.LA(1)>='a' && input.LA(1)<='f') ) {
                input.consume();

            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_HEXADECIMAL_DIGIT"

    // $ANTLR start "RULE_COLOR_STRING"
    public final void mRULE_COLOR_STRING() throws RecognitionException {
        try {
            int _type = RULE_COLOR_STRING;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:44:19: ({...}? => ( 'a' .. 'z' | 'A' .. 'Z' | RULE_DIGITS )+ )
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:44:21: {...}? => ( 'a' .. 'z' | 'A' .. 'Z' | RULE_DIGITS )+
            {
            if ( !((!isHexValue)) ) {
                throw new FailedPredicateException(input, "RULE_COLOR_STRING", "!isHexValue");
            }
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:44:37: ( 'a' .. 'z' | 'A' .. 'Z' | RULE_DIGITS )+
            int cnt5=0;
            loop5:
            do {
                int alt5=2;
                int LA5_0 = input.LA(1);

                if ( ((LA5_0>='0' && LA5_0<='9')||(LA5_0>='A' && LA5_0<='Z')||(LA5_0>='a' && LA5_0<='z')) ) {
                    alt5=1;
                }


                switch (alt5) {
            	case 1 :
            	    // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:
            	    {
            	    if ( (input.LA(1)>='0' && input.LA(1)<='9')||(input.LA(1)>='A' && input.LA(1)<='Z')||(input.LA(1)>='a' && input.LA(1)<='z') ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    if ( cnt5 >= 1 ) break loop5;
                        EarlyExitException eee =
                            new EarlyExitException(5, input);
                        throw eee;
                }
                cnt5++;
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_COLOR_STRING"

    // $ANTLR start "RULE_ZERO_OR_ONE"
    public final void mRULE_ZERO_OR_ONE() throws RecognitionException {
        try {
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:46:27: ( ( '0' | '1' ) )
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:46:29: ( '0' | '1' )
            {
            if ( (input.LA(1)>='0' && input.LA(1)<='1') ) {
                input.consume();

            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}


            }

        }
        finally {
        }
    }
    // $ANTLR end "RULE_ZERO_OR_ONE"

    // $ANTLR start "RULE_DIGITS"
    public final void mRULE_DIGITS() throws RecognitionException {
        try {
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:48:22: ( ( RULE_ZERO_OR_ONE | '2' .. '9' ) )
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:48:24: ( RULE_ZERO_OR_ONE | '2' .. '9' )
            {
            if ( (input.LA(1)>='0' && input.LA(1)<='9') ) {
                input.consume();

            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}


            }

        }
        finally {
        }
    }
    // $ANTLR end "RULE_DIGITS"

    // $ANTLR start "RULE_WS"
    public final void mRULE_WS() throws RecognitionException {
        try {
            int _type = RULE_WS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:50:9: ( ( ' ' | '\\t' | '\\r' | '\\n' )+ )
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:50:11: ( ' ' | '\\t' | '\\r' | '\\n' )+
            {
            // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:50:11: ( ' ' | '\\t' | '\\r' | '\\n' )+
            int cnt6=0;
            loop6:
            do {
                int alt6=2;
                int LA6_0 = input.LA(1);

                if ( ((LA6_0>='\t' && LA6_0<='\n')||LA6_0=='\r'||LA6_0==' ') ) {
                    alt6=1;
                }


                switch (alt6) {
            	case 1 :
            	    // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:
            	    {
            	    if ( (input.LA(1)>='\t' && input.LA(1)<='\n')||input.LA(1)=='\r'||input.LA(1)==' ' ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    if ( cnt6 >= 1 ) break loop6;
                        EarlyExitException eee =
                            new EarlyExitException(6, input);
                        throw eee;
                }
                cnt6++;
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_WS"

    public void mTokens() throws RecognitionException {
        // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:1:8: ( NumberSign | Comma | Solidus | Colon | Semicolon | RULE_COLOR_NUMBER | RULE_HEXADECIMAL_DIGIT | RULE_COLOR_STRING | RULE_WS )
        int alt7=9;
        alt7 = dfa7.predict(input);
        switch (alt7) {
            case 1 :
                // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:1:10: NumberSign
                {
                mNumberSign(); 

                }
                break;
            case 2 :
                // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:1:21: Comma
                {
                mComma(); 

                }
                break;
            case 3 :
                // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:1:27: Solidus
                {
                mSolidus(); 

                }
                break;
            case 4 :
                // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:1:35: Colon
                {
                mColon(); 

                }
                break;
            case 5 :
                // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:1:41: Semicolon
                {
                mSemicolon(); 

                }
                break;
            case 6 :
                // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:1:51: RULE_COLOR_NUMBER
                {
                mRULE_COLOR_NUMBER(); 

                }
                break;
            case 7 :
                // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:1:69: RULE_HEXADECIMAL_DIGIT
                {
                mRULE_HEXADECIMAL_DIGIT(); 

                }
                break;
            case 8 :
                // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:1:92: RULE_COLOR_STRING
                {
                mRULE_COLOR_STRING(); 

                }
                break;
            case 9 :
                // //home/jenkins/agent/workspace/gef-master/gef/org.eclipse.gef.dot/../org.eclipse.gef.dot.ide/src/org/eclipse/gef/dot/internal/ide/language/highlighting/antlr/lexer/CustomHighlightingInternalDotColorListLexer.g:1:110: RULE_WS
                {
                mRULE_WS(); 

                }
                break;

        }

    }


    protected DFA7 dfa7 = new DFA7(this);
    static final String DFA7_eotS =
        "\7\uffff\1\13\1\14\5\uffff";
    static final String DFA7_eofS =
        "\16\uffff";
    static final String DFA7_minS =
        "\1\11\6\uffff\1\56\1\60\2\uffff\2\0\1\uffff";
    static final String DFA7_maxS =
        "\1\172\6\uffff\2\172\2\uffff\2\0\1\uffff";
    static final String DFA7_acceptS =
        "\1\uffff\1\1\1\2\1\3\1\4\1\5\1\6\2\uffff\1\10\1\11\2\uffff\1\7";
    static final String DFA7_specialS =
        "\1\0\6\uffff\1\2\1\3\2\uffff\1\4\1\1\1\uffff}>";
    static final String[] DFA7_transitionS = {
            "\2\12\2\uffff\1\12\22\uffff\1\12\2\uffff\1\1\10\uffff\1\2\1"+
            "\uffff\1\6\1\3\2\7\10\10\1\4\1\5\5\uffff\6\10\24\11\6\uffff"+
            "\6\10\24\11",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\6\1\uffff\12\11\7\uffff\32\11\6\uffff\32\11",
            "\12\11\7\uffff\32\11\6\uffff\32\11",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            ""
    };

    static final short[] DFA7_eot = DFA.unpackEncodedString(DFA7_eotS);
    static final short[] DFA7_eof = DFA.unpackEncodedString(DFA7_eofS);
    static final char[] DFA7_min = DFA.unpackEncodedStringToUnsignedChars(DFA7_minS);
    static final char[] DFA7_max = DFA.unpackEncodedStringToUnsignedChars(DFA7_maxS);
    static final short[] DFA7_accept = DFA.unpackEncodedString(DFA7_acceptS);
    static final short[] DFA7_special = DFA.unpackEncodedString(DFA7_specialS);
    static final short[][] DFA7_transition;

    static {
        int numStates = DFA7_transitionS.length;
        DFA7_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA7_transition[i] = DFA.unpackEncodedString(DFA7_transitionS[i]);
        }
    }

    class DFA7 extends DFA {

        public DFA7(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 7;
            this.eot = DFA7_eot;
            this.eof = DFA7_eof;
            this.min = DFA7_min;
            this.max = DFA7_max;
            this.accept = DFA7_accept;
            this.special = DFA7_special;
            this.transition = DFA7_transition;
        }
        public String getDescription() {
            return "1:1: Tokens : ( NumberSign | Comma | Solidus | Colon | Semicolon | RULE_COLOR_NUMBER | RULE_HEXADECIMAL_DIGIT | RULE_COLOR_STRING | RULE_WS );";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            IntStream input = _input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA7_0 = input.LA(1);

                         
                        int index7_0 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (LA7_0=='#') ) {s = 1;}

                        else if ( (LA7_0==',') ) {s = 2;}

                        else if ( (LA7_0=='/') ) {s = 3;}

                        else if ( (LA7_0==':') ) {s = 4;}

                        else if ( (LA7_0==';') ) {s = 5;}

                        else if ( (LA7_0=='.') && ((!isHexValue))) {s = 6;}

                        else if ( ((LA7_0>='0' && LA7_0<='1')) ) {s = 7;}

                        else if ( ((LA7_0>='2' && LA7_0<='9')||(LA7_0>='A' && LA7_0<='F')||(LA7_0>='a' && LA7_0<='f')) ) {s = 8;}

                        else if ( ((LA7_0>='G' && LA7_0<='Z')||(LA7_0>='g' && LA7_0<='z')) && ((!isHexValue))) {s = 9;}

                        else if ( ((LA7_0>='\t' && LA7_0<='\n')||LA7_0=='\r'||LA7_0==' ') ) {s = 10;}

                         
                        input.seek(index7_0);
                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA7_12 = input.LA(1);

                         
                        int index7_12 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (!(((!isHexValue)))) ) {s = 13;}

                        else if ( ((!isHexValue)) ) {s = 9;}

                         
                        input.seek(index7_12);
                        if ( s>=0 ) return s;
                        break;
                    case 2 : 
                        int LA7_7 = input.LA(1);

                         
                        int index7_7 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (LA7_7=='.') && ((!isHexValue))) {s = 6;}

                        else if ( ((LA7_7>='0' && LA7_7<='9')||(LA7_7>='A' && LA7_7<='Z')||(LA7_7>='a' && LA7_7<='z')) && ((!isHexValue))) {s = 9;}

                        else s = 11;

                         
                        input.seek(index7_7);
                        if ( s>=0 ) return s;
                        break;
                    case 3 : 
                        int LA7_8 = input.LA(1);

                         
                        int index7_8 = input.index();
                        input.rewind();
                        s = -1;
                        if ( ((LA7_8>='0' && LA7_8<='9')||(LA7_8>='A' && LA7_8<='Z')||(LA7_8>='a' && LA7_8<='z')) && ((!isHexValue))) {s = 9;}

                        else s = 12;

                         
                        input.seek(index7_8);
                        if ( s>=0 ) return s;
                        break;
                    case 4 : 
                        int LA7_11 = input.LA(1);

                         
                        int index7_11 = input.index();
                        input.rewind();
                        s = -1;
                        if ( ((!isHexValue)) ) {s = 6;}

                        else if ( (!(((!isHexValue)))) ) {s = 13;}

                        else if ( ((!isHexValue)) ) {s = 9;}

                         
                        input.seek(index7_11);
                        if ( s>=0 ) return s;
                        break;
            }
            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 7, _s, input);
            error(nvae);
            throw nvae;
        }
    }
 

}