/*
 * generated by Xtext 2.17.0
 */
package org.eclipse.gef.dot.internal.language.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gef.dot.internal.language.services.DotShapeGrammarAccess;
import org.eclipse.gef.dot.internal.language.shape.PolygonBasedShape;
import org.eclipse.gef.dot.internal.language.shape.RecordBasedShape;
import org.eclipse.gef.dot.internal.language.shape.Shape;
import org.eclipse.gef.dot.internal.language.shape.ShapePackage;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class DotShapeSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private DotShapeGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == ShapePackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case ShapePackage.POLYGON_BASED_SHAPE:
				sequence_PolygonBasedShape(context, (PolygonBasedShape) semanticObject); 
				return; 
			case ShapePackage.RECORD_BASED_SHAPE:
				sequence_RecordBasedShape(context, (RecordBasedShape) semanticObject); 
				return; 
			case ShapePackage.SHAPE:
				sequence_Shape(context, (Shape) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     PolygonBasedShape returns PolygonBasedShape
	 *
	 * Constraint:
	 *     shape=PolygonBasedNodeShape
	 */
	protected void sequence_PolygonBasedShape(ISerializationContext context, PolygonBasedShape semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, ShapePackage.Literals.POLYGON_BASED_SHAPE__SHAPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ShapePackage.Literals.POLYGON_BASED_SHAPE__SHAPE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getPolygonBasedShapeAccess().getShapePolygonBasedNodeShapeEnumRuleCall_0(), semanticObject.getShape());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     RecordBasedShape returns RecordBasedShape
	 *
	 * Constraint:
	 *     shape=RecordBasedNodeShape
	 */
	protected void sequence_RecordBasedShape(ISerializationContext context, RecordBasedShape semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, ShapePackage.Literals.RECORD_BASED_SHAPE__SHAPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ShapePackage.Literals.RECORD_BASED_SHAPE__SHAPE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getRecordBasedShapeAccess().getShapeRecordBasedNodeShapeEnumRuleCall_0(), semanticObject.getShape());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Shape returns Shape
	 *
	 * Constraint:
	 *     (shape=PolygonBasedShape | shape=RecordBasedShape)?
	 */
	protected void sequence_Shape(ISerializationContext context, Shape semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
}
