/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef.fx.anchors.AnchorKey;
import org.eclipse.gef.fx.anchors.DynamicAnchor;
import org.eclipse.gef.fx.anchors.IAnchor;
import org.eclipse.gef.fx.anchors.StaticAnchor;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.nodes.IConnectionRouter;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.euclidean.Vector;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Point;

public abstract class AbstractRouter
implements IConnectionRouter {
    private Connection connection;

    protected ControlPointManipulator createControlPointManipulator(Connection connection) {
        return new ControlPointManipulator(connection);
    }

    protected IGeometry getAnchorageGeometry(int index) {
        IAnchor anchor = this.connection.getAnchor(index);
        if (this.connection.isConnected(anchor)) {
            Node anchorage = anchor.getAnchorage();
            if (anchor instanceof DynamicAnchor) {
                IGeometry geometry = (IGeometry)((DynamicAnchor)anchor).getComputationParameter(this.connection.getAnchorKey(index), DynamicAnchor.AnchorageReferenceGeometry.class).get();
                return NodeUtils.sceneToLocal((Node)this.connection, NodeUtils.localToScene(anchorage, geometry));
            }
            return NodeUtils.sceneToLocal((Node)this.connection, NodeUtils.localToScene(anchorage, NodeUtils.getShapeOutline(anchorage)));
        }
        return null;
    }

    protected abstract Point getAnchoredReferencePoint(List<Point> var1, int var2);

    protected Connection getConnection() {
        return this.connection;
    }

    protected void insertRouterAnchors(Connection connection) {
        ArrayList<Point> pts = new ArrayList<Point>((Collection<Point>)connection.getPointsUnmodifiable());
        int i = 0;
        while (i < pts.size()) {
            Point pos = connection.getAnchor(i).getPosition(connection.getAnchorKey(i));
            pts.set(i, FX2Geometry.toPoint((Point2D)connection.getCurve().localToParent(Geometry2FX.toFXPoint((Point)pos))));
            ++i;
        }
        ControlPointManipulator cpm = this.createControlPointManipulator(connection);
        Vector inDirection = null;
        Vector outDirection = null;
        int i2 = 0;
        while (i2 < pts.size() - 1) {
            Point currentPoint = (Point)pts.get(i2);
            inDirection = outDirection;
            outDirection = new Vector(currentPoint, (Point)pts.get(i2 + 1));
            cpm.setRoutingData(i2, currentPoint, outDirection);
            outDirection = this.route(cpm, inDirection, outDirection);
            ++i2;
        }
        cpm.applyChanges();
    }

    protected void removeVolatileAnchors(Connection connection) {
        ArrayList<IAnchor> realAnchors = new ArrayList<IAnchor>();
        for (IAnchor a : connection.getControlAnchors()) {
            if (this.wasInserted(a)) continue;
            realAnchors.add(a);
        }
        connection.setControlAnchors(realAnchors);
    }

    @Override
    public void route(Connection connection) {
        this.connection = connection;
        this.removeVolatileAnchors(connection);
        this.updateComputationParameters(connection);
        this.insertRouterAnchors(connection);
    }

    protected Vector route(ControlPointManipulator cpm, Vector inDirection, Vector outDirection) {
        return outDirection;
    }

    protected void updateComputationParameters(Connection connection) {
        ArrayList<Point> pts = new ArrayList<Point>((Collection<Point>)connection.getPointsUnmodifiable());
        int i = 0;
        while (i < pts.size()) {
            IAnchor anchor = connection.getAnchor(i);
            if (anchor instanceof DynamicAnchor) {
                DynamicAnchor da = (DynamicAnchor)anchor;
                AnchorKey key = connection.getAnchorKey(i);
                this.updateComputationParameters(pts, i, da, key);
            }
            ++i;
        }
    }

    protected void updateComputationParameters(List<Point> points, int index, DynamicAnchor anchor, final AnchorKey key) {
        DynamicAnchor.AnchoredReferencePoint referencePointParameter = anchor.getComputationParameter(key, DynamicAnchor.AnchoredReferencePoint.class);
        Point oldRef = (Point)referencePointParameter.get();
        Point oldRefInScene = oldRef == null ? null : FX2Geometry.toPoint((Point2D)key.getAnchored().localToScene(Geometry2FX.toFXPoint((Point)oldRef)));
        final Point2D newRefInConnection = Geometry2FX.toFXPoint((Point)this.getAnchoredReferencePoint(points, index));
        Point newRefInScene = FX2Geometry.toPoint((Point2D)this.getConnection().localToScene(newRefInConnection));
        if (oldRefInScene == null || !newRefInScene.equals((Object)oldRefInScene)) {
            ObjectBinding<Point> refBinding = new ObjectBinding<Point>(){
                {
                    this.bind(new Observable[]{anchorKey.getAnchored().localToParentTransformProperty()});
                }

                protected Point computeValue() {
                    return FX2Geometry.toPoint((Point2D)key.getAnchored().parentToLocal(newRefInConnection));
                }
            };
            referencePointParameter.bind(refBinding);
        }
    }

    @Override
    public boolean wasInserted(IAnchor anchor) {
        return anchor instanceof VolatileStaticAnchor;
    }

    protected static class ControlPointManipulator {
        private Connection connection;
        private Map<Integer, List<Point>> pointsToInsert = new HashMap<Integer, List<Point>>();
        private int index;
        private Vector direction;
        private Point point;
        private List<IAnchor> controlAnchors;

        public ControlPointManipulator(Connection c) {
            this.connection = c;
            this.controlAnchors = new ArrayList<IAnchor>(this.connection.getControlAnchors());
        }

        public Vector addRoutingPoint(int index, Point point, double dx, double dy) {
            Point insertion = point.getTranslated(dx, dy);
            if (!this.pointsToInsert.containsKey(index)) {
                this.pointsToInsert.put(index, new ArrayList());
            }
            this.pointsToInsert.get(index).add(insertion);
            return new Vector(dx, dy);
        }

        public Vector addRoutingPoint(Vector delta) {
            this.direction = this.direction.getSubtracted(this.addRoutingPoint(this.index, this.point, delta.x, delta.y));
            return this.direction;
        }

        public void addRoutingPoints(int index, Point point, double ... deltas) {
            if (deltas == null) {
                throw new IllegalArgumentException("Even number of routing point deltas required, but got <null>.");
            }
            if (deltas.length == 0) {
                throw new IllegalArgumentException("Even number of routing point deltas required, but got 0.");
            }
            if (deltas.length % 2 != 0) {
                throw new IllegalArgumentException("Even number of routing point deltas required, but got " + deltas.length + ".");
            }
            if (!this.pointsToInsert.containsKey(index)) {
                this.pointsToInsert.put(index, new ArrayList());
            }
            int i = 0;
            while (i < deltas.length) {
                Point insertion = point.getTranslated(deltas[i], deltas[i + 1]);
                this.pointsToInsert.get(index).add(insertion);
                i += 2;
            }
        }

        public void applyChanges() {
            if (this.controlAnchors == null) {
                throw new IllegalStateException("Cannot apply changes twice.");
            }
            int pointsInserted = 0;
            for (int insertionIndex : this.pointsToInsert.keySet()) {
                for (Point pointToInsert : this.pointsToInsert.get(insertionIndex)) {
                    this.controlAnchors.add(insertionIndex + pointsInserted - 1, new VolatileStaticAnchor(this.connection, pointToInsert));
                    ++pointsInserted;
                }
            }
            this.connection.setControlAnchors(this.controlAnchors);
            this.controlAnchors = null;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public int getIndex() {
            return this.index;
        }

        public Point getPoint() {
            return this.point;
        }

        public void setRoutingData(int index, Point point, Vector direction) {
            this.index = index;
            this.point = point;
            this.direction = direction;
        }
    }

    protected static class VolatileStaticAnchor
    extends StaticAnchor {
        public VolatileStaticAnchor(Connection connection, Point referencePositionInAnchorageLocal) {
            super((Node)connection, referencePositionInAnchorageLocal);
        }

        @Override
        public String toString() {
            return "VolatileStaticAnchor[referencePosition=" + this.getReferencePosition() + "]";
        }
    }
}

