/**
 */
package org.eclipse.gef.dot.internal.language.fontname.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.gef.dot.internal.language.fontname.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.gef.dot.internal.language.fontname.FontnamePackage
 * @generated
 */
public class FontnameAdapterFactory extends AdapterFactoryImpl
{
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static FontnamePackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FontnameAdapterFactory()
	{
		if (modelPackage == null)
		{
			modelPackage = FontnamePackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object)
	{
		if (object == modelPackage)
		{
			return true;
		}
		if (object instanceof EObject)
		{
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FontnameSwitch<Adapter> modelSwitch =
		new FontnameSwitch<Adapter>()
		{
			@Override
			public Adapter caseFontName(FontName object)
			{
				return createFontNameAdapter();
			}
			@Override
			public Adapter casePostScriptFontName(PostScriptFontName object)
			{
				return createPostScriptFontNameAdapter();
			}
			@Override
			public Adapter casePangoFontName(PangoFontName object)
			{
				return createPangoFontNameAdapter();
			}
			@Override
			public Adapter caseStyleOptionsElement(StyleOptionsElement object)
			{
				return createStyleOptionsElementAdapter();
			}
			@Override
			public Adapter caseStyleOption(StyleOption object)
			{
				return createStyleOptionAdapter();
			}
			@Override
			public Adapter caseVariantOption(VariantOption object)
			{
				return createVariantOptionAdapter();
			}
			@Override
			public Adapter caseWeightOption(WeightOption object)
			{
				return createWeightOptionAdapter();
			}
			@Override
			public Adapter caseStretchOption(StretchOption object)
			{
				return createStretchOptionAdapter();
			}
			@Override
			public Adapter caseGravityOption(GravityOption object)
			{
				return createGravityOptionAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object)
			{
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target)
	{
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.gef.dot.internal.language.fontname.FontName <em>Font Name</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.gef.dot.internal.language.fontname.FontName
	 * @generated
	 */
	public Adapter createFontNameAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.gef.dot.internal.language.fontname.PostScriptFontName <em>Post Script Font Name</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.gef.dot.internal.language.fontname.PostScriptFontName
	 * @generated
	 */
	public Adapter createPostScriptFontNameAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.gef.dot.internal.language.fontname.PangoFontName <em>Pango Font Name</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.gef.dot.internal.language.fontname.PangoFontName
	 * @generated
	 */
	public Adapter createPangoFontNameAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.gef.dot.internal.language.fontname.StyleOptionsElement <em>Style Options Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.gef.dot.internal.language.fontname.StyleOptionsElement
	 * @generated
	 */
	public Adapter createStyleOptionsElementAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.gef.dot.internal.language.fontname.StyleOption <em>Style Option</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.gef.dot.internal.language.fontname.StyleOption
	 * @generated
	 */
	public Adapter createStyleOptionAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.gef.dot.internal.language.fontname.VariantOption <em>Variant Option</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.gef.dot.internal.language.fontname.VariantOption
	 * @generated
	 */
	public Adapter createVariantOptionAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.gef.dot.internal.language.fontname.WeightOption <em>Weight Option</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.gef.dot.internal.language.fontname.WeightOption
	 * @generated
	 */
	public Adapter createWeightOptionAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.gef.dot.internal.language.fontname.StretchOption <em>Stretch Option</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.gef.dot.internal.language.fontname.StretchOption
	 * @generated
	 */
	public Adapter createStretchOptionAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.gef.dot.internal.language.fontname.GravityOption <em>Gravity Option</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.gef.dot.internal.language.fontname.GravityOption
	 * @generated
	 */
	public Adapter createGravityOptionAdapter()
	{
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter()
	{
		return null;
	}

} //FontnameAdapterFactory
