/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.internal.behaviors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef.fx.anchors.DynamicAnchor;
import org.eclipse.gef.fx.anchors.IAnchor;
import org.eclipse.gef.fx.internal.nodes.IBendableCurve;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.nodes.IConnectionRouter;
import org.eclipse.gef.fx.nodes.OrthogonalRouter;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.euclidean.Vector;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.internal.behaviors.BendCurvePolicy;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IBendableContentPart;

public class BendConnectionPolicyEx
extends BendCurvePolicy {
    private boolean isNormalizationNeeded = false;
    private Point preMoveStartHint = null;
    private Point preMoveEndHint = null;

    @Override
    protected boolean canConnect(int explicitAnchorIndex) {
        return explicitAnchorIndex == 0 || explicitAnchorIndex == this.getBendOperation().getFinalBendPoints().size() - 1;
    }

    @Override
    public ITransactionalOperation commit() {
        if (this.isNormalizationNeeded) {
            this.normalize();
        }
        return super.commit();
    }

    private Point computeEndHint() {
        if (this.getCurve().getEndAnchor() instanceof DynamicAnchor && this.getCurve().getPointsUnmodifiable().size() > 1) {
            Point endPoint = this.getCurve().getEndPoint();
            Point neighbor = this.getCurve().getPoint(this.getCurve().getPointsUnmodifiable().size() - 2);
            Point translated = endPoint.getTranslated(endPoint.getDifference(neighbor).getScaled(0.5));
            return translated;
        }
        return null;
    }

    private Point computeStartHint() {
        if (this.getCurve().getStartAnchor() instanceof DynamicAnchor && this.getCurve().getPointsUnmodifiable().size() > 1) {
            Point startPoint = this.getCurve().getStartPoint();
            Point neighbor = this.getCurve().getPoint(1);
            Point translated = startPoint.getTranslated(startPoint.getDifference(neighbor).getScaled(0.5));
            return translated;
        }
        return null;
    }

    @Override
    public int createAfter(int explicitAnchorIndex, Point mouseInScene) {
        this.checkInitialized();
        this.isNormalizationNeeded = true;
        return super.createAfter(explicitAnchorIndex, mouseInScene);
    }

    @Override
    public int createBefore(int explicitAnchorIndex, Point mouseInScene) {
        this.checkInitialized();
        this.isNormalizationNeeded = true;
        return super.createBefore(explicitAnchorIndex, mouseInScene);
    }

    protected IBendableCurve<? extends Node, ? extends Node> getCurve() {
        return (IBendableCurve)this.getHost().getVisual();
    }

    protected int getExplicitIndex(int startConnectionIndex, int step) {
        if (this.getCurve() instanceof Connection) {
            Connection connection = (Connection)this.getCurve();
            List<IBendableContentPart.BendPoint> bpoints = this.getHost().getVisualBendPoints();
            ObservableList anchors = connection.getAnchorsUnmodifiable();
            IConnectionRouter router = connection.getRouter();
            int atOrBeforeBi = -1;
            int ci = 0;
            int bi = -1;
            while (ci < anchors.size() && bi < bpoints.size()) {
                if (!router.wasInserted((IAnchor)anchors.get(ci))) {
                    ++bi;
                }
                if (ci >= startConnectionIndex) {
                    atOrBeforeBi = bi;
                    break;
                }
                ++ci;
            }
            if (atOrBeforeBi == -1) {
                throw new IllegalStateException("Start of connection is implicit, i.e. inserted by the router.");
            }
            if (step < 0) {
                return atOrBeforeBi;
            }
            if (router.wasInserted((IAnchor)anchors.get(startConnectionIndex))) {
                return atOrBeforeBi + 1;
            }
            return atOrBeforeBi;
        }
        return startConnectionIndex;
    }

    public int getExplicitIndexAtOrAfter(int connectionIndex) {
        return this.getExplicitIndex(connectionIndex, 1);
    }

    public int getExplicitIndexAtOrBefore(int connectionIndex) {
        return this.getExplicitIndex(connectionIndex, -1);
    }

    private int getVisualIndex(int bendPointIndex) {
        if (this.getCurve() instanceof Connection) {
            Connection connection = (Connection)this.getHost().getVisual();
            IConnectionRouter router = connection.getRouter();
            ObservableList anchors = connection.getAnchorsUnmodifiable();
            int ci = 0;
            int bi = 0;
            while (ci < anchors.size()) {
                if (!router.wasInserted((IAnchor)anchors.get(ci))) {
                    if (bi == bendPointIndex) {
                        return ci;
                    }
                    ++bi;
                }
                ++ci;
            }
            throw new IllegalStateException("Cannot find connection index for BendPoint index.");
        }
        return bendPointIndex;
    }

    @Override
    protected Point getVisualPoint(int bendPointIndex) {
        int ci = this.getVisualIndex(bendPointIndex);
        return super.getVisualPoint(ci);
    }

    @Override
    public void init() {
        this.isNormalizationNeeded = false;
        super.init();
    }

    public boolean isExplicit(int connectionIndex) {
        if (this.getCurve() instanceof Connection) {
            Connection connection = (Connection)this.getCurve();
            IAnchor anchor = connection.getAnchor(connectionIndex);
            return !connection.getRouter().wasInserted(anchor);
        }
        return true;
    }

    private boolean isExplicitOverlay(int overlayingExplicitAnchorIndex, int overlainExplicitAnchorIndex) {
        return this.getVisualPoint(overlayingExplicitAnchorIndex).getDistance(this.getVisualPoint(overlainExplicitAnchorIndex)) <= this.getOverlayThreshold();
    }

    public boolean isOrthogonal() {
        boolean isOrtho = this.getCurve() instanceof Connection && ((Connection)this.getCurve()).getRouter() instanceof OrthogonalRouter;
        return isOrtho;
    }

    private boolean isUnpreciseEquals(double y0, double y1) {
        return Math.abs(y0 - y1) < 1.0;
    }

    @Override
    protected void locallyExecuteOperation() {
        try {
            this.getBendOperation().execute(null, null);
        }
        catch (Exception x) {
            throw new IllegalStateException(x);
        }
    }

    public int makeExplicit(int connectionIndex) {
        return this.makeExplicit(connectionIndex, connectionIndex).get(0);
    }

    public List<Integer> makeExplicit(int startConnectionIndex, int endConnectionIndex) {
        this.isNormalizationNeeded = true;
        ArrayList<ImplicitGroup> implicitGroups = new ArrayList<ImplicitGroup>();
        boolean isStartExplicit = this.isExplicit(startConnectionIndex);
        implicitGroups.add(new ImplicitGroup(this.getExplicitIndexAtOrBefore(startConnectionIndex)));
        int i = startConnectionIndex;
        while (i <= endConnectionIndex) {
            if (this.isExplicit(i)) {
                int explicitAnchorHandle = this.getExplicitIndexAtOrBefore(i);
                implicitGroups.add(new ImplicitGroup(explicitAnchorHandle));
            } else {
                Point pointInLocal = this.getCurve().getPoint(i);
                Point pointInScene = NodeUtils.localToScene(this.getHost().getVisual(), (Point)pointInLocal);
                ((ImplicitGroup)implicitGroups.get((int)(implicitGroups.size() - 1))).points.add(pointInScene);
            }
            ++i;
        }
        if (((ImplicitGroup)implicitGroups.get((int)0)).points.isEmpty()) {
            implicitGroups.remove(0);
        }
        int addedCount = 0;
        ArrayList<Integer> handles = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < implicitGroups.size()) {
            ImplicitGroup ig = (ImplicitGroup)implicitGroups.get(i2);
            int prec = ig.precedingExplicitIndex + addedCount;
            if (!handles.isEmpty() || isStartExplicit) {
                handles.add(prec);
            }
            for (Point p : ig.points) {
                prec = this.createAfter(prec, p);
                ++addedCount;
                handles.add(prec);
            }
            ++i2;
        }
        return handles;
    }

    @Override
    public Point move(Point initialMouseInScene, Point currentMouseInScene) {
        this.checkInitialized();
        this.isNormalizationNeeded = true;
        if (this.isOrthogonal()) {
            Point initialMouseInLocal = NodeUtils.sceneToLocal(this.getHost().getVisual(), (Point)initialMouseInScene);
            Point mouseDeltaInLocal = NodeUtils.sceneToLocal(this.getHost().getVisual(), (Point)currentMouseInScene).getTranslated(initialMouseInLocal.getNegated());
            if (this.getOrientation() == Orientation.HORIZONTAL) {
                mouseDeltaInLocal.x = 0.0;
            } else {
                mouseDeltaInLocal.y = 0.0;
            }
            Point translatedMouseInScene = NodeUtils.localToScene(this.getHost().getVisual(), (Point)initialMouseInLocal.getTranslated(mouseDeltaInLocal));
            return super.move(initialMouseInScene, translatedMouseInScene);
        }
        return super.move(initialMouseInScene, currentMouseInScene);
    }

    public void normalize() {
        if (!(this.getCurve() instanceof Connection)) {
            return;
        }
        Connection connection = (Connection)this.getCurve();
        if (!(connection.getRouter() instanceof OrthogonalRouter)) {
            return;
        }
        this.locallyExecuteOperation();
        this.route();
        ObservableList anchors = connection.getAnchorsUnmodifiable();
        ObservableList positions = connection.getPointsUnmodifiable();
        int explicitIndex = 0;
        boolean removed = false;
        int i = 1;
        while (i < anchors.size() - 1) {
            IAnchor anchor = (IAnchor)anchors.get(i);
            if (!connection.getRouter().wasInserted(anchor)) {
                ++explicitIndex;
                Point prev = (Point)positions.get(i - 1);
                Point next = (Point)positions.get(i + 1);
                Point current = (Point)positions.get(i);
                Vector inDirection = new Vector(prev, current);
                Vector outDirection = new Vector(current, next);
                if (inDirection.isNull() || outDirection.isNull() || inDirection.isParallelTo(outDirection)) {
                    Point prevInScene = FX2Geometry.toPoint((Point2D)connection.localToScene(prev.x, prev.y));
                    if (connection.getRouter().wasInserted((IAnchor)anchors.get(i + 1))) {
                        this.makeExplicit(i + 1);
                    }
                    if (connection.getRouter().wasInserted((IAnchor)anchors.get(i - 1))) {
                        this.createBefore(explicitIndex, prevInScene);
                        ++explicitIndex;
                    }
                    this.getBendOperation().getFinalBendPoints().remove(explicitIndex);
                    removed = true;
                    break;
                }
            }
            ++i;
        }
        if (removed) {
            this.normalize();
        }
    }

    @Override
    protected void removeOverlain() {
        if (this.getCurve() instanceof Connection && ((Connection)this.getCurve()).getRouter() instanceof OrthogonalRouter && this.getSelectedIndices().size() == 2) {
            this.removeOverlainSegments();
        } else {
            this.removeOverlainPoints();
        }
        this.route();
    }

    private void removeOverlainPoints() {
        int explicitAnchorsSize = this.getBendOperation().getFinalBendPoints().size();
        int i = this.getSelectedIndices().size() - 1;
        while (i >= 0 && explicitAnchorsSize > 2) {
            boolean isRightOverlain;
            int index = this.getSelectedIndices().get(i);
            boolean isLeftOverlain = index > 0 && this.isExplicitOverlay(index, index - 1);
            boolean bl = isRightOverlain = index < explicitAnchorsSize - 1 && this.isExplicitOverlay(index, index + 1);
            if (isLeftOverlain || isRightOverlain) {
                int overlainIndex;
                int n = overlainIndex = isLeftOverlain ? index - 1 : index + 1;
                if (!this.getSelectedIndices().contains(overlainIndex)) {
                    this.getBendOperation().getFinalBendPoints().remove(index);
                    this.locallyExecuteOperation();
                }
            }
            --i;
        }
    }

    private void removeOverlainSegments() {
        int[][] possibleSegmentOverlays = new int[][]{{-2, -1, 2, 3}, {-2, -1, 2}, {-1, 2, 3}, {-1, 2}, {-2, -1}, {2, 3}, {2}, {-1}};
        boolean removed = false;
        int i = 0;
        while (i < possibleSegmentOverlays.length && !removed) {
            removed = this.testAndRemoveSegmentOverlay(possibleSegmentOverlays[i]);
            ++i;
        }
        if (removed) {
            this.locallyExecuteOperation();
        }
    }

    @Override
    protected void restorePreMoveBendpoints() {
        super.restorePreMoveBendpoints();
        this.setNewHints(this.preMoveStartHint, this.preMoveEndHint);
        this.locallyExecuteOperation();
    }

    protected void route() {
        Point newStartHint = this.computeStartHint();
        Point newEndHint = this.computeEndHint();
        this.setNewHints(newStartHint, newEndHint);
        this.locallyExecuteOperation();
    }

    @Override
    public void select(int explicitAnchorIndex) {
        this.checkInitialized();
        super.select(explicitAnchorIndex);
        this.preMoveStartHint = this.computeStartHint();
        this.preMoveEndHint = this.computeEndHint();
    }

    @Override
    public void selectSegment(int from, int to) {
        List<Integer> explicit = this.makeExplicit(from, to);
        super.selectSegment(explicit.get(0), explicit.get(1));
    }

    protected void setNewHints(Point startHint, Point endHint) {
        List<IBendableContentPart.BendPoint> finalBendPoints = this.getBendOperation().getFinalBendPoints();
        IBendableContentPart.BendPoint bendPoint = finalBendPoints.get(0);
        if (bendPoint.isAttached() && startHint != null) {
            finalBendPoints.set(0, new IBendableContentPart.BendPoint(bendPoint.getContentAnchorage(), startHint));
        }
        if ((bendPoint = finalBendPoints.get(finalBendPoints.size() - 1)).isAttached() && endHint != null) {
            finalBendPoints.set(finalBendPoints.size() - 1, new IBendableContentPart.BendPoint(bendPoint.getContentAnchorage(), endHint));
        }
    }

    private boolean testAndRemoveSegmentOverlay(int[] overlainPointIndicesRelativeToSelection) {
        int numPoints = this.getSelectedIndices().size();
        boolean isSelectionHorizontal = numPoints == 2 && this.isOrthogonal() && this.getOrientation() == Orientation.HORIZONTAL;
        List<Point> points = Arrays.asList(Point.getCopy((Point[])((Point[])this.getCurve().getPointsUnmodifiable().toArray((Object[])new Point[0]))));
        int firstIndex = overlainPointIndicesRelativeToSelection[0];
        int lastIndex = overlainPointIndicesRelativeToSelection[overlainPointIndicesRelativeToSelection.length - 1];
        int selectionStartIndexInConnection = this.getVisualIndex(this.getSelectedIndices().get(0));
        if (selectionStartIndexInConnection + firstIndex < 0 || selectionStartIndexInConnection + firstIndex >= points.size()) {
            return false;
        }
        if (selectionStartIndexInConnection + lastIndex < 0 || selectionStartIndexInConnection + lastIndex >= points.size()) {
            return false;
        }
        ArrayList<Point> overlainPoints = new ArrayList<Point>();
        int i = 0;
        while (i < overlainPointIndicesRelativeToSelection.length) {
            overlainPoints.add(points.get(selectionStartIndexInConnection + overlainPointIndicesRelativeToSelection[i]));
            ++i;
        }
        double p = isSelectionHorizontal ? ((Point)overlainPoints.get((int)0)).y : ((Point)overlainPoints.get((int)0)).x;
        int i2 = 1;
        while (i2 < overlainPoints.size()) {
            Point q = (Point)overlainPoints.get(i2);
            if (isSelectionHorizontal && !this.isUnpreciseEquals(p, q.y) || !isSelectionHorizontal && !this.isUnpreciseEquals(p, q.x)) {
                return false;
            }
            if (isSelectionHorizontal && !this.isUnpreciseEquals(p, q.y) || !isSelectionHorizontal && !this.isUnpreciseEquals(p, q.x)) {
                return false;
            }
            ++i2;
        }
        Point resultStart = (Point)overlainPoints.get(0);
        Point resultEnd = (Point)overlainPoints.get(overlainPoints.size() - 1);
        Point selectionStart = points.get(selectionStartIndexInConnection);
        Point selectionEnd = points.get(selectionStartIndexInConnection + 1);
        double distance = Math.abs(isSelectionHorizontal ? resultStart.y - selectionStart.y : resultStart.x - selectionStart.x);
        if (distance > this.getOverlayThreshold()) {
            return false;
        }
        if (overlainPointIndicesRelativeToSelection.length <= 2) {
            if (isSelectionHorizontal) {
                if (firstIndex < 0) {
                    resultEnd.x = selectionEnd.x;
                } else {
                    resultStart.x = selectionStart.x;
                }
            } else if (firstIndex < 0) {
                resultEnd.y = selectionEnd.y;
            } else {
                resultStart.y = selectionStart.y;
            }
        }
        int overlayStartIndex = Math.min(selectionStartIndexInConnection, selectionStartIndexInConnection + firstIndex);
        int overlayEndIndex = Math.max(selectionStartIndexInConnection + 1, selectionStartIndexInConnection + lastIndex);
        List<Integer> explicit = this.makeExplicit(overlayStartIndex, overlayEndIndex);
        int removedCount = 0;
        int i3 = explicit.size() - 2;
        while (i3 >= 1) {
            this.getBendOperation().getFinalBendPoints().remove(explicit.get(i3));
            ++removedCount;
            --i3;
        }
        Integer resultStartIndex = explicit.get(0);
        IBendableContentPart.BendPoint resultStartAnchor = this.getBendOperation().getFinalBendPoints().get(resultStartIndex);
        if (resultStartIndex > 0 && !resultStartAnchor.isAttached()) {
            this.getBendOperation().getFinalBendPoints().set(resultStartIndex, new IBendableContentPart.BendPoint(resultStart));
        }
        Integer resultEndIndex = explicit.get(explicit.size() - 1) - removedCount;
        IBendableContentPart.BendPoint resultEndAnchor = this.getBendOperation().getFinalBendPoints().get(resultEndIndex);
        if (resultEndIndex < this.getBendOperation().getFinalBendPoints().size() - 1 && !resultEndAnchor.isAttached()) {
            this.getBendOperation().getFinalBendPoints().set(resultEndIndex, new IBendableContentPart.BendPoint(resultEnd));
        }
        return true;
    }

    public String toString() {
        return "BendConnectionPolicy[host=" + this.getHost() + "]";
    }

    private static class ImplicitGroup {
        int precedingExplicitIndex;
        List<Point> points = new ArrayList<Point>();

        public ImplicitGroup(int precedingExplicitIndex) {
            this.precedingExplicitIndex = precedingExplicitIndex;
        }
    }
}

