/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.examples.logo.handlers;

import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.IShape;
import org.eclipse.gef.mvc.examples.logo.MvcLogoExample;
import org.eclipse.gef.mvc.examples.logo.handlers.CreationMenuOnClickHandler;
import org.eclipse.gef.mvc.examples.logo.model.GeometricShape;

public class CreationMenuItemProvider
implements Provider<List<CreationMenuOnClickHandler.ICreationMenuItem>> {
    public List<CreationMenuOnClickHandler.ICreationMenuItem> get() {
        ArrayList<CreationMenuOnClickHandler.ICreationMenuItem> items = new ArrayList<CreationMenuOnClickHandler.ICreationMenuItem>();
        for (GeometricShape shape : MvcLogoExample.createPaletteViewerContents()) {
            items.add(new GeometricShapeItem(shape));
        }
        return items;
    }

    static class GeometricShapeItem
    implements CreationMenuOnClickHandler.ICreationMenuItem {
        private final GeometricShape template;

        public GeometricShapeItem(GeometricShape content) {
            this.template = content;
        }

        @Override
        public Object createContent() {
            return this.template.getCopy();
        }

        @Override
        public Node createVisual() {
            GeometryNode visual = new GeometryNode((IGeometry)((IShape)this.template.getGeometry()));
            visual.setStroke(this.template.getStroke());
            visual.setStrokeWidth(this.template.getStrokeWidth());
            visual.setFill(this.template.getFill());
            visual.setEffect(this.template.getEffect());
            return visual;
        }
    }
}

