/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.dot.internal.parser.validation;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef4.dot.internal.DotAttributes;
import org.eclipse.gef4.dot.internal.parser.conversion.DotTerminalConverters;
import org.eclipse.gef4.dot.internal.parser.dot.AttrStmt;
import org.eclipse.gef4.dot.internal.parser.dot.Attribute;
import org.eclipse.gef4.dot.internal.parser.dot.AttributeType;
import org.eclipse.gef4.dot.internal.parser.dot.DotGraph;
import org.eclipse.gef4.dot.internal.parser.dot.DotPackage;
import org.eclipse.gef4.dot.internal.parser.dot.EdgeOp;
import org.eclipse.gef4.dot.internal.parser.dot.EdgeRhsNode;
import org.eclipse.gef4.dot.internal.parser.dot.EdgeRhsSubgraph;
import org.eclipse.gef4.dot.internal.parser.dot.EdgeStmtNode;
import org.eclipse.gef4.dot.internal.parser.dot.EdgeStmtSubgraph;
import org.eclipse.gef4.dot.internal.parser.dot.GraphType;
import org.eclipse.gef4.dot.internal.parser.dot.NodeStmt;
import org.eclipse.gef4.dot.internal.parser.dot.Subgraph;
import org.eclipse.gef4.dot.internal.parser.validation.AbstractDotJavaValidator;
import org.eclipse.xtext.validation.Check;

public class DotJavaValidator
extends AbstractDotJavaValidator {
    public static final String ATTRIBUTE__INVALID_VALUE__EDGE_STYLE = "ATTRIBUTE__INVALID_VALUE__EDGE_STYLE";
    public static final String ATTRIBUTE__INVALID_VALUE__ARROW_TYPE = "ATTRIBUTE__INVALID_VALUE__ARROW_TYPE";

    @Check
    public void checkValidAttributeValue(Attribute attribute) {
        String unquotedValue;
        if (DotJavaValidator.isEdgeAttribute(attribute) && "style".equals(attribute.getName()) && !DotAttributes.STYLE__E__VALUES.contains(unquotedValue = DotTerminalConverters.unquote(attribute.getValue()))) {
            this.error("Style '" + unquotedValue + "' is not a valid DOT style for Edge.", (EStructuralFeature)DotPackage.eINSTANCE.getAttribute_Value(), ATTRIBUTE__INVALID_VALUE__EDGE_STYLE, new String[]{unquotedValue});
        }
        if (DotJavaValidator.isEdgeAttribute(attribute) && "arrowhead".equals(attribute.getName()) && !DotAttributes.isValidArrowType(unquotedValue = DotTerminalConverters.unquote(attribute.getValue()))) {
            this.error("Arrow Type '" + unquotedValue + "' is not a valid DOT arrowhead for Edge.", (EStructuralFeature)DotPackage.eINSTANCE.getAttribute_Value(), ATTRIBUTE__INVALID_VALUE__ARROW_TYPE, new String[]{unquotedValue});
        }
    }

    public static boolean isNodeAttribute(Attribute attribute) {
        if (DotJavaValidator.getAncestorOfType(attribute, NodeStmt.class) != null) {
            return true;
        }
        AttrStmt attrStmt = DotJavaValidator.getAncestorOfType(attribute, AttrStmt.class);
        return attrStmt != null && AttributeType.NODE.equals((Object)attrStmt.getType());
    }

    public static boolean isSubgraphAttribute(Attribute attribute) {
        if (DotJavaValidator.isEdgeAttribute(attribute) || DotJavaValidator.isNodeAttribute(attribute)) {
            return false;
        }
        return DotJavaValidator.getAncestorOfType(attribute, Subgraph.class) != null;
    }

    public static boolean isRootGraphAttribute(Attribute attribute) {
        return !DotJavaValidator.isEdgeAttribute(attribute) && !DotJavaValidator.isNodeAttribute(attribute) && !DotJavaValidator.isSubgraphAttribute(attribute);
    }

    public static boolean isEdgeAttribute(Attribute attribute) {
        if (DotJavaValidator.getAncestorOfType(attribute, EdgeStmtNode.class) != null || DotJavaValidator.getAncestorOfType(attribute, EdgeStmtSubgraph.class) != null) {
            return true;
        }
        AttrStmt attrStmt = DotJavaValidator.getAncestorOfType(attribute, AttrStmt.class);
        return attrStmt != null && AttributeType.EDGE.equals((Object)attrStmt.getType());
    }

    @Check
    public void checkEdgeOpCorrespondsToGraphType(EdgeRhsNode edgeRhsNode) {
        this.checkEdgeOpCorrespondsToGraphType(edgeRhsNode.getOp(), DotJavaValidator.getAncestorOfType(edgeRhsNode, DotGraph.class).getType());
    }

    @Check
    public void checkEdgeOpCorrespondsToGraphType(EdgeRhsSubgraph edgeRhsSubgraph) {
        this.checkEdgeOpCorrespondsToGraphType(edgeRhsSubgraph.getOp(), DotJavaValidator.getAncestorOfType(edgeRhsSubgraph, DotGraph.class).getType());
    }

    private void checkEdgeOpCorrespondsToGraphType(EdgeOp edgeOp, GraphType graphType) {
        boolean edgeDirected = edgeOp.equals((Object)EdgeOp.DIRECTED);
        boolean graphDirected = graphType.equals((Object)GraphType.DIGRAPH);
        if (graphDirected && !edgeDirected) {
            this.error("EdgeOp '--' may only be used in undirected graphs.", (EStructuralFeature)DotPackage.eINSTANCE.getEdgeRhs_Op());
        } else if (!graphDirected && edgeDirected) {
            this.error("EdgeOp '->' may only be used in directed graphs.", (EStructuralFeature)DotPackage.eINSTANCE.getEdgeRhs_Op());
        }
    }

    private static <T extends EObject> T getAncestorOfType(EObject eObject, Class<T> type) {
        EObject container = eObject.eContainer();
        while (container != null && !type.isAssignableFrom(container.getClass())) {
            container = container.eContainer();
        }
        return (T)container;
    }
}

