/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.ui.parts;

import com.google.inject.Inject;
import com.google.inject.Injector;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.gef4.fx.swt.canvas.IFXCanvasFactory;
import org.eclipse.gef4.mvc.fx.domain.FXDomain;
import org.eclipse.gef4.mvc.fx.ui.parts.SelectionForwarder;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.ui.properties.UndoablePropertySheetPage;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public abstract class AbstractFXEditor
extends EditorPart {
    @Inject
    private FXDomain domain;
    @Inject
    private IFXCanvasFactory canvasFactory;
    @Inject(optional=true)
    private ISelectionProvider selectionProvider;
    private SelectionForwarder<Node> selectionForwarder;
    private FXCanvas canvas = null;
    private UndoRedoActionGroup undoRedoActionGroup;
    private IPropertySheetPage propertySheetPage;
    private IOperationHistoryListener operationHistoryListener;
    private boolean isDirty;

    public AbstractFXEditor(Injector injector) {
        injector.injectMembers((Object)this);
    }

    protected void activate() {
        this.domain.activate();
    }

    protected FXCanvas createCanvas(Composite parent) {
        return this.canvasFactory.createCanvas(parent, 0);
    }

    public void createPartControl(Composite parent) {
        this.canvas = this.createCanvas(parent);
        this.hookViewers();
        this.activate();
    }

    protected void deactivate() {
        this.domain.deactivate();
    }

    public void dispose() {
        this.deactivate();
        this.unhookViewers();
        this.domain.getOperationHistory().removeOperationHistoryListener(this.operationHistoryListener);
        if (this.selectionProvider != null) {
            this.getSite().setSelectionProvider(null);
        }
        this.domain.dispose();
        super.dispose();
    }

    public Object getAdapter(Class key) {
        if (ISelectionProvider.class.equals((Object)key)) {
            return this.selectionProvider;
        }
        if (IPropertySheetPage.class.equals((Object)key)) {
            if (this.propertySheetPage == null) {
                this.propertySheetPage = new UndoablePropertySheetPage((IOperationHistory)this.getAdapter(IOperationHistory.class), (IUndoContext)this.getAdapter(IUndoContext.class), (UndoRedoActionGroup)this.getAdapter(UndoRedoActionGroup.class));
            }
            return this.propertySheetPage;
        }
        if (UndoRedoActionGroup.class.equals((Object)key)) {
            if (this.undoRedoActionGroup == null) {
                this.undoRedoActionGroup = new UndoRedoActionGroup(this.getSite(), (IUndoContext)this.getAdapter(IUndoContext.class), true);
            }
            return this.undoRedoActionGroup;
        }
        if (IUndoContext.class.equals((Object)key)) {
            return this.domain.getUndoContext();
        }
        if (IOperationHistory.class.equals((Object)key)) {
            return this.domain.getOperationHistory();
        }
        return super.getAdapter(key);
    }

    protected FXCanvas getCanvas() {
        return this.canvas;
    }

    protected FXDomain getDomain() {
        return this.domain;
    }

    protected FXViewer getViewer() {
        return (FXViewer)this.domain.getAdapter(FXViewer.class);
    }

    protected void hookViewers() {
        FXViewer contentViewer = this.getViewer();
        this.canvas.setScene(new Scene((Parent)contentViewer.getCanvas()));
        if (this.selectionProvider != null) {
            this.selectionForwarder = new SelectionForwarder(this.selectionProvider, contentViewer);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
        if (this.selectionProvider != null) {
            site.setSelectionProvider(this.selectionProvider);
        }
        this.operationHistoryListener = new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                IUndoableOperation operation = event.getOperation();
                if (event.getEventType() == 5 && event.getHistory().getUndoHistory(operation.getContexts()[0]).length > 0 && (!(operation instanceof ITransactionalOperation) || ((ITransactionalOperation)operation).isContentRelevant())) {
                    AbstractFXEditor.this.setDirty(true);
                }
            }
        };
        this.getDomain().getOperationHistory().addOperationHistoryListener(this.operationHistoryListener);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void setDirty(boolean isDirty) {
        if (this.isDirty != isDirty) {
            this.isDirty = isDirty;
            this.firePropertyChange(257);
        }
    }

    public void setFocus() {
        this.canvas.setFocus();
    }

    protected void unhookViewers() {
        if (this.selectionForwarder != null) {
            this.selectionForwarder.dispose();
            this.selectionForwarder = null;
        }
    }
}

