/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.ui.parts;

import com.google.inject.Inject;
import com.google.inject.Injector;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.gef4.fx.swt.canvas.IFXCanvasFactory;
import org.eclipse.gef4.mvc.fx.domain.FXDomain;
import org.eclipse.gef4.mvc.fx.ui.parts.DeleteActionHandler;
import org.eclipse.gef4.mvc.fx.ui.parts.SelectionForwarder;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.ui.properties.UndoablePropertySheetPage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public abstract class AbstractFXView
extends ViewPart {
    @Inject
    private FXDomain domain;
    @Inject
    private IFXCanvasFactory canvasFactory;
    @Inject(optional=true)
    private ISelectionProvider selectionProvider;
    private SelectionForwarder<Node> selectionForwarder;
    private FXCanvas canvas = null;
    private UndoRedoActionGroup undoRedoActionGroup;
    private DeleteActionHandler deleteActionHandler;
    private IPropertySheetPage propertySheetPage;

    public AbstractFXView(Injector injector) {
        injector.injectMembers((Object)this);
    }

    protected void activate() {
        this.domain.activate();
    }

    protected FXCanvas createCanvas(Composite parent) {
        return this.canvasFactory.createCanvas(parent, 0);
    }

    public void createPartControl(Composite parent) {
        this.canvas = this.createCanvas(parent);
        this.hookViewers();
        this.activate();
    }

    protected void deactivate() {
        this.domain.deactivate();
    }

    public void dispose() {
        this.deactivate();
        this.unhookViewers();
        if (this.selectionProvider != null) {
            this.getSite().setSelectionProvider(null);
        }
        this.deleteActionHandler.init(null);
        this.domain.dispose();
        super.dispose();
    }

    public Object getAdapter(Class key) {
        if (ISelectionProvider.class.equals((Object)key)) {
            return this.selectionProvider;
        }
        if (IPropertySheetPage.class.equals((Object)key)) {
            if (this.propertySheetPage == null) {
                this.propertySheetPage = new UndoablePropertySheetPage((IOperationHistory)this.getAdapter(IOperationHistory.class), (IUndoContext)this.getAdapter(IUndoContext.class), (UndoRedoActionGroup)this.getAdapter(UndoRedoActionGroup.class));
            }
            return this.propertySheetPage;
        }
        if (UndoRedoActionGroup.class.equals((Object)key)) {
            if (this.undoRedoActionGroup == null) {
                this.undoRedoActionGroup = new UndoRedoActionGroup(this.getSite(), (IUndoContext)this.getAdapter(IUndoContext.class), true);
            }
            return this.undoRedoActionGroup;
        }
        if (IUndoContext.class.equals((Object)key)) {
            return this.domain.getUndoContext();
        }
        if (IOperationHistory.class.equals((Object)key)) {
            return this.domain.getOperationHistory();
        }
        return super.getAdapter(key);
    }

    protected FXCanvas getCanvas() {
        return this.canvas;
    }

    protected FXDomain getDomain() {
        return this.domain;
    }

    protected FXViewer getViewer() {
        return (FXViewer)this.domain.getAdapter(FXViewer.class);
    }

    protected void hookViewers() {
        FXViewer contentViewer = this.getViewer();
        this.canvas.setScene(new Scene((Parent)contentViewer.getCanvas()));
        if (this.selectionProvider != null) {
            this.selectionForwarder = new SelectionForwarder(this.selectionProvider, contentViewer);
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        UndoRedoActionGroup undoRedoActionGroup = (UndoRedoActionGroup)this.getAdapter(UndoRedoActionGroup.class);
        if (undoRedoActionGroup != null) {
            undoRedoActionGroup.fillActionBars(site.getActionBars());
        }
        this.deleteActionHandler = new DeleteActionHandler();
        this.deleteActionHandler.init(this.getViewer());
        site.getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteActionHandler);
        if (this.selectionProvider != null) {
            site.setSelectionProvider(this.selectionProvider);
        }
    }

    public void setFocus() {
        this.canvas.setFocus();
    }

    protected void unhookViewers() {
        if (this.selectionForwarder != null) {
            this.selectionForwarder.dispose();
            this.selectionForwarder = null;
        }
    }
}

