/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.eclipse.gef4.layout.IEdgeLayout;
import org.eclipse.gef4.layout.ILayoutAlgorithm;
import org.eclipse.gef4.layout.ILayoutContext;
import org.eclipse.gef4.layout.ILayoutFilter;
import org.eclipse.gef4.layout.INodeLayout;

public abstract class AbstractLayoutContext
implements ILayoutContext {
    private ObjectProperty<ILayoutAlgorithm> layoutAlgorithmProperty = new SimpleObjectProperty((Object)this, "layoutAlgorithm");
    private final List<INodeLayout> layoutNodes = new ArrayList<INodeLayout>();
    private final List<IEdgeLayout> layoutEdges = new ArrayList<IEdgeLayout>();
    private final List<Runnable> postLayoutPass = new ArrayList<Runnable>();
    private final List<Runnable> preLayoutPass = new ArrayList<Runnable>();
    private final List<ILayoutFilter> layoutFilters = new ArrayList<ILayoutFilter>();

    protected void addEdge(IEdgeLayout edge) {
        this.layoutEdges.add(edge);
    }

    @Override
    public void addLayoutFilter(ILayoutFilter layoutFilter) {
        this.layoutFilters.add(layoutFilter);
    }

    protected void addNode(INodeLayout node) {
        this.layoutNodes.add(node);
    }

    @Override
    public void applyLayout(boolean clear) {
        ILayoutAlgorithm layoutAlgorithm = (ILayoutAlgorithm)this.layoutAlgorithmProperty.get();
        if (layoutAlgorithm != null) {
            for (Runnable r : this.preLayoutPass) {
                r.run();
            }
            layoutAlgorithm.setLayoutContext(this);
            layoutAlgorithm.applyLayout(clear);
        }
    }

    protected void clearEdges() {
        for (IEdgeLayout edge : new ArrayList<IEdgeLayout>(this.layoutEdges)) {
            this.removeEdge(edge);
        }
    }

    protected void clearNodes() {
        for (INodeLayout node : new ArrayList<INodeLayout>(this.layoutNodes)) {
            this.removeNode(node);
        }
    }

    @Override
    public void flushChanges() {
        ILayoutAlgorithm layoutAlgorithm = (ILayoutAlgorithm)this.layoutAlgorithmProperty.get();
        if (layoutAlgorithm != null) {
            for (Runnable r : new ArrayList<Runnable>(this.postLayoutPass)) {
                r.run();
            }
        }
    }

    @Override
    public IEdgeLayout[] getEdges() {
        return this.layoutEdges.toArray(new IEdgeLayout[0]);
    }

    @Override
    public IEdgeLayout[] getConnections(INodeLayout layoutEntity1, INodeLayout layoutEntity2) {
        IEdgeLayout c;
        ArrayList<IEdgeLayout> connections = new ArrayList<IEdgeLayout>();
        IEdgeLayout[] iEdgeLayoutArray = layoutEntity1.getOutgoingConnections();
        int n = iEdgeLayoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = iEdgeLayoutArray[n2];
            if (c.getTarget() == layoutEntity2) {
                connections.add(c);
            }
            ++n2;
        }
        iEdgeLayoutArray = layoutEntity2.getOutgoingConnections();
        n = iEdgeLayoutArray.length;
        n2 = 0;
        while (n2 < n) {
            c = iEdgeLayoutArray[n2];
            if (c.getTarget() == layoutEntity1) {
                connections.add(c);
            }
            ++n2;
        }
        return connections.toArray(new IEdgeLayout[0]);
    }

    @Override
    public INodeLayout[] getNodes() {
        return this.layoutNodes.toArray(new INodeLayout[0]);
    }

    @Override
    public ILayoutAlgorithm getLayoutAlgorithm() {
        return (ILayoutAlgorithm)this.layoutAlgorithmProperty.get();
    }

    @Override
    public boolean isLayoutIrrelevant(IEdgeLayout connLayout) {
        for (ILayoutFilter filter : this.layoutFilters) {
            if (!filter.isLayoutIrrelevant(connLayout)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLayoutIrrelevant(INodeLayout nodeLayout) {
        for (ILayoutFilter filter : this.layoutFilters) {
            if (!filter.isLayoutIrrelevant(nodeLayout)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ObjectProperty<ILayoutAlgorithm> layoutAlgorithmProperty() {
        return this.layoutAlgorithmProperty;
    }

    protected void removeEdge(IEdgeLayout edge) {
        this.layoutEdges.remove(edge);
    }

    @Override
    public void removeLayoutFilter(ILayoutFilter layoutFilter) {
        this.layoutFilters.remove(layoutFilter);
    }

    protected void removeNode(INodeLayout node) {
        this.layoutNodes.remove(node);
    }

    @Override
    public void schedulePostLayoutPass(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable may not be null.");
        }
        if (!this.postLayoutPass.contains(runnable)) {
            this.postLayoutPass.add(runnable);
        }
    }

    @Override
    public void schedulePreLayoutPass(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable may not be null.");
        }
        if (!this.preLayoutPass.contains(runnable)) {
            this.preLayoutPass.add(runnable);
        }
    }

    @Override
    public void setLayoutAlgorithm(ILayoutAlgorithm newLayoutAlgorithm) {
        this.layoutAlgorithmProperty.set((Object)newLayoutAlgorithm);
    }

    @Override
    public void unschedulePostLayoutPass(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable may not be null.");
        }
        if (this.postLayoutPass.contains(runnable)) {
            this.postLayoutPass.remove(runnable);
        }
    }

    @Override
    public void unschedulePreLayoutPass(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable may not be null.");
        }
        if (this.preLayoutPass.contains(runnable)) {
            this.preLayoutPass.remove(runnable);
        }
    }
}

