/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout;

import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.layout.IEdgeLayout;
import org.eclipse.gef4.layout.ILayoutContext;
import org.eclipse.gef4.layout.INodeLayout;

public class LayoutProperties {
    public static final String BOUNDS_PROPERTY = "layout_bounds";
    public static final Rectangle DEFAULT_BOUNDS = new Rectangle();
    public static final String LOCATION_PROPERTY = "layout_location";
    public static final Point DEFAULT_LOCATION = new Point();
    public static final String SIZE_PROPERTY = "layout_size";
    public static final Dimension DEFAULT_SIZE = new Dimension();
    public static final String MOVABLE_PROPERTY = "layout_movable";
    public static final Boolean DEFAULT_MOVABLE = true;
    public static final String RESIZABLE_PROPERTY = "layout_resizable";
    public static final Boolean DEFAULT_RESIZABLE = true;
    public static final String ASPECT_RATIO_PROPERTY = "layout_aspect-ratio";
    public static final Double DEFAULT_ASPECT_RATIO = 0.0;
    public static final String WEIGHT_PROPERTY = "layout_weight";
    public static final Double DEFAULT_WEIGHT = 0.0;
    public static final int DIRECTION_TOP_DOWN = 1;
    public static final int DIRECTION_BOTTOM_UP = 2;
    public static final int DIRECTION_LEFT_RIGHT = 3;
    public static final int DIRECTION_RIGHT_LEFT = 4;
    public static final String DIRECTION_PROPERTY = "layout_direction";
    public static final Integer DEFAULT_DIRECTION = 1;

    public static Rectangle getBounds(ILayoutContext context) {
        Object bounds = context.getAttributes().get((Object)BOUNDS_PROPERTY);
        if (bounds instanceof Rectangle) {
            return ((Rectangle)bounds).getCopy();
        }
        return DEFAULT_BOUNDS.getCopy();
    }

    public static void setBounds(ILayoutContext context, Rectangle bounds) {
        context.getAttributes().put((Object)BOUNDS_PROPERTY, (Object)bounds);
    }

    public static Point getLocation(INodeLayout node) {
        Object location = node.getAttributes().get((Object)LOCATION_PROPERTY);
        if (location instanceof Point) {
            return ((Point)location).getCopy();
        }
        return DEFAULT_LOCATION.getCopy();
    }

    public static Dimension getSize(INodeLayout node) {
        Object size = node.getAttributes().get((Object)SIZE_PROPERTY);
        if (size instanceof Dimension) {
            return ((Dimension)size).getCopy();
        }
        return DEFAULT_SIZE.getCopy();
    }

    public static Double getPreferredAspectRatio(INodeLayout node) {
        Object ar = node.getAttributes().get((Object)ASPECT_RATIO_PROPERTY);
        if (ar instanceof Double) {
            return (Double)ar;
        }
        return DEFAULT_ASPECT_RATIO;
    }

    public static Boolean isResizable(INodeLayout node) {
        Object resizable = node.getAttributes().get((Object)RESIZABLE_PROPERTY);
        if (resizable instanceof Boolean) {
            return (Boolean)resizable;
        }
        return DEFAULT_RESIZABLE;
    }

    public static Boolean isMovable(INodeLayout node) {
        Object movable = node.getAttributes().get((Object)MOVABLE_PROPERTY);
        if (movable instanceof Boolean) {
            return (Boolean)movable;
        }
        return DEFAULT_MOVABLE;
    }

    public static void setLocation(INodeLayout node, double x, double y) {
        if (Double.isNaN(x)) {
            x = 0.0;
        }
        if (Double.isNaN(y)) {
            y = 0.0;
        }
        node.getAttributes().put((Object)LOCATION_PROPERTY, (Object)new Point(x, y));
    }

    public static void setSize(INodeLayout node, double w, double h) {
        if (Double.isNaN(w)) {
            w = 0.0;
        }
        if (Double.isNaN(h)) {
            h = 0.0;
        }
        node.getAttributes().put((Object)SIZE_PROPERTY, (Object)new Dimension(w, h));
    }

    public static void setResizable(INodeLayout node, boolean resizable) {
        node.getAttributes().put((Object)RESIZABLE_PROPERTY, (Object)resizable);
    }

    public static Double getWeight(IEdgeLayout edge) {
        Object weight = edge.getAttributes().get((Object)WEIGHT_PROPERTY);
        if (weight instanceof Double) {
            return (Double)weight;
        }
        return DEFAULT_WEIGHT;
    }

    public static void setWeight(IEdgeLayout edge, double weight) {
        edge.getAttributes().put((Object)WEIGHT_PROPERTY, (Object)weight);
    }
}

