/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.layout.ILayoutAlgorithm;
import org.eclipse.gef4.layout.ILayoutContext;
import org.eclipse.gef4.layout.INodeLayout;
import org.eclipse.gef4.layout.LayoutProperties;
import org.eclipse.gef4.layout.algorithms.AlgorithmHelper;
import org.eclipse.gef4.layout.algorithms.TreeLayoutAlgorithm;

public class RadialLayoutAlgorithm
implements ILayoutAlgorithm {
    private static final double MAX_DEGREES = Math.PI * 2;
    private double startDegree = 0.0;
    private double endDegree = Math.PI * 2;
    private ILayoutContext context;
    private boolean resize = false;
    private TreeLayoutAlgorithm treeLayout = new TreeLayoutAlgorithm();

    @Override
    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        this.treeLayout.internalApplyLayout();
        INodeLayout[] entities = this.context.getNodes();
        Rectangle bounds = LayoutProperties.getBounds(this.context);
        this.computeRadialPositions(entities, bounds);
        if (this.resize) {
            AlgorithmHelper.maximizeSizes(entities);
        }
        int insets = 4;
        bounds.setX(bounds.getX() + (double)insets);
        bounds.setY(bounds.getY() + (double)insets);
        bounds.setWidth(bounds.getWidth() - (double)(2 * insets));
        bounds.setHeight(bounds.getHeight() - (double)(2 * insets));
        AlgorithmHelper.fitWithinBounds(entities, bounds, this.resize);
    }

    private void computeRadialPositions(INodeLayout[] entities, Rectangle bounds) {
        Rectangle layoutBounds = AlgorithmHelper.getLayoutBounds(entities, false);
        layoutBounds.setX(bounds.getX());
        layoutBounds.setWidth(bounds.getWidth());
        int i = 0;
        while (i < entities.length) {
            Point location = LayoutProperties.getLocation(entities[i]);
            double percenttheta = (location.x - layoutBounds.getX()) / layoutBounds.getWidth();
            double distance = (location.y - layoutBounds.getY()) / layoutBounds.getHeight();
            double theta = this.startDegree + Math.abs(this.endDegree - this.startDegree) * percenttheta;
            location.x = distance * Math.cos(theta);
            location.y = distance * Math.sin(theta);
            LayoutProperties.setLocation(entities[i], location.x, location.y);
            ++i;
        }
    }

    @Override
    public void setLayoutContext(ILayoutContext context) {
        this.context = context;
        this.treeLayout.setLayoutContext(context);
    }

    @Override
    public ILayoutContext getLayoutContext() {
        return this.context;
    }

    public void setRangeToLayout(double startDegree, double endDegree) {
        this.startDegree = startDegree;
        this.endDegree = endDegree;
    }

    public boolean isResizing() {
        return this.resize;
    }

    public void setResizing(boolean resizing) {
        this.resize = resizing;
        this.treeLayout.setResizing(this.resize);
    }
}

