/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.layout.IEdgeLayout;
import org.eclipse.gef4.layout.ILayoutAlgorithm;
import org.eclipse.gef4.layout.ILayoutContext;
import org.eclipse.gef4.layout.INodeLayout;
import org.eclipse.gef4.layout.LayoutProperties;

public class SugiyamaLayoutAlgorithm
implements ILayoutAlgorithm {
    private List<List<NodeWrapper>> layers = new ArrayList<List<NodeWrapper>>();
    private Map<INodeLayout, NodeWrapper> map = new IdentityHashMap<INodeLayout, NodeWrapper>();
    private final Direction direction;
    private final Dimension dimension;
    private ILayoutContext context;
    private int last;
    private LayerProvider layerProvider;
    private CrossingReducer crossingReducer;

    public SugiyamaLayoutAlgorithm(Direction dir, Dimension dim, LayerProvider layering, CrossingReducer crossing) {
        this.direction = dir;
        this.dimension = dim;
        this.layerProvider = layering == null ? new SimpleLayerProvider() : layering;
        this.crossingReducer = crossing == null ? new BarycentricCrossingReducer() : crossing;
    }

    public SugiyamaLayoutAlgorithm(Direction dir, LayerProvider layerProvider, CrossingReducer crossing) {
        this(dir, null, layerProvider, crossing);
    }

    public SugiyamaLayoutAlgorithm(Direction dir, LayerProvider layerProvider) {
        this(dir, null, layerProvider, new BarycentricCrossingReducer());
    }

    public SugiyamaLayoutAlgorithm(Direction dir, CrossingReducer crossing) {
        this(dir, null, null, crossing);
    }

    public SugiyamaLayoutAlgorithm(Direction dir, Dimension dim) {
        this(dir, dim, null, null);
    }

    public SugiyamaLayoutAlgorithm(Direction dir) {
        this(dir, null, null, null);
    }

    public SugiyamaLayoutAlgorithm() {
        this(Direction.VERTICAL, null, null, null);
    }

    @Override
    public void setLayoutContext(ILayoutContext context) {
        this.context = context;
    }

    @Override
    public ILayoutContext getLayoutContext() {
        return this.context;
    }

    @Override
    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        this.layers.clear();
        this.map.clear();
        ArrayList<INodeLayout> nodes = new ArrayList<INodeLayout>();
        ArrayList<INodeLayout> nodes2 = new ArrayList<INodeLayout>();
        INodeLayout[] iNodeLayoutArray = this.context.getNodes();
        int n = iNodeLayoutArray.length;
        int n2 = 0;
        while (n2 < n) {
            INodeLayout node = iNodeLayoutArray[n2];
            nodes.add(node);
            nodes2.add(node);
            ++n2;
        }
        this.layers = this.layerProvider.calculateLayers(nodes);
        this.crossingReducer.crossReduction(this.layers);
        for (List<NodeWrapper> layer : this.layers) {
            if (layer.size() > this.last) {
                this.last = layer.size();
            }
            for (NodeWrapper nw : layer) {
                this.map.put(nw.node, nw);
            }
        }
        this.calculatePositions();
    }

    private void calculatePositions() {
        Rectangle boundary = LayoutProperties.getBounds(this.context);
        if (this.dimension != null) {
            boundary = new Rectangle(0.0, 0.0, this.dimension.getWidth(), this.dimension.getHeight());
        }
        double dx = boundary.getWidth() / (double)this.layers.size();
        double dy = boundary.getHeight() / (double)(this.last + 1);
        if (this.direction == Direction.HORIZONTAL) {
            INodeLayout[] iNodeLayoutArray = this.context.getNodes();
            int n = iNodeLayoutArray.length;
            int n2 = 0;
            while (n2 < n) {
                INodeLayout node = iNodeLayoutArray[n2];
                NodeWrapper nw = this.map.get(node);
                LayoutProperties.setLocation(node, ((double)nw.layer + 0.5) * dx, ((double)nw.index + 0.5) * dy);
                ++n2;
            }
        } else {
            INodeLayout[] iNodeLayoutArray = this.context.getNodes();
            int n = iNodeLayoutArray.length;
            int n3 = 0;
            while (n3 < n) {
                INodeLayout node = iNodeLayoutArray[n3];
                NodeWrapper nw = this.map.get(node);
                LayoutProperties.setLocation(node, ((double)nw.index + 0.5) * dx, ((double)nw.layer + 0.5) * dy);
                ++n3;
            }
        }
    }

    public static class BarycentricCrossingReducer
    implements CrossingReducer {
        private List<List<NodeWrapper>> layers = new ArrayList<List<NodeWrapper>>();
        private Map<INodeLayout, NodeWrapper> map = new IdentityHashMap<INodeLayout, NodeWrapper>();
        private static final int MAX_SWEEPS = 35;
        private int last;

        private void padLayers() {
            this.last = 0;
            for (List<NodeWrapper> iter : this.layers) {
                if (iter.size() <= this.last) continue;
                this.last = iter.size();
            }
            --this.last;
            for (List<NodeWrapper> iter : this.layers) {
                int i = iter.size();
                while (i <= this.last) {
                    iter.add(new NodeWrapper());
                    ++i;
                }
                this.updateIndex(iter);
            }
        }

        private void unpadLayers() {
            for (List<NodeWrapper> layer : this.layers) {
                Iterator<NodeWrapper> it = layer.iterator();
                while (it.hasNext()) {
                    NodeWrapper wrapper = it.next();
                    if (!wrapper.isPadding()) continue;
                    it.remove();
                }
            }
        }

        private void reduceCrossings() {
            int round = 0;
            while (round < 35) {
                int index;
                if ((round & 1) == 0) {
                    index = 1;
                    while (index < this.layers.size()) {
                        this.reduceCrossingsDown(this.layers.get(index));
                        ++index;
                    }
                } else {
                    index = this.layers.size() - 2;
                    while (index >= 0) {
                        this.reduceCrossingsUp(this.layers.get(index));
                        --index;
                    }
                }
                ++round;
            }
        }

        private void reduceCrossingsDown(List<NodeWrapper> layer) {
            for (NodeWrapper node : layer) {
                node.index = node.getBaryCenter(node.pred);
            }
            Collections.sort(layer, new Comparator<NodeWrapper>(){

                @Override
                public int compare(NodeWrapper node1, NodeWrapper node2) {
                    return node1.index - node2.index;
                }
            });
            this.updateIndex(layer);
        }

        private void reduceCrossingsUp(List<NodeWrapper> layer) {
            for (NodeWrapper node : layer) {
                node.index = node.getBaryCenter(node.succ);
            }
            Collections.sort(layer, new Comparator<NodeWrapper>(){

                @Override
                public int compare(NodeWrapper node1, NodeWrapper node2) {
                    return node1.index - node2.index;
                }
            });
            this.updateIndex(layer);
        }

        private void refineLayers() {
            int index = 1;
            while (index < this.layers.size()) {
                this.refineLayersDown(this.layers.get(index));
                ++index;
            }
            index = this.layers.size() - 2;
            while (index >= 0) {
                this.refineLayersUp(this.layers.get(index));
                --index;
            }
            index = 1;
            while (index < this.layers.size()) {
                this.refineLayersDown(this.layers.get(index));
                ++index;
            }
        }

        private void refineLayersDown(List<NodeWrapper> layer) {
            ArrayList<NodeWrapper> list = new ArrayList<NodeWrapper>(layer);
            Collections.sort(list, new Comparator<NodeWrapper>(){

                @Override
                public int compare(NodeWrapper node1, NodeWrapper node2) {
                    return node2.getPriorityDown() - node1.getPriorityDown();
                }
            });
            for (NodeWrapper iter : list) {
                if (iter.isPadding()) break;
                int delta = iter.getBaryCenter(iter.pred) - iter.index;
                int i = 0;
                while (i < delta) {
                    layer.add(iter.index, layer.remove(this.last));
                    ++i;
                }
            }
            this.updateIndex(layer);
        }

        private void refineLayersUp(List<NodeWrapper> layer) {
            ArrayList<NodeWrapper> list = new ArrayList<NodeWrapper>(layer);
            Collections.sort(list, new Comparator<NodeWrapper>(){

                @Override
                public int compare(NodeWrapper node1, NodeWrapper node2) {
                    return node2.getPriorityUp() - node1.getPriorityUp();
                }
            });
            for (NodeWrapper iter : list) {
                if (iter.isPadding()) break;
                int delta = iter.getBaryCenter(iter.succ) - iter.index;
                int i = 0;
                while (i < delta) {
                    layer.add(iter.index, layer.remove(this.last));
                    ++i;
                }
            }
            this.updateIndex(layer);
        }

        private void updateIndex(List<NodeWrapper> list) {
            int index = 0;
            while (index < list.size()) {
                list.get((int)index).index = index;
                this.map.put(list.get((int)index).node, list.get(index));
                ++index;
            }
        }

        @Override
        public void crossReduction(List<List<NodeWrapper>> nodes) {
            this.layers = nodes;
            this.padLayers();
            int i = 0;
            while (i < this.layers.size()) {
                this.reduceCrossings();
                this.refineLayers();
                ++i;
            }
            this.reduceCrossings();
            this.unpadLayers();
        }
    }

    public static interface CrossingReducer {
        public void crossReduction(List<List<NodeWrapper>> var1);
    }

    public static class DFSLayerProvider
    implements LayerProvider {
        private Map<INodeLayout, Integer> assignedNodes = new IdentityHashMap<INodeLayout, Integer>();

        private List<IEdgeLayout> intersectOfConnections(IEdgeLayout[] a, IEdgeLayout[] b) {
            ArrayList<IEdgeLayout> res = new ArrayList<IEdgeLayout>();
            int i = 0;
            while (i < a.length) {
                int j = 0;
                while (j < b.length) {
                    if (a[i].equals(b[j])) {
                        res.add(a[i]);
                    }
                    ++j;
                }
                ++i;
            }
            return res;
        }

        private void addToInitClosedList(INodeLayout node, int layout, List<INodeLayout> initClosedList, Map<INodeLayout, NodeWrapper> map) {
            NodeWrapper nw = new NodeWrapper(node, layout);
            map.put(node, nw);
            initClosedList.add(node);
        }

        public ArrayList<INodeLayout> getRoots(List<INodeLayout> nodes) {
            ArrayList<INodeLayout> res = new ArrayList<INodeLayout>();
            for (INodeLayout node : nodes) {
                if (node.getIncomingConnections().length == 0) {
                    res.add(node);
                    continue;
                }
                int sizeOfIntersect = this.intersectOfConnections(node.getIncomingConnections(), node.getOutgoingConnections()).size();
                if (node.getOutgoingConnections().length > sizeOfIntersect) {
                    res.add(node);
                }
                if (node.getIncomingConnections().length != sizeOfIntersect || node.getOutgoingConnections().length != sizeOfIntersect) continue;
                res.add(node);
            }
            if (res.size() == 0) {
                res.add(nodes.get(0));
            }
            return res;
        }

        public Map<INodeLayout, Integer> getAssignedNodes() {
            return this.assignedNodes;
        }

        public void addAssignedNode(INodeLayout node, int layer) {
            this.assignedNodes.put(node, layer);
        }

        public void clearAssignedNodes() {
            this.assignedNodes.clear();
        }

        private static void updateIndex(List<NodeWrapper> list) {
            int index = 0;
            while (index < list.size()) {
                list.get((int)index).index = index;
                ++index;
            }
        }

        private void addLayer(List<INodeLayout> list, List<List<NodeWrapper>> layers, Map<INodeLayout, NodeWrapper> map) {
            ArrayList<NodeWrapper> layer = new ArrayList<NodeWrapper>(list.size());
            for (INodeLayout node : list) {
                NodeWrapper nw = new NodeWrapper(node, layers.size());
                map.put(node, nw);
                layer.add(nw);
            }
            layers.add(layer);
            DFSLayerProvider.updateIndex(layer);
        }

        private ArrayList<INodeLayout> Unfold(INodeLayout toUnfold, Set<INodeLayout> openedList, Set<INodeLayout> closedList) {
            INodeLayout endPoint;
            ArrayList<INodeLayout> res = new ArrayList<INodeLayout>();
            int i = 0;
            while (i < toUnfold.getOutgoingConnections().length) {
                endPoint = toUnfold.getOutgoingConnections()[i].getTarget();
                if (endPoint.equals(toUnfold)) {
                    endPoint = toUnfold.getOutgoingConnections()[i].getSource();
                }
                if (!(closedList.contains(endPoint) || openedList.contains(endPoint) || res.contains(endPoint))) {
                    res.add(endPoint);
                }
                ++i;
            }
            i = 0;
            while (i < toUnfold.getIncomingConnections().length) {
                endPoint = toUnfold.getIncomingConnections()[i].getTarget();
                if (endPoint.equals(toUnfold)) {
                    endPoint = toUnfold.getIncomingConnections()[i].getSource();
                }
                if (!(closedList.contains(endPoint) || openedList.contains(endPoint) || res.contains(endPoint))) {
                    res.add(endPoint);
                }
                ++i;
            }
            return res;
        }

        /*
         * Exception decompiling
         */
        @Override
        public List<List<NodeWrapper>> calculateLayers(List<INodeLayout> nodeLayouts) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }

    public static class GreedyCrossingReducer
    implements CrossingReducer {
        private final Map<INodeLayout, NodeWrapper> map = new IdentityHashMap<INodeLayout, NodeWrapper>();
        private List<List<NodeWrapper>> layers = new ArrayList<List<NodeWrapper>>();
        private Map<Integer, Integer> crossesForLayers = new IdentityHashMap<Integer, Integer>();

        private ArrayList<INodeLayout> unionOfNodes(INodeLayout[] a, INodeLayout[] b) {
            ArrayList<INodeLayout> res = new ArrayList<INodeLayout>();
            int i = 0;
            while (i < a.length) {
                res.add(a[i]);
                ++i;
            }
            i = 0;
            while (i < b.length) {
                if (!res.contains(b[i])) {
                    res.add(b[i]);
                }
                ++i;
            }
            return res;
        }

        private int numberOfCrosses(NodeWrapper nodeA, NodeWrapper nodeB) {
            int numOfCrosses = 0;
            if (nodeA.equals(nodeB)) {
                return 0;
            }
            ArrayList<INodeLayout> adjacentNodesOfA = this.unionOfNodes(nodeA.node.getPredecessingNodes(), nodeA.node.getSuccessingNodes());
            ArrayList<INodeLayout> adjacentNodesOfB = this.unionOfNodes(nodeB.node.getPredecessingNodes(), nodeB.node.getSuccessingNodes());
            for (INodeLayout aNode : adjacentNodesOfA) {
                ArrayList<Integer> alreadyCrossed = new ArrayList<Integer>();
                NodeWrapper aNodeWrapper = this.map.get(aNode);
                int i = 0;
                while (i < adjacentNodesOfB.size()) {
                    NodeWrapper nw = this.map.get(adjacentNodesOfB.get(i));
                    if (!alreadyCrossed.contains(i) && nw != null && (nw.layer > nodeA.layer && aNodeWrapper.layer > nodeA.layer || nw.layer < nodeA.layer && aNodeWrapper.layer < nodeA.layer)) {
                        if (nodeA.index < nodeB.index) {
                            if (aNodeWrapper.index > nw.index) {
                                ++numOfCrosses;
                                alreadyCrossed.add(i);
                            } else if (nw.index == aNodeWrapper.index) {
                                if (nodeA.index >= nw.index) {
                                    if (aNodeWrapper.layer > nw.layer && nodeA.layer < nw.layer || aNodeWrapper.layer < nw.layer && nw.layer < nodeA.layer) {
                                        ++numOfCrosses;
                                        alreadyCrossed.add(i);
                                    }
                                } else if (nodeB.index <= nw.index && (aNodeWrapper.layer > nw.layer && aNodeWrapper.layer < nodeB.layer || aNodeWrapper.layer < nw.layer && aNodeWrapper.layer > nodeB.layer)) {
                                    ++numOfCrosses;
                                    alreadyCrossed.add(i);
                                }
                            }
                        } else if (nodeA.index > nodeB.index) {
                            if (aNodeWrapper.index < nw.index) {
                                ++numOfCrosses;
                                alreadyCrossed.add(i);
                            } else if (nw.index == aNodeWrapper.index) {
                                if (nodeB.index >= nw.index) {
                                    if (aNodeWrapper.layer > nw.layer && nodeB.layer > aNodeWrapper.layer || aNodeWrapper.layer < nw.layer && aNodeWrapper.layer > nodeB.layer) {
                                        ++numOfCrosses;
                                        alreadyCrossed.add(i);
                                    }
                                } else if (nodeA.index <= nw.index && (aNodeWrapper.layer > nw.layer && nw.layer > nodeA.layer || aNodeWrapper.layer < nw.layer && nw.layer < nodeA.layer)) {
                                    ++numOfCrosses;
                                    alreadyCrossed.add(i);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            return numOfCrosses;
        }

        private boolean greedyHeuristic(List<NodeWrapper> layer) {
            boolean res = false;
            if (layer.size() > 1) {
                int i = 0;
                while (i < layer.size() - 1) {
                    int num2;
                    int num1;
                    if (!(layer.get((int)i).node == null || layer.get((int)(i + 1)).node == null || (num1 = this.numberOfCrosses(layer.get(i), layer.get(i + 1))) <= (num2 = this.numberOfCrosses(layer.get(i + 1), layer.get(i))) && (num1 != num2 || num1 <= 0) || this.crossesForLayers.containsKey(layer.get((int)i).layer) && this.crossesForLayers.get(layer.get((int)i).layer) <= num2)) {
                        this.crossesForLayers.put(layer.get((int)i).layer, num2);
                        res = true;
                        int level = layer.get((int)0).layer;
                        NodeWrapper tmp = this.layers.get(level).get(i);
                        int tmpindex = this.layers.get((int)level).get((int)i).index;
                        this.layers.get((int)level).get((int)i).index = this.layers.get((int)level).get((int)(i + 1)).index;
                        this.layers.get(level).set(i, this.layers.get(level).get(i + 1));
                        this.layers.get((int)level).get((int)(i + 1)).index = tmpindex;
                        this.layers.get(level).set(i + 1, tmp);
                    }
                    ++i;
                }
            }
            return res;
        }

        @Override
        public void crossReduction(List<List<NodeWrapper>> nodes) {
            this.crossesForLayers.clear();
            this.layers = nodes;
            for (List<NodeWrapper> layer : nodes) {
                for (NodeWrapper node : layer) {
                    this.map.put(node.node, node);
                }
            }
            int iteration = 0;
            boolean change = false;
            while (iteration < 3) {
                change = false;
                int i = 0;
                while (i < nodes.size()) {
                    if (this.greedyHeuristic(this.layers.get(i))) {
                        change = true;
                    }
                    ++i;
                }
                if (change) continue;
                ++iteration;
            }
        }
    }

    public static interface LayerProvider {
        public List<List<NodeWrapper>> calculateLayers(List<INodeLayout> var1);
    }

    public static class NodeWrapper {
        int index;
        final int layer;
        final INodeLayout node;
        final List<NodeWrapper> pred = new LinkedList<NodeWrapper>();
        final List<NodeWrapper> succ = new LinkedList<NodeWrapper>();
        private static final int PADDING = -1;

        NodeWrapper(INodeLayout n, int l) {
            this.node = n;
            this.layer = l;
        }

        NodeWrapper(int l) {
            this(null, l);
        }

        NodeWrapper() {
            this(null, -1);
        }

        void addPredecessor(NodeWrapper node) {
            this.pred.add(node);
        }

        void addSuccessor(NodeWrapper node) {
            this.succ.add(node);
        }

        boolean isDummy() {
            return this.node == null && this.layer != -1;
        }

        boolean isPadding() {
            return this.node == null && this.layer == -1;
        }

        int getBaryCenter(List<NodeWrapper> list) {
            if (list.isEmpty()) {
                return this.index;
            }
            if (list.size() == 1) {
                return list.get((int)0).index;
            }
            double barycenter = 0.0;
            for (NodeWrapper node : list) {
                barycenter += (double)node.index;
            }
            return (int)(barycenter / (double)list.size());
        }

        int getPriorityDown() {
            if (this.isPadding()) {
                return 0;
            }
            if (this.isDummy() && this.succ != null && this.succ.size() > 0) {
                if (this.succ.get(0).isDummy()) {
                    return Integer.MAX_VALUE;
                }
                return 0x3FFFFFFF;
            }
            return this.pred.size();
        }

        int getPriorityUp() {
            if (this.isPadding()) {
                return 0;
            }
            if (this.isDummy() && this.pred != null && this.pred.size() > 0) {
                if (this.pred.get(0).isDummy()) {
                    return Integer.MAX_VALUE;
                }
                return 0x3FFFFFFF;
            }
            return this.succ.size();
        }
    }

    public static class SimpleLayerProvider
    implements LayerProvider {
        private static final int MAX_LAYERS = 10;
        private final List<List<NodeWrapper>> layers = new ArrayList<List<NodeWrapper>>(10);
        private final Map<INodeLayout, NodeWrapper> map = new IdentityHashMap<INodeLayout, NodeWrapper>();

        private static List<INodeLayout> findRoots(List<INodeLayout> list) {
            ArrayList<INodeLayout> roots = new ArrayList<INodeLayout>();
            for (INodeLayout iter : list) {
                if (iter.getPredecessingNodes().length != 0) continue;
                roots.add(iter);
            }
            return roots;
        }

        private void addLayer(List<INodeLayout> list) {
            ArrayList<NodeWrapper> layer = new ArrayList<NodeWrapper>(list.size());
            for (INodeLayout node : list) {
                NodeWrapper nw = new NodeWrapper(node, this.layers.size());
                this.map.put(node, nw);
                layer.add(nw);
                INodeLayout[] iNodeLayoutArray = node.getPredecessingNodes();
                int n = iNodeLayoutArray.length;
                int n2 = 0;
                while (n2 < n) {
                    INodeLayout node_predecessor = iNodeLayoutArray[n2];
                    NodeWrapper nw_predecessor = this.map.get(node_predecessor);
                    if (nw_predecessor != null) {
                        int level = nw_predecessor.layer + 1;
                        while (level < nw.layer) {
                            NodeWrapper nw_dummy = new NodeWrapper(level);
                            nw_dummy.addPredecessor(nw_predecessor);
                            nw_predecessor.addSuccessor(nw_dummy);
                            nw_predecessor = nw_dummy;
                            this.layers.get(level).add(nw_dummy);
                            ++level;
                        }
                        nw.addPredecessor(nw_predecessor);
                        nw_predecessor.addSuccessor(nw);
                    }
                    ++n2;
                }
            }
            this.layers.add(layer);
            SimpleLayerProvider.updateIndex(layer);
        }

        private static void updateIndex(List<NodeWrapper> list) {
            int index = 0;
            while (index < list.size()) {
                list.get((int)index).index = index;
                ++index;
            }
        }

        @Override
        public List<List<NodeWrapper>> calculateLayers(List<INodeLayout> nodes) {
            this.map.clear();
            List<INodeLayout> predecessors = SimpleLayerProvider.findRoots(nodes);
            nodes.removeAll(predecessors);
            this.addLayer(predecessors);
            int level = 1;
            while (!nodes.isEmpty()) {
                if (level > 10) {
                    throw new RuntimeException("Graphical tree exceeds maximum depth of 10! (Graph not directed? Cycles?)");
                }
                ArrayList<INodeLayout> layer = new ArrayList<INodeLayout>();
                for (INodeLayout item : nodes) {
                    if (!predecessors.containsAll(Arrays.asList(item.getPredecessingNodes()))) continue;
                    layer.add(item);
                }
                if (layer.size() == 0) {
                    layer.add(nodes.get(0));
                }
                nodes.removeAll(layer);
                predecessors.addAll(layer);
                this.addLayer(layer);
                ++level;
            }
            return this.layers;
        }
    }

    public static class SplitCrossingReducer
    implements CrossingReducer {
        private final Map<INodeLayout, NodeWrapper> map = new IdentityHashMap<INodeLayout, NodeWrapper>();

        private ArrayList<INodeLayout> unionOfNodes(INodeLayout[] a, INodeLayout[] b) {
            ArrayList<INodeLayout> res = new ArrayList<INodeLayout>();
            int i = 0;
            while (i < a.length) {
                res.add(a[i]);
                ++i;
            }
            i = 0;
            while (i < b.length) {
                if (!res.contains(b[i])) {
                    res.add(b[i]);
                }
                ++i;
            }
            return res;
        }

        private int numberOfCrosses(NodeWrapper nodeA, NodeWrapper nodeB) {
            int numOfCrosses = 0;
            if (nodeA.equals(nodeB)) {
                return 0;
            }
            ArrayList<INodeLayout> adjacentNodesOfA = this.unionOfNodes(nodeA.node.getPredecessingNodes(), nodeA.node.getSuccessingNodes());
            ArrayList<INodeLayout> adjacentNodesOfB = this.unionOfNodes(nodeB.node.getPredecessingNodes(), nodeB.node.getSuccessingNodes());
            for (INodeLayout aNode : adjacentNodesOfA) {
                ArrayList<Integer> alreadyCrossed = new ArrayList<Integer>();
                NodeWrapper aNodeWrapper = this.map.get(aNode);
                int i = 0;
                while (i < adjacentNodesOfB.size()) {
                    NodeWrapper nw = this.map.get(adjacentNodesOfB.get(i));
                    if (!alreadyCrossed.contains(i) && nw != null && (nw.layer > nodeA.layer && aNodeWrapper.layer > nodeA.layer || nw.layer < nodeA.layer && aNodeWrapper.layer < nodeA.layer)) {
                        if (nodeA.index < nodeB.index) {
                            if (aNodeWrapper.index > nw.index) {
                                ++numOfCrosses;
                                alreadyCrossed.add(i);
                            } else if (nw.index == aNodeWrapper.index) {
                                if (nodeA.index >= nw.index) {
                                    if (aNodeWrapper.layer > nw.layer && nodeA.layer < nw.layer || aNodeWrapper.layer < nw.layer && nw.layer < nodeA.layer) {
                                        ++numOfCrosses;
                                        alreadyCrossed.add(i);
                                    }
                                } else if (nodeB.index <= nw.index && (aNodeWrapper.layer > nw.layer && aNodeWrapper.layer < nodeB.layer || aNodeWrapper.layer < nw.layer && aNodeWrapper.layer > nodeB.layer)) {
                                    ++numOfCrosses;
                                    alreadyCrossed.add(i);
                                }
                            }
                        } else if (nodeA.index > nodeB.index) {
                            if (aNodeWrapper.index < nw.index) {
                                ++numOfCrosses;
                                alreadyCrossed.add(i);
                            } else if (nw.index == aNodeWrapper.index) {
                                if (nodeB.index >= nw.index) {
                                    if (aNodeWrapper.layer > nw.layer && nodeB.layer > aNodeWrapper.layer || aNodeWrapper.layer < nw.layer && aNodeWrapper.layer > nodeB.layer) {
                                        ++numOfCrosses;
                                        alreadyCrossed.add(i);
                                    }
                                } else if (nodeA.index <= nw.index && (aNodeWrapper.layer > nw.layer && nw.layer > nodeA.layer || aNodeWrapper.layer < nw.layer && nw.layer < nodeA.layer)) {
                                    ++numOfCrosses;
                                    alreadyCrossed.add(i);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            return numOfCrosses;
        }

        private List<NodeWrapper> splitHeuristic(List<NodeWrapper> layer) {
            ArrayList<NodeWrapper> left = new ArrayList<NodeWrapper>();
            ArrayList<NodeWrapper> right = new ArrayList<NodeWrapper>();
            if (layer.size() < 1) {
                return layer;
            }
            Random random = new Random();
            NodeWrapper pivot = layer.get(random.nextInt(layer.size()));
            for (NodeWrapper node : layer) {
                int num2;
                if (node.equals(pivot) || node.node == null || pivot.node == null) continue;
                int num1 = this.numberOfCrosses(node, pivot);
                if (num1 < (num2 = this.numberOfCrosses(pivot, node))) {
                    left.add(node);
                    continue;
                }
                if (num1 > num2) {
                    right.add(node);
                    continue;
                }
                if (num1 == num2 && num1 > 0) {
                    int tmpindex = this.map.get((Object)pivot.node).index;
                    this.map.get((Object)pivot.node).index = this.map.get((Object)node.node).index;
                    this.map.get((Object)node.node).index = tmpindex;
                }
                if (node.index < pivot.index) {
                    left.add(node);
                    continue;
                }
                right.add(node);
            }
            ArrayList<NodeWrapper> res = new ArrayList<NodeWrapper>();
            res.addAll(this.splitHeuristic(left));
            res.add(pivot);
            res.addAll(this.splitHeuristic(right));
            return res;
        }

        @Override
        public void crossReduction(List<List<NodeWrapper>> nodes) {
            for (List<NodeWrapper> layer : nodes) {
                for (NodeWrapper nw : layer) {
                    this.map.put(nw.node, nw);
                }
            }
            int i = 0;
            while (i < nodes.size()) {
                if (!nodes.get(i).isEmpty()) {
                    this.splitHeuristic(nodes.get(i));
                }
                ++i;
            }
        }
    }
}

