/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.euclidean.Vector;
import org.eclipse.gef4.geometry.internal.utils.PointListUtils;
import org.eclipse.gef4.geometry.internal.utils.PrecisionUtils;
import org.eclipse.gef4.geometry.planar.AbstractGeometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.CubicCurve;
import org.eclipse.gef4.geometry.planar.CurveUtils;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IRotatable;
import org.eclipse.gef4.geometry.planar.IScalable;
import org.eclipse.gef4.geometry.planar.ITranslatable;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.QuadraticCurve;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.geometry.projective.Straight3D;
import org.eclipse.gef4.geometry.projective.Vector3D;

public class BezierCurve
extends AbstractGeometry
implements ICurve,
ITranslatable<BezierCurve>,
IScalable<BezierCurve>,
IRotatable<BezierCurve> {
    private static final long serialVersionUID = 1L;
    private static final int CHUNK_SHIFT = -3;
    private static final boolean ORTHOGONAL = true;
    private static final boolean PARALLEL = false;
    private static final double UNRECOGNIZABLE_PRECISION_FRACTION = PrecisionUtils.calculateFraction(0) / 10.0;
    private static final IPointCmp xminCmp = new IPointCmp(){

        @Override
        public boolean pIsBetterThanQ(Point p, Point q) {
            return PrecisionUtils.smallerEqual(p.x, q.x);
        }
    };
    private static final IPointCmp xmaxCmp = new IPointCmp(){

        @Override
        public boolean pIsBetterThanQ(Point p, Point q) {
            return PrecisionUtils.greaterEqual(p.x, q.x);
        }
    };
    private static final IPointCmp yminCmp = new IPointCmp(){

        @Override
        public boolean pIsBetterThanQ(Point p, Point q) {
            return PrecisionUtils.smallerEqual(p.y, q.y);
        }
    };
    private static final IPointCmp ymaxCmp = new IPointCmp(){

        @Override
        public boolean pIsBetterThanQ(Point p, Point q) {
            return PrecisionUtils.greaterEqual(p.y, q.y);
        }
    };
    private final Vector3D[] points;

    private static IntervalPair[] clusterChunks(IntervalPair[] intervalPairs, int shift) {
        boolean couldMerge;
        ArrayList<IntervalPair> ips = new ArrayList<IntervalPair>();
        ips.addAll(Arrays.asList(intervalPairs));
        Collections.sort(ips, new Comparator<IntervalPair>(){

            @Override
            public int compare(IntervalPair i, IntervalPair j) {
                if (i.pi.a < j.pi.a) {
                    return -1;
                }
                if (i.pi.a > j.pi.a) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<IntervalPair> clusters = new ArrayList<IntervalPair>();
        IntervalPair current = null;
        do {
            clusters.clear();
            couldMerge = false;
            for (IntervalPair i : ips) {
                if (current == null) {
                    current = i.getCopy();
                    continue;
                }
                if (BezierCurve.isNextTo(current, i, shift)) {
                    couldMerge = true;
                    current.expand(i);
                    continue;
                }
                BezierCurve.isNextTo(current, i, shift);
                clusters.add(current);
                current = i.getCopy();
            }
            if (current != null) {
                clusters.add(current);
                current = null;
            }
            ips.clear();
            ips.addAll(clusters);
        } while (couldMerge);
        return clusters.toArray(new IntervalPair[0]);
    }

    private static boolean containmentParameter(BezierCurve c, double[] interval, Point p) {
        Stack<Interval> parts = new Stack<Interval>();
        parts.push(new Interval(interval));
        while (!parts.empty()) {
            Interval i = (Interval)parts.pop();
            if (i.converges(1)) {
                interval[0] = i.a;
                interval[1] = i.b;
                break;
            }
            double iMid = i.getMid();
            Interval left = new Interval(i.a, iMid);
            Interval right = new Interval(iMid, i.b);
            BezierCurve clipped = c.getClipped(left.a, left.b);
            Rectangle bounds = clipped.getControlBounds();
            if (bounds.contains(p)) {
                parts.push(left);
            }
            if (!(bounds = (clipped = c.getClipped(right.a, right.b)).getControlBounds()).contains(p)) continue;
            parts.push(right);
        }
        return PrecisionUtils.equal(interval[0], interval[1], 1);
    }

    private static void copyIntervalPair(IntervalPair dst, IntervalPair src) {
        dst.p = src.p;
        dst.q = src.q;
        dst.pi = src.pi;
        dst.qi = src.qi;
    }

    private static double distanceToBaseLine(BezierCurve c) {
        Straight3D baseLine = Straight3D.through(c.points[0], c.points[c.points.length - 1]);
        if (baseLine == null) {
            return 0.0;
        }
        double maxDistance = 0.0;
        int i = 1;
        while (i < c.points.length - 1) {
            maxDistance = Math.max(maxDistance, Math.abs(baseLine.getSignedDistanceCW(c.points[i])));
            ++i;
        }
        return maxDistance;
    }

    private static IntervalPair extractOverlap(IntervalPair[] intersectionCandidates, IntervalPair[] endPoints) {
        IntervalPair[] chunks;
        IntervalPair[] fineChunks = new IntervalPair[intersectionCandidates.length + endPoints.length];
        int i = 0;
        while (i < intersectionCandidates.length) {
            fineChunks[i] = intersectionCandidates[i];
            ++i;
        }
        i = 0;
        while (i < endPoints.length) {
            fineChunks[intersectionCandidates.length + i] = endPoints[i];
            ++i;
        }
        if (fineChunks.length == 0) {
            return null;
        }
        BezierCurve.normalizeIntervalPairs(fineChunks);
        IntervalPair[] intervalPairArray = chunks = BezierCurve.clusterChunks(fineChunks, -4);
        int n = chunks.length;
        int n2 = 0;
        while (n2 < n) {
            IntervalPair overlap = intervalPairArray[n2];
            if (PrecisionUtils.smallerEqual(overlap.pi.a, 0.0) && PrecisionUtils.greaterEqual(overlap.pi.b, 1.0) || PrecisionUtils.smallerEqual(overlap.qi.a, 0.0) && PrecisionUtils.greaterEqual(overlap.qi.b, 1.0) || (PrecisionUtils.smallerEqual(overlap.pi.a, 0.0) || PrecisionUtils.greaterEqual(overlap.pi.b, 1.0)) && (PrecisionUtils.smallerEqual(overlap.qi.a, 0.0) || PrecisionUtils.greaterEqual(overlap.qi.b, 1.0))) {
                if (PrecisionUtils.smallerEqual(overlap.pi.a, 0.0, -4) && PrecisionUtils.smallerEqual(overlap.pi.b, 0.0, -4) || PrecisionUtils.greaterEqual(overlap.pi.a, 1.0, -4) && PrecisionUtils.greaterEqual(overlap.pi.b, 1.0, -4) || PrecisionUtils.smallerEqual(overlap.qi.a, 0.0, -4) && PrecisionUtils.smallerEqual(overlap.qi.b, 0.0, -4) || PrecisionUtils.greaterEqual(overlap.qi.a, 1.0, -4) && PrecisionUtils.greaterEqual(overlap.qi.b, 1.0, -4)) {
                    return null;
                }
                return BezierCurve.refineOverlap(overlap);
            }
            ++n2;
        }
        return null;
    }

    private static double intersectXAxisParallel(Point p, Point q, double y) {
        double m = (q.y - p.y) / (q.x - p.x);
        return (y - p.y + m * p.x) / m;
    }

    private static boolean isNextTo(Interval i, Interval j, int shift) {
        return PrecisionUtils.smallerEqual(j.a, i.b, shift) && PrecisionUtils.greaterEqual(j.b, i.a, shift);
    }

    private static boolean isNextTo(IntervalPair a, IntervalPair b, int shift) {
        return BezierCurve.isNextTo(a.pi, b.pi, shift) && BezierCurve.isNextTo(a.qi, b.qi, shift);
    }

    private static void normalizeIntervalPairs(IntervalPair[] intervalPairs) {
        if (intervalPairs.length == 0) {
            return;
        }
        BezierCurve pId = intervalPairs[0].p;
        BezierCurve qId = intervalPairs[0].q;
        IntervalPair[] intervalPairArray = intervalPairs;
        int n = intervalPairs.length;
        int n2 = 0;
        while (n2 < n) {
            IntervalPair ip = intervalPairArray[n2];
            if (ip.p != pId) {
                Interval qi = ip.pi;
                Interval pi = ip.qi;
                ip.p = pId;
                ip.q = qId;
                ip.pi = pi;
                ip.qi = qi;
            }
            ++n2;
        }
    }

    private static boolean pointsEquals(Point p1, Point p2, int shift) {
        return PrecisionUtils.equal(p1.x, p2.x, shift) && PrecisionUtils.equal(p1.y, p2.y, shift);
    }

    private static IntervalPair refineOverlap(IntervalPair overlap) {
        Interval piLo = BezierCurve.refineOverlapLo(overlap.p, overlap.pi.a, overlap.pi.getMid(), overlap.q);
        Interval piHi = BezierCurve.refineOverlapHi(overlap.p, overlap.pi.getMid(), overlap.pi.b, overlap.q);
        Interval qiLo = BezierCurve.refineOverlapLo(overlap.q, overlap.qi.a, overlap.qi.getMid(), overlap.p);
        Interval qiHi = BezierCurve.refineOverlapHi(overlap.q, overlap.qi.getMid(), overlap.qi.b, overlap.p);
        overlap.pi.a = piLo.b;
        overlap.pi.b = piHi.a;
        overlap.qi.a = qiLo.b;
        overlap.qi.b = qiHi.a;
        return overlap;
    }

    private static Interval refineOverlapHi(BezierCurve p, double mid, double b, BezierCurve q) {
        Interval i = new Interval(Math.max(mid, 0.0), Math.min(b, 1.0));
        int c = 0;
        while (c++ < 30 && !i.converges()) {
            double prevLo = i.a;
            i.a = i.getMid();
            Point pLo = p.get(i.a);
            if (q.contains(pLo)) continue;
            i.b = i.a;
            i.a = prevLo;
        }
        return i;
    }

    private static Interval refineOverlapLo(BezierCurve p, double a, double mid, BezierCurve q) {
        Interval i = new Interval(Math.max(a, 0.0), Math.min(mid, 1.0));
        int c = 0;
        while (c++ < 30 && !i.converges()) {
            double prevHi = i.b;
            i.b = i.getMid();
            Point pHi = p.get(i.b);
            if (q.contains(pHi)) continue;
            i.a = i.b;
            i.b = prevHi;
        }
        return i;
    }

    public BezierCurve(CubicCurve c) {
        this(c.getP1(), c.getCtrl1(), c.getCtrl2(), c.getP2());
    }

    public BezierCurve(double ... controlPoints) {
        this(PointListUtils.toPointsArray(controlPoints));
    }

    public BezierCurve(Point ... controlPoints) {
        this.points = new Vector3D[controlPoints.length];
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Vector3D(controlPoints[i].x, controlPoints[i].y, 1.0);
            ++i;
        }
    }

    public BezierCurve(QuadraticCurve c) {
        this(c.getP1(), c.getCtrl(), c.getP2());
    }

    private BezierCurve(Vector3D ... controlPoints) {
        this.points = new Vector3D[controlPoints.length];
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = controlPoints[i].getCopy();
            ++i;
        }
    }

    private double[] clipTo(FatLine L) {
        double[] interval = new double[]{1.0, 0.0};
        Vector3D[] differenceVectors = this.genDifferencePoints(L.line);
        Point[] differencePoints = new Point[differenceVectors.length];
        int i = 0;
        while (i < differenceVectors.length) {
            differencePoints[i] = differenceVectors[i].toPoint();
            ++i;
        }
        Point[] pointArray = differencePoints;
        int n = differencePoints.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            if (Double.isNaN(p.y) || L.dmin <= p.y && p.y <= L.dmax) {
                this.moveInterval(interval, p.x);
            }
            ++n2;
        }
        i = 1;
        while (i < differencePoints.length) {
            Line seg = new Line(differencePoints[0], differencePoints[i]);
            if (seg.getP1().y < L.dmin != seg.getP2().y < L.dmin) {
                double x = BezierCurve.intersectXAxisParallel(seg.getP1(), seg.getP2(), L.dmin);
                this.moveInterval(interval, x);
            }
            if (seg.getP1().y < L.dmax != seg.getP2().y < L.dmax) {
                double x = BezierCurve.intersectXAxisParallel(seg.getP1(), seg.getP2(), L.dmax);
                this.moveInterval(interval, x);
            }
            ++i;
        }
        i = 0;
        while (i < differencePoints.length - 1) {
            Line seg = new Line(differencePoints[i], differencePoints[differencePoints.length - 1]);
            if (seg.getP1().y < L.dmin != seg.getP2().y < L.dmin) {
                double x = BezierCurve.intersectXAxisParallel(seg.getP1(), seg.getP2(), L.dmin);
                this.moveInterval(interval, x);
            }
            if (seg.getP1().y < L.dmax != seg.getP2().y < L.dmax) {
                double x = BezierCurve.intersectXAxisParallel(seg.getP1(), seg.getP2(), L.dmax);
                this.moveInterval(interval, x);
            }
            ++i;
        }
        return interval;
    }

    public boolean contains(BezierCurve o) {
        return this.contains(o.getP1()) && this.contains(o.getP2()) && this.getOverlap(o) != null;
    }

    @Override
    public boolean contains(Point p) {
        if (p == null) {
            return false;
        }
        return BezierCurve.containmentParameter(this, new double[]{0.0, 1.0}, p);
    }

    public boolean equals(Object other) {
        Object[] tPoints;
        if (this == other) {
            return true;
        }
        if (!(other instanceof BezierCurve)) {
            return false;
        }
        BezierCurve o = (BezierCurve)other;
        BezierCurve t = this;
        while (o.points.length < t.points.length) {
            o = o.getElevated();
        }
        while (t.points.length < o.points.length) {
            t = t.getElevated();
        }
        Object[] oPoints = o.getPoints();
        return Arrays.equals(oPoints, tPoints = t.getPoints()) || Arrays.equals(oPoints, Point.getReverseCopy((Point[])tPoints));
    }

    private void findEndPointIntersections(IntervalPair ip, Set<IntervalPair> endPointIntervalPairs, Set<Point> intersections) {
        double CHUNK_SHIFT_EPSILON = PrecisionUtils.calculateFraction(-3);
        Point poi = ip.p.points[0].toPoint();
        double[] interval = new double[]{0.0, 1.0};
        if (BezierCurve.containmentParameter(ip.q, interval, poi)) {
            ip.pi.a = CHUNK_SHIFT_EPSILON;
            interval[0] = (interval[0] + interval[1]) / 2.0;
            interval[1] = interval[0] + CHUNK_SHIFT_EPSILON / 2.0;
            interval[0] = interval[0] - CHUNK_SHIFT_EPSILON / 2.0;
            endPointIntervalPairs.add(new IntervalPair(ip.p, new Interval(0.0, ip.pi.a), ip.q, new Interval(interval)));
            intersections.add(poi);
        }
        poi = ip.p.points[ip.p.points.length - 1].toPoint();
        interval[0] = 0.0;
        interval[1] = 1.0;
        if (BezierCurve.containmentParameter(ip.q, interval, poi)) {
            ip.pi.b = 1.0 - CHUNK_SHIFT_EPSILON;
            interval[0] = (interval[0] + interval[1]) / 2.0;
            interval[1] = interval[0] + CHUNK_SHIFT_EPSILON / 2.0;
            interval[0] = interval[0] - CHUNK_SHIFT_EPSILON / 2.0;
            endPointIntervalPairs.add(new IntervalPair(ip.p, new Interval(ip.pi.b, 1.0), ip.q, new Interval(interval)));
            intersections.add(poi);
        }
        poi = ip.q.points[0].toPoint();
        interval[0] = 0.0;
        interval[1] = 1.0;
        if (BezierCurve.containmentParameter(ip.p, interval, poi)) {
            ip.qi.a = CHUNK_SHIFT_EPSILON;
            interval[0] = (interval[0] + interval[1]) / 2.0;
            interval[1] = interval[0] + CHUNK_SHIFT_EPSILON / 2.0;
            interval[0] = interval[0] - CHUNK_SHIFT_EPSILON / 2.0;
            endPointIntervalPairs.add(new IntervalPair(ip.p, new Interval(interval), ip.q, new Interval(0.0, ip.qi.a)));
            intersections.add(poi);
        }
        poi = ip.q.points[ip.q.points.length - 1].toPoint();
        interval[0] = 0.0;
        interval[1] = 1.0;
        if (BezierCurve.containmentParameter(ip.p, interval, poi)) {
            ip.qi.b = 1.0 - CHUNK_SHIFT_EPSILON;
            interval[0] = (interval[0] + interval[1]) / 2.0;
            interval[1] = interval[0] + CHUNK_SHIFT_EPSILON / 2.0;
            interval[0] = interval[0] - CHUNK_SHIFT_EPSILON / 2.0;
            endPointIntervalPairs.add(new IntervalPair(ip.p, new Interval(interval), ip.q, new Interval(ip.qi.b, 1.0)));
            intersections.add(poi);
        }
    }

    private Point findExtreme(IPointCmp cmp) {
        return this.findExtreme(cmp, Interval.getFull());
    }

    private Point findExtreme(IPointCmp cmp, Interval iStart) {
        Stack<Interval> parts = new Stack<Interval>();
        parts.push(iStart);
        Point xtreme = this.getHC(iStart.a).toPoint();
        while (!parts.isEmpty()) {
            Interval i = (Interval)parts.pop();
            BezierCurve clipped = this.getClipped(i.a, i.b);
            Point sp = clipped.points[0].toPoint();
            xtreme = cmp.pIsBetterThanQ(sp, xtreme) ? sp : xtreme;
            Point ep = clipped.points[clipped.points.length - 1].toPoint();
            xtreme = cmp.pIsBetterThanQ(ep, xtreme) ? ep : xtreme;
            boolean everythingWorse = true;
            int j = 1;
            while (j < clipped.points.length - 1) {
                if (!cmp.pIsBetterThanQ(xtreme, clipped.points[j].toPoint())) {
                    everythingWorse = false;
                    break;
                }
                ++j;
            }
            if (everythingWorse) continue;
            double im = i.getMid();
            parts.push(new Interval(im, i.b));
            parts.push(new Interval(i.a, im));
        }
        return xtreme;
    }

    private void findIntersectionChunks(IntervalPair ip, Set<IntervalPair> intervalPairs, Set<Point> intersections) {
        if (ip.converges(-3)) {
            intervalPairs.add(ip.getCopy());
            return;
        }
        BezierCurve pClipped = ip.getPClipped();
        BezierCurve qClipped = ip.getQClipped();
        FatLine L1 = FatLine.from(qClipped, false);
        FatLine L2 = FatLine.from(qClipped, true);
        if (L1 == null || L2 == null) {
            Point poi = ip.q.getHC(ip.qi.getMid()).toPoint();
            double[] interval = new double[]{0.0, 1.0};
            if (poi != null && BezierCurve.containmentParameter(ip.p, interval, poi)) {
                intersections.add(poi);
            }
            return;
        }
        Interval interval = new Interval(pClipped.clipTo(L1));
        Interval intervalOrtho = new Interval(pClipped.clipTo(L2));
        double ratio = ip.pi.scaleTo(interval = Interval.min(interval, intervalOrtho));
        if (ratio < 0.0) {
            return;
        }
        if (ratio > 0.8) {
            if (ip.isPLonger()) {
                IntervalPair[] nip = ip.getPSplit();
                this.findIntersectionChunks(nip[0], intervalPairs, intersections);
                this.findIntersectionChunks(nip[1], intervalPairs, intersections);
            } else {
                IntervalPair[] nip = ip.getQSplit();
                this.findIntersectionChunks(nip[0], intervalPairs, intersections);
                this.findIntersectionChunks(nip[1], intervalPairs, intersections);
            }
            return;
        }
        this.findIntersectionChunks(ip.getSwapped(), intervalPairs, intersections);
    }

    private Point findSinglePreciseIntersection(IntervalPair ipIO) {
        Stack<IntervalPair> partStack = new Stack<IntervalPair>();
        partStack.push(ipIO);
        while (!partStack.isEmpty()) {
            Point q;
            Point p;
            IntervalPair ip = (IntervalPair)partStack.pop();
            if (ip.convergesP() && ip.q.contains(p = ip.p.getHC(ip.pi.a).toPoint())) {
                return p;
            }
            if (ip.convergesQ() && ip.p.contains(q = ip.q.getHC(ip.qi.a).toPoint())) {
                return q;
            }
            if (ip.converges()) {
                Point[] pointArray = ip.p.toPoints(ip.pi);
                int n = pointArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Point pp = pointArray[n2];
                    Point[] pointArray2 = ip.q.toPoints(ip.qi);
                    int n3 = pointArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Point qp = pointArray2[n4];
                        if (pp.equals(qp)) {
                            BezierCurve.copyIntervalPair(ipIO, ip);
                            return pp;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                continue;
            }
            BezierCurve pClipped = ip.getPClipped();
            BezierCurve qClipped = ip.getQClipped();
            FatLine L1 = FatLine.from(qClipped, false);
            FatLine L2 = FatLine.from(qClipped, true);
            if (L1 == null || L2 == null) {
                Point poi = ip.q.getHC(ip.qi.getMid()).toPoint();
                if (!ip.p.contains(poi)) continue;
                BezierCurve.copyIntervalPair(ipIO, ip);
                return poi;
            }
            Interval interval = new Interval(pClipped.clipTo(L1));
            Interval intervalOrtho = new Interval(pClipped.clipTo(L2));
            double ratio = ip.pi.scaleTo(interval = Interval.min(interval, intervalOrtho));
            if (ratio < 0.0) continue;
            if (ratio > 0.8) {
                IntervalPair[] nip = ip.isPLonger() ? ip.getPSplit() : ip.getQSplit();
                partStack.push(nip[1]);
                partStack.push(nip[0]);
                continue;
            }
            partStack.push(ip.getSwapped());
        }
        return null;
    }

    private Vector3D[] genDifferencePoints(Straight3D line) {
        Vector3D[] D = new Vector3D[this.points.length];
        int i = 0;
        while (i < this.points.length) {
            double y = line.getSignedDistanceCW(this.points[i]);
            D[i] = new Vector3D((double)i / (double)(this.points.length - 1), y, 1.0);
            ++i;
        }
        return D;
    }

    public Point get(double t) {
        return this.getHC(t).toPoint();
    }

    @Override
    public Rectangle getBounds() {
        double xmin = this.findExtreme((IPointCmp)BezierCurve.xminCmp).x;
        double xmax = this.findExtreme((IPointCmp)BezierCurve.xmaxCmp).x;
        double ymin = this.findExtreme((IPointCmp)BezierCurve.yminCmp).y;
        double ymax = this.findExtreme((IPointCmp)BezierCurve.ymaxCmp).y;
        return new Rectangle(new Point(xmin, ymin), new Point(xmax, ymax));
    }

    public BezierCurve getClipped(double s, double e) {
        if (s == 1.0) {
            return new BezierCurve(this.points[this.points.length - 1]);
        }
        BezierCurve right = this.split(s)[1];
        double rightT2 = (e - s) / (1.0 - s);
        return right.split(rightT2)[0];
    }

    public Rectangle getControlBounds() {
        Point[] realPoints = this.getPoints();
        double xmin = realPoints[0].x;
        double xmax = realPoints[0].x;
        double ymin = realPoints[0].y;
        double ymax = realPoints[0].y;
        int i = 1;
        while (i < realPoints.length) {
            if (realPoints[i].x < xmin) {
                xmin = realPoints[i].x;
            } else if (realPoints[i].x > xmax) {
                xmax = realPoints[i].x;
            }
            if (realPoints[i].y < ymin) {
                ymin = realPoints[i].y;
            } else if (realPoints[i].y > ymax) {
                ymax = realPoints[i].y;
            }
            ++i;
        }
        return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    @Override
    public BezierCurve getCopy() {
        return new BezierCurve(this.points);
    }

    public BezierCurve getDerivative() {
        Vector3D[] controlPoints = new Vector3D[this.points.length - 1];
        int i = 0;
        while (i < controlPoints.length) {
            controlPoints[i] = this.points[i + 1].getSubtracted(this.points[i]).getScaled(this.points.length - 1);
            controlPoints[i].z = 1.0;
            ++i;
        }
        return new BezierCurve(controlPoints);
    }

    public BezierCurve getElevated() {
        Point[] p = this.getPoints();
        Point[] q = new Point[p.length + 1];
        q[0] = p[0];
        q[p.length] = p[p.length - 1];
        int i = 1;
        while (i < p.length) {
            double c = (double)i / (double)p.length;
            q[i] = p[i - 1].getScaled(c).getTranslated(p[i].getScaled(1.0 - c));
            ++i;
        }
        return new BezierCurve(q);
    }

    private Vector3D getHC(double t) {
        if (t < 0.0 || t > 1.0) {
            throw new IllegalArgumentException("t out of range: " + t);
        }
        int n = this.points.length;
        if (n < 1) {
            return null;
        }
        double bn = 1.0;
        double tn = 1.0;
        double d = 1.0 - t;
        Vector3D pn = this.points[0].getScaled(bn * tn);
        int i = 1;
        while (i < n) {
            bn = bn * (double)(n - i) / (double)i;
            pn = pn.getScaled(d).getAdded(this.points[i].getScaled(bn * (tn *= t)));
            ++i;
        }
        return pn;
    }

    protected Set<IntervalPair> getIntersectionIntervalPairs(BezierCurve other, Set<Point> intersections) {
        HashSet<IntervalPair> intervalPairs = new HashSet<IntervalPair>();
        HashSet<IntervalPair> endPointIntervalPairs = new HashSet<IntervalPair>();
        IntervalPair ip = new IntervalPair(this, Interval.getFull(), other, Interval.getFull());
        this.findEndPointIntersections(ip, endPointIntervalPairs, intersections);
        this.findIntersectionChunks(ip, intervalPairs, intersections);
        BezierCurve.normalizeIntervalPairs(intervalPairs.toArray(new IntervalPair[0]));
        IntervalPair[] clusters = BezierCurve.clusterChunks(intervalPairs.toArray(new IntervalPair[0]), 0);
        IntervalPair overlapIntervalPair = BezierCurve.extractOverlap(clusters, endPointIntervalPairs.toArray(new IntervalPair[0]));
        BezierCurve overlap = overlapIntervalPair == null ? null : overlapIntervalPair.getPClipped();
        HashSet<IntervalPair> results = new HashSet<IntervalPair>();
        for (IntervalPair epip : endPointIntervalPairs) {
            if (overlapIntervalPair == null || !BezierCurve.isNextTo(overlapIntervalPair, epip, -3)) {
                results.add(epip);
                continue;
            }
            Iterator<Point> iterator = intersections.iterator();
            while (iterator.hasNext()) {
                if (!overlap.contains(iterator.next())) continue;
                iterator.remove();
            }
        }
        IntervalPair[] intervalPairArray = clusters;
        int n = clusters.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IntervalPair cluster = intervalPairArray[n2];
                if (overlapIntervalPair == null || !BezierCurve.isNextTo(overlapIntervalPair, cluster, -3)) {
                    for (IntervalPair epip : endPointIntervalPairs) {
                        if (!BezierCurve.isNextTo(cluster, epip, -3)) {
                            continue;
                        }
                        break block9;
                    }
                    Point poi = this.findSinglePreciseIntersection(cluster);
                    if (poi != null) {
                        intersections.add(poi);
                        if (cluster.converges()) {
                            results.add(cluster.getCopy());
                        }
                    }
                }
            }
            ++n2;
        }
        return results;
    }

    public Point[] getIntersections(BezierCurve other) {
        HashSet<Point> intersections = new HashSet<Point>();
        this.getIntersectionIntervalPairs(other, intersections);
        return intersections.toArray(new Point[0]);
    }

    @Override
    public final Point[] getIntersections(ICurve curve) {
        HashSet<Point> intersections = new HashSet<Point>();
        BezierCurve[] bezierCurveArray = curve.toBezier();
        int n = bezierCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve c = bezierCurveArray[n2];
            intersections.addAll(Arrays.asList(this.getIntersections(c)));
            ++n2;
        }
        return intersections.toArray(new Point[0]);
    }

    public BezierCurve getOverlap(BezierCurve other) {
        if (this.equals(other)) {
            return this.getCopy();
        }
        HashSet<Point> intersections = new HashSet<Point>();
        HashSet<IntervalPair> intervalPairs = new HashSet<IntervalPair>();
        HashSet<IntervalPair> endPointIntervalPairs = new HashSet<IntervalPair>();
        IntervalPair ip = new IntervalPair(this, Interval.getFull(), other, Interval.getFull());
        this.findEndPointIntersections(ip, endPointIntervalPairs, intersections);
        this.findIntersectionChunks(ip, intervalPairs, intersections);
        IntervalPair[] intervalPairs2 = intervalPairs.toArray(new IntervalPair[0]);
        BezierCurve.normalizeIntervalPairs(intervalPairs2);
        IntervalPair[] clusters = BezierCurve.clusterChunks(intervalPairs2, 0);
        IntervalPair overlap = BezierCurve.extractOverlap(clusters, endPointIntervalPairs.toArray(new IntervalPair[0]));
        return overlap == null ? null : overlap.getPClipped();
    }

    @Override
    public final ICurve[] getOverlaps(ICurve c) {
        return CurveUtils.getOverlaps(this, c);
    }

    @Override
    public Point getP1() {
        return this.points[0].toPoint();
    }

    @Override
    public Point getP2() {
        return this.points[this.points.length - 1].toPoint();
    }

    public double getParameterAt(Point p) {
        if (p == null) {
            throw new IllegalArgumentException("The passed-in Point may not be null: getParameterAt(" + p + "), this = " + this);
        }
        double[] interval = new double[]{0.0, 1.0};
        if (BezierCurve.containmentParameter(this, interval, p)) {
            return (interval[0] + interval[1]) / 2.0;
        }
        throw new IllegalArgumentException("The given Point does not lie on this BezierCurve: getParameterAt(" + p + "), this = " + this);
    }

    public Point getPoint(int i) {
        if (i < 0 || i >= this.points.length) {
            throw new IllegalArgumentException("You can only index this BezierCurve's points from 0 to " + (this.points.length - 1) + ": getPoint(" + i + "), this = " + this);
        }
        return this.points[i].toPoint();
    }

    public Point[] getPoints() {
        Point[] realPoints = new Point[this.points.length];
        int i = 0;
        while (i < this.points.length) {
            realPoints[i] = this.points[i].toPoint();
            ++i;
        }
        return realPoints;
    }

    private Vector3D[] getPointsCopy() {
        Vector3D[] copy = new Vector3D[this.points.length];
        int i = 0;
        while (i < this.points.length) {
            copy[i] = this.points[i].getCopy();
            ++i;
        }
        return copy;
    }

    @Override
    public Point getProjection(final Point reference) {
        IPointCmp cmp = new IPointCmp(){

            @Override
            public boolean pIsBetterThanQ(Point p, Point q) {
                return p.getDistance(reference) < q.getDistance(reference);
            }
        };
        Point extremeProjection = this.findExtreme(cmp, Interval.getFull());
        return extremeProjection;
    }

    @Override
    public BezierCurve getRotatedCCW(Angle angle) {
        return this.getCopy().rotateCCW(angle);
    }

    @Override
    public BezierCurve getRotatedCCW(Angle angle, double cx, double cy) {
        return this.getCopy().rotateCCW(angle, cx, cy);
    }

    @Override
    public BezierCurve getRotatedCCW(Angle angle, Point center) {
        return this.getCopy().rotateCCW(angle, center);
    }

    @Override
    public BezierCurve getRotatedCW(Angle angle) {
        return this.getCopy().rotateCW(angle);
    }

    @Override
    public BezierCurve getRotatedCW(Angle angle, double cx, double cy) {
        return this.getCopy().rotateCW(angle, cx, cy);
    }

    @Override
    public BezierCurve getRotatedCW(Angle angle, Point center) {
        return this.getCopy().rotateCW(angle, center);
    }

    @Override
    public BezierCurve getScaled(double factor) {
        return this.getCopy().getScaled(factor);
    }

    @Override
    public BezierCurve getScaled(double fx, double fy) {
        return this.getCopy().getScaled(fx, fy);
    }

    @Override
    public BezierCurve getScaled(double factor, double cx, double cy) {
        return this.getCopy().getScaled(factor, cx, cy);
    }

    @Override
    public BezierCurve getScaled(double fx, double fy, double cx, double cy) {
        return this.getCopy().getScaled(fx, fy, cx, cy);
    }

    @Override
    public BezierCurve getScaled(double fx, double fy, Point center) {
        return this.getCopy().getScaled(fx, fy, center);
    }

    @Override
    public BezierCurve getScaled(double factor, Point center) {
        return this.getCopy().getScaled(factor, center);
    }

    @Override
    public BezierCurve getTransformed(AffineTransform t) {
        return new BezierCurve(t.getTransformed(this.getPoints()));
    }

    @Override
    public BezierCurve getTranslated(double dx, double dy) {
        return this.getCopy().translate(dx, dy);
    }

    @Override
    public BezierCurve getTranslated(Point d) {
        return this.getCopy().translate(d.x, d.y);
    }

    @Override
    public double getX1() {
        return this.getP1().x;
    }

    @Override
    public double getX2() {
        return this.getP2().x;
    }

    @Override
    public double getY1() {
        return this.getP1().y;
    }

    @Override
    public double getY2() {
        return this.getP2().y;
    }

    @Override
    public boolean intersects(ICurve c) {
        return this.getIntersections(c).length > 0;
    }

    private void moveInterval(double[] interval, double x) {
        if (x < 0.0) {
            x = 0.0;
        } else if (x > 1.0) {
            x = 1.0;
        }
        if (interval[0] > x) {
            interval[0] = x;
        }
        if (interval[1] < x) {
            interval[1] = x;
        }
    }

    public boolean overlaps(BezierCurve other) {
        return this.getOverlap(other) != null;
    }

    @Override
    public final boolean overlaps(ICurve c) {
        BezierCurve[] bezierCurveArray = c.toBezier();
        int n = bezierCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve seg = bezierCurveArray[n2];
            if (this.overlaps(seg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public BezierCurve rotateCCW(Angle angle) {
        Point centroid = Point.getCentroid(this.getPoints());
        return this.rotateCCW(angle, centroid.x, centroid.y);
    }

    public BezierCurve rotateCCW(Angle angle, double cx, double cy) {
        Point[] realPoints = this.getPoints();
        Point.rotateCCW(realPoints, angle, cx, cy);
        int i = 0;
        while (i < realPoints.length) {
            this.setPoint(i, realPoints[i]);
            ++i;
        }
        return this;
    }

    public BezierCurve rotateCCW(Angle angle, Point center) {
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new Vector3D(new Vector(this.points[i].toPoint().getTranslated(center.getNegated())).getRotatedCCW(angle).toPoint().getTranslated(center));
            ++i;
        }
        return this;
    }

    public BezierCurve rotateCW(Angle angle) {
        Point centroid = Point.getCentroid(this.getPoints());
        return this.rotateCW(angle, centroid.x, centroid.y);
    }

    public BezierCurve rotateCW(Angle angle, double cx, double cy) {
        Point[] realPoints = this.getPoints();
        Point.rotateCW(realPoints, angle, cx, cy);
        int i = 0;
        while (i < realPoints.length) {
            this.setPoint(i, realPoints[i]);
            ++i;
        }
        return this;
    }

    public BezierCurve rotateCW(Angle angle, Point center) {
        return this.rotateCW(angle, center.x, center.y);
    }

    @Override
    public BezierCurve scale(double factor) {
        return this.scale(factor, factor);
    }

    @Override
    public BezierCurve scale(double fx, double fy) {
        Point centroid = Point.getCentroid(this.getPoints());
        return this.scale(fx, fy, centroid.x, centroid.y);
    }

    @Override
    public BezierCurve scale(double factor, double cx, double cy) {
        return this.scale(factor, factor, cx, cy);
    }

    @Override
    public BezierCurve scale(double fx, double fy, double cx, double cy) {
        Point[] realPoints = this.getPoints();
        Point.scale(realPoints, fx, fy, cx, cy);
        int i = 0;
        while (i < realPoints.length) {
            this.setPoint(i, realPoints[i]);
            ++i;
        }
        return this;
    }

    @Override
    public BezierCurve scale(double fx, double fy, Point center) {
        return this.scale(fx, fy, center.x, center.y);
    }

    @Override
    public BezierCurve scale(double factor, Point center) {
        return this.scale(factor, factor, center.x, center.y);
    }

    public BezierCurve setP1(Point p1) {
        this.setPoint(0, p1);
        return this;
    }

    public BezierCurve setP2(Point p2) {
        this.setPoint(this.points.length - 1, p2);
        return this;
    }

    public BezierCurve setPoint(int i, Point p) {
        if (i < 0 || i >= this.points.length) {
            throw new IllegalArgumentException("setPoint(" + i + ", " + p + "): You can only index this BezierCurve's points from 0 to " + (this.points.length - 1) + ".");
        }
        this.points[i] = new Vector3D(p);
        return this;
    }

    public BezierCurve[] split(double t) {
        Vector3D[] leftPoints = new Vector3D[this.points.length];
        Vector3D[] rightPoints = new Vector3D[this.points.length];
        Vector3D[] ratioPoints = this.getPointsCopy();
        int i = 0;
        while (i < this.points.length) {
            leftPoints[i] = ratioPoints[0];
            rightPoints[this.points.length - 1 - i] = ratioPoints[this.points.length - 1 - i];
            int j = 0;
            while (j < this.points.length - i - 1) {
                ratioPoints[j] = ratioPoints[j].getRatio(ratioPoints[j + 1], t);
                ++j;
            }
            ++i;
        }
        return new BezierCurve[]{new BezierCurve(leftPoints), new BezierCurve(rightPoints)};
    }

    @Override
    public BezierCurve[] toBezier() {
        return new BezierCurve[]{this};
    }

    public CubicCurve toCubic() {
        if (this.points.length > 3) {
            return new CubicCurve(this.points[0].toPoint(), this.points[1].toPoint(), this.points[2].toPoint(), this.points[this.points.length - 1].toPoint());
        }
        return null;
    }

    public Line toLine() {
        if (this.points.length > 1) {
            return new Line(this.points[0].toPoint(), this.points[this.points.length - 1].toPoint());
        }
        return null;
    }

    public Line[] toLineStrip(double lineSimilarity) {
        return this.toLineStrip(lineSimilarity, Interval.getFull());
    }

    public Line[] toLineStrip(double lineSimilarity, Interval startInterval) {
        ArrayList<Line> lines = new ArrayList<Line>();
        Point startPoint = this.getHC(startInterval.a).toPoint();
        Stack<Interval> parts = new Stack<Interval>();
        parts.push(startInterval);
        while (!parts.isEmpty()) {
            Interval i = (Interval)parts.pop();
            BezierCurve part = this.getClipped(i.a, i.b);
            if (BezierCurve.distanceToBaseLine(part) < lineSimilarity) {
                Point endPoint = this.getHC(i.b).toPoint();
                lines.add(new Line(startPoint, endPoint));
                startPoint = endPoint;
                continue;
            }
            double im = i.getMid();
            parts.push(new Interval(im, i.b));
            parts.push(new Interval(i.a, im));
        }
        return lines.toArray(new Line[0]);
    }

    @Override
    public Path toPath() {
        Path path = new Path();
        Point startPoint = this.points[0].toPoint();
        path.moveTo(startPoint.x, startPoint.y);
        Line[] lineArray = this.toLineStrip(0.25);
        int n = lineArray.length;
        int n2 = 0;
        while (n2 < n) {
            Line seg = lineArray[n2];
            path.lineTo(seg.getX2(), seg.getY2());
            ++n2;
        }
        return path;
    }

    public Point[] toPoints(Interval startInterval) {
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(this.getHC(startInterval.a).toPoint());
        Stack<Interval> parts = new Stack<Interval>();
        parts.push(startInterval);
        while (!parts.isEmpty()) {
            Interval i = (Interval)parts.pop();
            BezierCurve part = this.getClipped(i.a, i.b);
            Point[] partPoints = part.getPoints();
            boolean allTogether = true;
            int j = 1;
            while (j < partPoints.length) {
                if (!partPoints[0].equals(partPoints[j])) {
                    allTogether = false;
                    break;
                }
                ++j;
            }
            if (allTogether) {
                points.add(partPoints[partPoints.length - 1]);
                continue;
            }
            double im = i.getMid();
            parts.push(new Interval(im, i.b));
            parts.push(new Interval(i.a, im));
        }
        return points.toArray(new Point[0]);
    }

    public QuadraticCurve toQuadratic() {
        if (this.points.length > 2) {
            return new QuadraticCurve(this.points[0].toPoint(), this.points[1].toPoint(), this.points[this.points.length - 1].toPoint());
        }
        return null;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("BezierCurve(");
        int i = 0;
        while (i < this.points.length) {
            Vector3D v = this.points[i];
            str.append(v);
            if (i < this.points.length - 1) {
                str.append(", ");
            }
            ++i;
        }
        str.append(")");
        return str.toString();
    }

    @Override
    public BezierCurve translate(double dx, double dy) {
        Point[] realPoints = this.getPoints();
        Point.translate(realPoints, dx, dy);
        int i = 0;
        while (i < realPoints.length) {
            this.setPoint(i, realPoints[i]);
            ++i;
        }
        return this;
    }

    @Override
    public BezierCurve translate(Point d) {
        return this.translate(d.x, d.y);
    }

    private static class FatLine {
        public Straight3D line = null;
        public double dmin = 0.0;
        public double dmax = 0.0;

        public static FatLine from(BezierCurve c, boolean ortho) {
            FatLine L = new FatLine();
            L.dmax = 0.0;
            L.dmin = 0.0;
            L.line = Straight3D.through(c.points[0], c.points[c.points.length - 1]);
            if (L.line == null) {
                return null;
            }
            if (ortho) {
                L.line = L.line.getOrtho();
            }
            if (L.line == null) {
                return null;
            }
            int i = 0;
            while (i < c.points.length) {
                double d = L.line.getSignedDistanceCW(c.points[i]);
                if (d < L.dmin) {
                    L.dmin = d;
                } else if (d > L.dmax) {
                    L.dmax = d;
                }
                ++i;
            }
            return L;
        }

        private FatLine() {
        }
    }

    private static interface IPointCmp {
        public boolean pIsBetterThanQ(Point var1, Point var2);
    }

    static final class Interval {
        public double a;
        public double b;

        public static Interval getEmpty() {
            return new Interval(1.0, 0.0);
        }

        public static Interval getFull() {
            return new Interval(0.0, 1.0);
        }

        public static Interval min(Interval i, Interval j) {
            return i.b - i.a > j.b - j.a ? j : i;
        }

        public Interval(double ... ds) {
            if (ds.length <= 1) {
                throw new IllegalArgumentException("not enough values to create interval");
            }
            this.a = ds[0];
            this.b = ds[1];
        }

        public boolean converges() {
            return this.converges(0);
        }

        public boolean converges(int shift) {
            return PrecisionUtils.equal(this.a, this.b, shift);
        }

        public void expand(Interval i) {
            if (i.a < this.a) {
                this.a = i.a;
            }
            if (i.b > this.b) {
                this.b = i.b;
            }
        }

        public Interval getCopy() {
            return new Interval(this.a, this.b);
        }

        public double getMid() {
            return (this.a + this.b) / 2.0;
        }

        public double scaleTo(Interval interval) {
            double na = this.a + interval.a * (this.b - this.a);
            double nb = this.a + interval.b * (this.b - this.a);
            double ratio = (nb - na) / (this.b - this.a);
            this.a = na;
            this.b = nb;
            return ratio;
        }
    }

    static final class IntervalPair {
        public BezierCurve p;
        public BezierCurve q;
        public Interval pi;
        public Interval qi;

        public IntervalPair(BezierCurve pp, Interval pt, BezierCurve pq, Interval pu) {
            this.p = pp;
            this.pi = pt;
            this.q = pq;
            this.qi = pu;
        }

        public boolean converges() {
            return this.converges(0);
        }

        public boolean converges(int shift) {
            return !(!this.pi.converges(shift) && !BezierCurve.pointsEquals(this.p.getHC(this.pi.a).toPoint(), this.p.getHC(this.pi.b).toPoint(), shift) || !this.qi.converges(shift) && !BezierCurve.pointsEquals(this.q.getHC(this.qi.a).toPoint(), this.q.getHC(this.qi.b).toPoint(), shift));
        }

        public boolean convergesP() {
            return BezierCurve.pointsEquals(this.p.getHC(this.pi.a).toPoint(), this.p.getHC(this.pi.b).toPoint(), 0);
        }

        public boolean convergesQ() {
            return BezierCurve.pointsEquals(this.q.getHC(this.qi.a).toPoint(), this.q.getHC(this.qi.b).toPoint(), 0);
        }

        public void expand(IntervalPair ip) {
            if (this.p == ip.p) {
                this.pi.expand(ip.pi);
                this.qi.expand(ip.qi);
            } else {
                this.pi.expand(ip.qi);
                this.qi.expand(ip.pi);
            }
        }

        public IntervalPair getCopy() {
            return new IntervalPair(this.p, this.pi.getCopy(), this.q, this.qi.getCopy());
        }

        public BezierCurve getPClipped() {
            return this.p.getClipped(Math.max(this.pi.a, 0.0), Math.min(this.pi.b, 1.0));
        }

        public IntervalPair[] getPSplit() {
            double pm = (this.pi.a + this.pi.b) / 2.0;
            return new IntervalPair[]{new IntervalPair(this.p, new Interval(this.pi.a, pm), this.q, this.qi.getCopy()), new IntervalPair(this.p, new Interval(pm + 10.0 * UNRECOGNIZABLE_PRECISION_FRACTION, this.pi.b), this.q, this.qi.getCopy())};
        }

        public BezierCurve getQClipped() {
            return this.q.getClipped(Math.max(this.qi.a, 0.0), Math.min(this.qi.b, 1.0));
        }

        public IntervalPair[] getQSplit() {
            double qm = (this.qi.a + this.qi.b) / 2.0;
            return new IntervalPair[]{new IntervalPair(this.q, new Interval(this.qi.a, qm), this.p, this.pi.getCopy()), new IntervalPair(this.q, new Interval(qm + 10.0 * UNRECOGNIZABLE_PRECISION_FRACTION, this.qi.b), this.p, this.pi.getCopy())};
        }

        public IntervalPair getSwapped() {
            return new IntervalPair(this.q, this.qi.getCopy(), this.p, this.pi.getCopy());
        }

        public boolean isPLonger() {
            return this.pi.b - this.pi.a > this.qi.b - this.qi.a;
        }
    }
}

